"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout = require("../flyout");
var _collapsible_nav = require("./collapsible_nav.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "as", "size", "side", "ownFocus", "outsideClickCloses", "closeButtonPosition", "paddingSize", "focusTrapProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Extend all the flyout props except `onClose` because we handle this internally
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiCollapsibleNav = exports.EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$isDocked = _ref.isDocked,
    isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
    _ref$isOpen = _ref.isOpen,
    isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
    button = _ref.button,
    _ref$showButtonIfDock = _ref.showButtonIfDocked,
    showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
    _ref$dockedBreakpoint = _ref.dockedBreakpoint,
    dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 'l' : _ref$dockedBreakpoint,
    _ref$as = _ref.as,
    as = _ref$as === void 0 ? 'nav' : _ref$as,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 320 : _ref$size,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    _ref$outsideClickClos = _ref.outsideClickCloses,
    outsideClickCloses = _ref$outsideClickClos === void 0 ? true : _ref$outsideClickClos,
    _ref$closeButtonPosit = _ref.closeButtonPosition,
    closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'outside' : _ref$closeButtonPosit,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$focusTrapProps = _ref.focusTrapProps,
    _focusTrapProps = _ref$focusTrapProps === void 0 ? {} : _ref$focusTrapProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var flyoutID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var buttonRef = (0, _react.useRef)();
  var combinedButtonRef = (0, _services.useCombinedRefs)([button === null || button === void 0 ? void 0 : button.props.ref, buttonRef]);
  var focusTrapProps = _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
    shards: [buttonRef].concat(_toConsumableArray(_focusTrapProps.shards || []))
  });
  var windowIsLargeEnoughToPush = (0, _services.useIsWithinMinBreakpoint)(dockedBreakpoint);
  var navIsDocked = isDocked && windowIsLargeEnoughToPush;
  var flyoutType = navIsDocked ? 'push' : 'overlay';
  var classes = (0, _classnames.default)('euiCollapsibleNav', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav.euiCollapsibleNavStyles);
  var cssStyles = [styles.euiCollapsibleNav, styles[flyoutType]];

  // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false
  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && /*#__PURE__*/(0, _react.cloneElement)(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    // When EuiOutsideClickDetector is enabled, we don't want both the toggle button and document touches/clicks to happen, they'll cancel eachother out
    onTouchEnd: function onTouchEnd(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    onMouseUpCapture: function onMouseUpCapture(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    ref: combinedButtonRef
  });
  var flyout = (0, _react2.jsx)(_flyout.EuiFlyout, _extends({
    id: flyoutID,
    css: cssStyles,
    className: classes
    // Flyout props we set different defaults for
    ,
    as: as,
    size: size,
    side: side,
    ownFocus: ownFocus,
    outsideClickCloses: outsideClickCloses,
    closeButtonPosition: closeButtonPosition,
    paddingSize: paddingSize,
    focusTrapProps: focusTrapProps
  }, rest, {
    // Props dependent on internal docked status
    type: flyoutType,
    hideCloseButton: navIsDocked,
    pushMinBreakpoint: dockedBreakpoint
  }), children);
  return (0, _react2.jsx)(_react.default.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};
EuiCollapsibleNav.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Sets the HTML element for `EuiFlyout`
     */
  as: _propTypes.default.any,
  onClose: _propTypes.default.func.isRequired,
  /**
     * Defines the width of the panel.
     * Pass a predefined size of `s | m | l`, or pass any number/string compatible with the CSS `width` attribute
     * @default m
     */
  size: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  /**
     * Sets the max-width of the panel,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     * @default false
     */
  maxWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Customize the padding around the content of the flyout header, body and footer
     * @default l
     */
  paddingSize: _propTypes.default.any,
  /**
     * Adds an EuiOverlayMask and wraps in an EuiPortal
     * @default true
     */
  ownFocus: _propTypes.default.bool,
  /**
     * Hides the default close button. You must provide another close button somewhere within the flyout.
     * @default false
     */
  hideCloseButton: _propTypes.default.bool,
  /**
     * Extends EuiButtonIconProps onto the close button
     */
  closeButtonProps: _propTypes.default.any,
  /**
     * Position of close button.
     * `inside`: Floating to just inside the flyout, always top right;
     * `outside`: Floating just outside the flyout near the top (side dependent on `side`). Helpful when the close button may cover other interactable content.
     * @default inside
     */
  closeButtonPosition: _propTypes.default.oneOf(["inside", "outside"]),
  /**
     * Adjustments to the EuiOverlayMask that is added when `ownFocus = true`
     */
  maskProps: _propTypes.default.shape({
    /**
       * ReactNode to render as this component's content
       */
    children: _propTypes.default.node,
    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: _propTypes.default.oneOf(["above", "below"]),
    /**
       * React ref to be passed to the wrapping container
       */
    maskRef: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired])
  }),
  /**
     * Forces this interaction on the mask overlay or body content.
     * Defaults depend on `ownFocus` and `type` values
     */
  outsideClickCloses: _propTypes.default.bool,
  /**
     * Which side of the window to attach to.
     * The `left` option should only be used for navigation.
     * @default right
     */
  side: _propTypes.default.any,
  /**
     * Named breakpoint (`xs` through `xl`) for customizing the minimum window width to enable docking
     */
  pushMinBreakpoint: _propTypes.default.any,
  /**
     * Enables a slide in animation on push flyouts
     * @default false
     */
  pushAnimation: _propTypes.default.bool,
  style: _propTypes.default.any,
  /**
     * Object of props passed to EuiFocusTrap.
     * `shards` specifies an array of elements that will be considered part of the flyout, preventing the flyout from being closed when clicked.
     * `closeOnMouseup` will delay the close callback, allowing time for external toggle buttons to handle close behavior.
     */
  focusTrapProps: _propTypes.default.any,
  /**
     * By default, EuiFlyout will consider any fixed `EuiHeader`s that sit alongside or above the EuiFlyout
     * as part of the flyout's focus trap. This prevents focus fighting with interactive elements
     * within fixed headers.
     *
     * Set this to `false` if you need to disable this behavior for a specific reason.
     */
  includeFixedHeadersInFocusTrap: _propTypes.default.bool,
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node,
  /**
     * Shows the navigation flyout
     */
  isOpen: _propTypes.default.bool,
  /**
     * Keeps navigation flyout visible and push `<body>` content via padding
     */
  isDocked: _propTypes.default.bool,
  dockedBreakpoint: _propTypes.default.any,
  /**
     * Button for controlling visible state of the nav
     */
  button: _propTypes.default.element,
  /**
     * Keeps the display of toggle button when in docked state
     */
  showButtonIfDocked: _propTypes.default.bool
};