"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCardTextStyles = exports.euiCardStyles = exports.euiCardBetaBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../global_styling/mixins");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var paddingKey = 'm';
var halfPaddingKey = 's';

/**
 * 1. Footer is always at the bottom.
 * 3. Horizontal layouts should always top left align no matter the textAlign prop
 * 4. Ensures the contents always stretch no matter the flex layout
 */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "reymun-disabled",
  styles: "filter:grayscale(100%);label:disabled;"
} : {
  name: "reymun-disabled",
  styles: "filter:grayscale(100%);label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "cr3wz7-euiCard__content",
  styles: "flex-grow:1;label:euiCard__content;"
} : {
  name: "cr3wz7-euiCard__content",
  styles: "flex-grow:1;label:euiCard__content;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1kw0yxn-horizontal",
  styles: "flex-direction:row;align-items:flex-start;label:horizontal;"
} : {
  name: "1kw0yxn-horizontal",
  styles: "flex-direction:row;align-items:flex-start;label:horizontal;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "omnk2l-vertical",
  styles: "flex-direction:column;label:vertical;"
} : {
  name: "omnk2l-vertical",
  styles: "flex-direction:column;label:vertical;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref6 = process.env.NODE_ENV === "production" ? {
  name: "1lyvdpf-euiCard__main",
  styles: "display:flex;inline-size:100%;flex-grow:1;label:euiCard__main;"
} : {
  name: "1lyvdpf-euiCard__main",
  styles: "display:flex;inline-size:100%;flex-grow:1;label:euiCard__main;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCardStyles = exports.euiCardStyles = function euiCardStyles(euiThemeContext, paddingSize) {
  var euiTheme = euiThemeContext.euiTheme;
  var paddingAmount = (0, _global_styling.euiPaddingSize)(euiThemeContext, paddingSize);
  var cardPaddingAmount = paddingAmount ? (0, _global_styling.mathWithUnits)([paddingAmount, euiTheme.border.width.thin], function (x, y) {
    return x + y;
  }) : '0';
  var spacing = (0, _global_styling.euiPaddingSize)(euiThemeContext, paddingKey);
  var halfSpacing = (0, _global_styling.euiPaddingSize)(euiThemeContext, halfPaddingKey);
  return {
    card: {
      euiCard: /*#__PURE__*/(0, _react.css)("display:flex;align-items:flex-start;justify-content:space-between;flex-direction:column;&:has(\n            [class*='euiCard__text'][class*='-interactive']:focus:focus-visible\n          ){outline:", euiTheme.focus.width, " solid currentColor;};label:euiCard;"),
      aligned: {
        center: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('center'), " align-items:center;;label:center;"),
        left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), " align-items:flex-start;;label:left;"),
        right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), " align-items:flex-end;;label:right;")
      },
      disabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;background-color:", (0, _mixins.euiButtonColor)(euiThemeContext, 'disabled'), ";color:", euiTheme.colors.disabledText, ";;label:disabled;")
    },
    main: {
      euiCard__main: _ref6,
      layout: {
        vertical: _ref5,
        horizontal: _ref4
      }
    },
    content: {
      euiCard__content: _ref3,
      layout: {
        vertical: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:vertical;"),
        horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', 'auto'), ";;label:horizontal;")
      }
    },
    euiCard__children: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', halfSpacing), ";;label:euiCard__children;"),
    euiCard__description: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', halfSpacing), ";;label:euiCard__description;"),
    euiCard__footer: /*#__PURE__*/(0, _react.css)("flex-grow:0;", (0, _global_styling.logicalCSS)('width', '100%'), (0, _global_styling.logicalCSS)('margin-top', spacing), ";;label:euiCard__footer;"),
    top: {
      euiCard__top: /*#__PURE__*/(0, _react.css)("flex-grow:0;font-size:0;position:relative;", (0, _global_styling.logicalCSS)('margin-bottom', spacing), ";;label:euiCard__top;"),
      layout: {
        vertical: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:vertical;"),
        horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', 'auto'), ";;label:horizontal;")
      },
      disabled: _ref2
    },
    image: {
      euiCard__image: /*#__PURE__*/(0, _react.css)("position:relative;overflow:hidden;", (0, _global_styling.logicalCSS)('width', "calc(100% + (".concat(cardPaddingAmount, " * 2))")), " ", (0, _global_styling.logicalCSS)('left', "-".concat(cardPaddingAmount)), " ", (0, _global_styling.logicalCSS)('top', "-".concat(cardPaddingAmount)), (0, _global_styling.logicalCSS)('margin-bottom', "-".concat(paddingAmount)), (0, _global_styling.logicalCSS)('border-top-left-radius', "calc(".concat(euiTheme.border.radius.medium, " - ").concat(euiTheme.border.width.thin, ")")), " ", _global_styling.logicals['border-top-right-radius'], ":calc(", euiTheme.border.radius.medium, " - ", euiTheme.border.width.thin, ");img{", (0, _global_styling.logicalCSS)('width', '100%'), ";};label:euiCard__image;"),
      transparent: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:transparent;")
    },
    icon: {
      euiCard__icon: /*#__PURE__*/(0, _react.css)(";label:euiCard__icon;"),
      withImage: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('top', '50%'), " ", (0, _global_styling.logicalCSS)('left', '50%'), "transform:translate(\n          -50%,\n          calc(-50% + -", paddingAmount, ")\n        )!important;;label:withImage;"),
      layout: {
        vertical: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', halfSpacing), ";;label:vertical;"),
        horizontal: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', spacing), ";;label:horizontal;")
      }
    }
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "r8agzg-euiCard__text",
  styles: "font:inherit;color:inherit;cursor:inherit;label:euiCard__text;"
} : {
  name: "r8agzg-euiCard__text",
  styles: "font:inherit;color:inherit;cursor:inherit;label:euiCard__text;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCardTextStyles = exports.euiCardTextStyles = function euiCardTextStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCard__text: _ref,
    interactive: /*#__PURE__*/(0, _react.css)("outline-offset:", euiTheme.size.xxs, ";.euiCard:hover &,.euiCard:focus &,&:hover,&:focus{text-decoration:underline;};label:interactive;"),
    aligned: {
      center: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('center'), ";;label:center;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), ";;label:left;"),
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), ";;label:right;")
    },
    disabled: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.disabledText, ";;label:disabled;")
  };
};
var euiCardBetaBadgeStyles = exports.euiCardBetaBadgeStyles = function euiCardBetaBadgeStyles(euiThemeContext, paddingSize) {
  var euiTheme = euiThemeContext.euiTheme;
  var padding = (0, _global_styling.euiPaddingSize)(euiThemeContext, paddingSize);
  return {
    hasBetaBadge: /*#__PURE__*/(0, _react.css)("position:relative;overflow:visible;", (0, _global_styling.logicalCSS)('padding-top', "calc(".concat(padding, " + ").concat(euiTheme.size.s, ")")), ";;label:hasBetaBadge;"),
    euiCard__betaBadgeAnchor: /*#__PURE__*/(0, _react.css)("line-height:0;position:absolute;", (0, _global_styling.logicalCSS)('top', '0'), " ", (0, _global_styling.logicalCSS)('left', '50%'), " transform:translateX(-50%) translateY(-50%);z-index:3;", (0, _global_styling.logicalCSS)('min-width', "min(30%, ".concat(euiTheme.base * 7, "px)")), " ", (0, _global_styling.logicalCSS)('max-width', "calc(100% - (".concat(padding, " * 2))")), ";;label:euiCard__betaBadgeAnchor;"),
    euiCard__betaBadge: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:euiCard__betaBadge;")
  };
};