"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBreadcrumbsListStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1bwn7gf-isTruncated",
  styles: "flex-wrap:nowrap;white-space:nowrap;label:isTruncated;"
} : {
  name: "1bwn7gf-isTruncated",
  styles: "flex-wrap:nowrap;white-space:nowrap;label:isTruncated;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBreadcrumbsListStyles = exports.euiBreadcrumbsListStyles = function euiBreadcrumbsListStyles(euiThemeContext) {
  // Styles cast to the <ol> element
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiBreadcrumbs__list: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), " align-items:center;display:flex;flex-wrap:wrap;line-height:", euiTheme.size.l, ";", (0, _global_styling.logicalCSS)(
    // Add vertical space between breadcrumbs, but make sure the whole breadcrumb set doesn't add space below itself
    'margin-bottom', "-".concat(euiTheme.size.xs)), " ", (0, _global_styling.logicalCSS)(
    // Ensure it shrinks if the window is narrow
    'min-width', 0), ";;label:euiBreadcrumbs__list;"),
    isTruncated: _ref
  };
};