"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTime = addTime;
exports.subtractTime = subtractTime;
exports.getUnixTimestamp = getUnixTimestamp;
exports.startOf = startOf;
exports.endOf = endOf;
exports.getUTCOffset = getUTCOffset;
exports.formatTime = formatTime;
exports.diff = diff;
const moment_1 = require("./moment");
function addTime(dateTime, timeZone, unit, count) {
    return (0, moment_1.timeObjToUnixTimestamp)((0, moment_1.addTimeToObj)(getTimeObj(dateTime, timeZone), unit, count));
}
function subtractTime(dateTime, timeZone, unit, count) {
    return (0, moment_1.timeObjToUnixTimestamp)((0, moment_1.subtractTimeToObj)(getTimeObj(dateTime, timeZone), unit, count));
}
function getUnixTimestamp(dateTime, timeZone) {
    return (0, moment_1.timeObjToUnixTimestamp)(getTimeObj(dateTime, timeZone));
}
function startOf(dateTime, timeZone, unit) {
    return (0, moment_1.timeObjToUnixTimestamp)((0, moment_1.startTimeOfObj)(getTimeObj(dateTime, timeZone), unit));
}
function endOf(dateTime, timeZone, unit) {
    return (0, moment_1.timeObjToUnixTimestamp)((0, moment_1.endTimeOfObj)(getTimeObj(dateTime, timeZone), unit));
}
function getTimeObj(dateTime, timeZone) {
    return (0, moment_1.timeObjFromAny)(dateTime, timeZone);
}
function getUTCOffset(dateTime, timeZone) {
    return (0, moment_1.timeObjToUTCOffset)(getTimeObj(dateTime, timeZone));
}
function formatTime(dateTime, timeZone, format) {
    return (0, moment_1.formatTimeObj)(getTimeObj(dateTime, timeZone), format);
}
function diff(dateTime1, timeZone1, dateTime2, timeZone2, unit) {
    return (0, moment_1.diffTimeObjs)(getTimeObj(dateTime1, timeZone1), getTimeObj(dateTime2, timeZone2), unit);
}
//# sourceMappingURL=chrono.js.map