"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSettingsSpecSelector = void 0;
const get_specs_1 = require("./get_specs");
const chart_types_1 = require("../../chart_types");
const constants_1 = require("../../specs/constants");
const debounce_1 = require("../../utils/debounce");
const logger_1 = require("../../utils/logger");
const create_selector_1 = require("../create_selector");
const utils_1 = require("../utils");
const DEFAULT_POINTER_UPDATE_DEBOUNCE = 16;
exports.getSettingsSpecSelector = (0, create_selector_1.createCustomCachedSelector)([get_specs_1.getSpecs], getSettingsSpec);
function getSettingsSpec(specs) {
    const settingsSpecs = (0, utils_1.getSpecsFromStore)(specs, chart_types_1.ChartType.Global, constants_1.SpecType.Settings);
    const spec = settingsSpecs[0];
    return spec ? validateSpec(spec) : constants_1.DEFAULT_SETTINGS_SPEC;
}
function validateSpec(spec) {
    var _a;
    const delay = (_a = spec.pointerUpdateDebounce) !== null && _a !== void 0 ? _a : DEFAULT_POINTER_UPDATE_DEBOUNCE;
    if (spec.onPointerUpdate) {
        spec.onPointerUpdate = (0, debounce_1.debounce)(spec.onPointerUpdate, delay);
    }
    if (spec.dow < 1 || spec.dow > 7 || !Number.isInteger(spec.dow)) {
        logger_1.Logger.warn(`Settings.dow option must be an integer from 1 to 7, received ${spec.dow}. Using default of 1.`);
        spec.dow = constants_1.settingsBuildProps.defaults.dow;
    }
    return spec;
}
//# sourceMappingURL=get_settings_spec.js.map