"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartResizer = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const redux_1 = require("redux");
const chart_settings_1 = require("../state/actions/chart_settings");
const get_settings_spec_1 = require("../state/selectors/get_settings_spec");
class Resizer extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.onResize = (entries) => {
            var _a, _b;
            if (!Array.isArray(entries)) {
                return;
            }
            if (entries.length === 0 || !entries[0]) {
                return;
            }
            const { width, height } = entries[0].contentRect;
            this.props.updateParentDimensions({ width, height, top: 0, left: 0 });
            (_b = (_a = this.props).onResize) === null || _b === void 0 ? void 0 : _b.call(_a);
        };
        this.containerRef = react_1.default.createRef();
        this.ro = new ResizeObserver(this.onResize);
    }
    componentDidMount() {
        if (this.containerRef.current) {
            this.ro.observe(this.containerRef.current);
        }
    }
    componentWillUnmount() {
        this.ro.disconnect();
    }
    render() {
        return react_1.default.createElement("div", { ref: this.containerRef, className: "echChartResizer" });
    }
}
const mapDispatchToProps = (dispatch) => (0, redux_1.bindActionCreators)({ updateParentDimensions: chart_settings_1.updateParentDimensions }, dispatch);
const mapStateToProps = (state) => {
    const { onResize } = (0, get_settings_spec_1.getSettingsSpecSelector)(state);
    return { onResize };
};
exports.ChartResizer = (0, react_redux_1.connect)(mapStateToProps, mapDispatchToProps)(Resizer);
//# sourceMappingURL=chart_resizer.js.map