"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.legendValueTitlesMap = exports.shouldDisplayTable = exports.LegendValue = void 0;
exports.LegendValue = Object.freeze({
    CurrentAndLastValue: 'currentAndLastValue',
    LastValue: 'lastValue',
    LastNonNullValue: 'lastNonNullValue',
    Average: 'average',
    Median: 'median',
    Max: 'max',
    Min: 'min',
    FirstValue: 'firstValue',
    FirstNonNullValue: 'firstNonNullValue',
    Total: 'total',
    Count: 'count',
    DistinctCount: 'distinctCount',
    Variance: 'variance',
    StdDeviation: 'stdDeviation',
    Range: 'range',
    Difference: 'difference',
    DifferencePercent: 'differencePercent',
    Value: 'value',
    Percent: 'percent',
});
const shouldDisplayTable = (legendValues) => legendValues.some((v) => v !== exports.LegendValue.CurrentAndLastValue && v !== exports.LegendValue.Value);
exports.shouldDisplayTable = shouldDisplayTable;
exports.legendValueTitlesMap = {
    [exports.LegendValue.CurrentAndLastValue]: 'Value',
    [exports.LegendValue.Value]: 'Value',
    [exports.LegendValue.Percent]: 'Percent',
    [exports.LegendValue.LastValue]: 'Last',
    [exports.LegendValue.LastNonNullValue]: 'Last non-null',
    [exports.LegendValue.FirstValue]: 'First',
    [exports.LegendValue.FirstNonNullValue]: 'First non-null',
    [exports.LegendValue.Average]: 'Avg',
    [exports.LegendValue.Median]: 'Median',
    [exports.LegendValue.Min]: 'Min',
    [exports.LegendValue.Max]: 'Max',
    [exports.LegendValue.Total]: 'Total',
    [exports.LegendValue.Count]: 'Count',
    [exports.LegendValue.DistinctCount]: 'Dist Count',
    [exports.LegendValue.Variance]: 'Variance',
    [exports.LegendValue.StdDeviation]: 'Std dev',
    [exports.LegendValue.Range]: 'Range',
    [exports.LegendValue.Difference]: 'Diff',
    [exports.LegendValue.DifferencePercent]: 'Diff %',
};
//# sourceMappingURL=legend.js.map