"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLegendValues = getLegendValues;
exports.getLegendValue = getLegendValue;
const aggregations_1 = require("../../../../common/aggregations");
const legend_1 = require("../../../../common/legend");
const constants_1 = require("../../../../scales/constants");
function getLegendValues(series, xDomain, types, valueAccessor, tickFormatter) {
    return types.map((type) => {
        const value = getLegendValue(series, xDomain, type, valueAccessor);
        const formatter = type === legend_1.LegendValue.Percent || type === legend_1.LegendValue.DifferencePercent ? percentFormatter : tickFormatter;
        const label = typeof value === 'number' && isFinite(value) ? formatter(value) : '';
        return {
            type,
            label,
            value,
        };
    });
}
function percentFormatter(value) {
    return `${(value * 100).toFixed(1)}%`;
}
function getLegendValue(series, xDomain, type, valueAccessor) {
    if (xDomain.type === constants_1.ScaleType.Ordinal) {
        return null;
    }
    switch (type) {
        case legend_1.LegendValue.FirstNonNullValue:
            return (0, aggregations_1.firstNonNull)(series.data, valueAccessor);
        case legend_1.LegendValue.LastNonNullValue:
            return (0, aggregations_1.lastNonNull)(series.data, valueAccessor);
        case legend_1.LegendValue.FirstValue:
            const first = series.data.find((d) => d.x === xDomain.dataDomain[0]);
            return first ? valueAccessor(first) : null;
        case legend_1.LegendValue.CurrentAndLastValue:
        case legend_1.LegendValue.LastValue:
            const last = series.data.findLast((d) => d.x === xDomain.dataDomain[1]);
            return last ? valueAccessor(last) : null;
        case legend_1.LegendValue.Average:
            return (0, aggregations_1.average)(series.data, valueAccessor);
        case legend_1.LegendValue.Median:
            return (0, aggregations_1.median)(series.data, valueAccessor);
        case legend_1.LegendValue.Min:
            return (0, aggregations_1.min)(series.data, valueAccessor);
        case legend_1.LegendValue.Max:
            return (0, aggregations_1.max)(series.data, valueAccessor);
        case legend_1.LegendValue.Total:
            return (0, aggregations_1.sum)(series.data, valueAccessor).sum;
        case legend_1.LegendValue.Count:
            return (0, aggregations_1.countNonNull)(series.data, valueAccessor);
        case legend_1.LegendValue.DistinctCount:
            return (0, aggregations_1.distinctCount)(series.data, valueAccessor);
        case legend_1.LegendValue.Variance:
            return (0, aggregations_1.variance)(series.data, valueAccessor);
        case legend_1.LegendValue.StdDeviation:
            return (0, aggregations_1.stdDeviation)(series.data, valueAccessor);
        case legend_1.LegendValue.Range:
            return (0, aggregations_1.range)(series.data, valueAccessor);
        case legend_1.LegendValue.Difference:
            return (0, aggregations_1.difference)(series.data, valueAccessor);
        case legend_1.LegendValue.DifferencePercent:
            return (0, aggregations_1.differencePercent)(series.data, valueAccessor);
        default:
            return null;
    }
}
//# sourceMappingURL=get_legend_values.js.map