"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getActiveValues = void 0;
const get_active_value_1 = require("./get_active_value");
const get_panel_dimensions_1 = require("./get_panel_dimensions");
const create_selector_1 = require("../../../state/create_selector");
const common_1 = require("../../../utils/common");
exports.getActiveValues = (0, create_selector_1.createCustomCachedSelector)([get_active_value_1.getActiveValue, get_panel_dimensions_1.getPanelDimensions], (activeValue, dimensions) => {
    if (!activeValue)
        return [];
    const { snapValue, rowIndex, columnIndex } = activeValue;
    return dimensions.rows.map((row, ri) => row.map((panel, ci) => {
        const external = !(rowIndex === ri && columnIndex === ci);
        if (!panel || (!panel.datum.syncCursor && external))
            return null;
        const [min, max] = (0, common_1.sortNumbers)(panel.scale.domain());
        if (snapValue > max || snapValue < min)
            return null;
        return {
            value: panel.scale(snapValue),
            external,
        };
    }));
});
//# sourceMappingURL=get_active_values.js.map