"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.horizontalBullet = horizontalBullet;
const text_utils_1 = require("../../../../../common/text_utils");
const canvas_text_bbox_calculator_1 = require("../../../../../utils/bbox/canvas_text_bbox_calculator");
const common_1 = require("../../../../../utils/common");
const theme_1 = require("../../../theme");
const constants_1 = require("../constants");
function horizontalBullet(ctx, dimensions, style, backgroundColor, activeValue) {
    ctx.translate(theme_1.GRAPH_PADDING.left, 0);
    const { datum, colorBands, ticks, scale } = dimensions;
    const [start, end] = scale.domain();
    const [min, max] = (0, common_1.sortNumbers)([start, end]);
    const verticalAlignment = constants_1.TARGET_SIZE / 2;
    colorBands.forEach((band) => {
        ctx.fillStyle = band.color;
        ctx.fillRect(band.start, verticalAlignment - constants_1.BULLET_SIZE / 2, band.size, constants_1.BULLET_SIZE);
    });
    ctx.beginPath();
    ctx.strokeStyle = backgroundColor;
    ctx.lineWidth = constants_1.TICK_WIDTH;
    ticks
        .filter((tick) => tick > min && tick < max)
        .forEach((tick) => {
        ctx.moveTo(scale(tick), verticalAlignment - constants_1.BULLET_SIZE / 2);
        ctx.lineTo(scale(tick), verticalAlignment + constants_1.BULLET_SIZE / 2);
    });
    ctx.stroke();
    const confinedValue = (0, common_1.clamp)(datum.value, min, max);
    const adjustedZero = (0, common_1.clamp)(0, min, max);
    ctx.fillStyle = style.barBackground;
    ctx.fillRect(datum.value > 0 ? scale(adjustedZero) : scale(confinedValue), verticalAlignment - constants_1.BAR_SIZE / 2, confinedValue > 0 ? scale(confinedValue) - scale(adjustedZero) : scale(adjustedZero) - scale(confinedValue), constants_1.BAR_SIZE);
    if ((0, common_1.isFiniteNumber)(datum.target) && datum.target <= max && datum.target >= min) {
        ctx.fillRect(scale(datum.target) - constants_1.TARGET_STROKE_WIDTH / 2, verticalAlignment - constants_1.TARGET_SIZE / 2, constants_1.TARGET_STROKE_WIDTH, constants_1.TARGET_SIZE);
    }
    if ((0, common_1.isBetween)(min, max, true)(0)) {
        ctx.fillRect(scale(0) - constants_1.TICK_WIDTH / 2, verticalAlignment - constants_1.BULLET_SIZE / 2, constants_1.TICK_WIDTH, constants_1.BULLET_SIZE);
    }
    if (activeValue && (datum.syncCursor || !activeValue.external)) {
        ctx.fillRect(activeValue.value - constants_1.TARGET_STROKE_WIDTH / 2, verticalAlignment - constants_1.TARGET_SIZE / 2, constants_1.TARGET_STROKE_WIDTH, constants_1.TARGET_SIZE);
    }
    ctx.fillStyle = style.textColor;
    ctx.textBaseline = 'top';
    ctx.font = (0, text_utils_1.cssFontShorthand)(theme_1.TICK_FONT, theme_1.TICK_FONT_SIZE);
    ticks
        .filter((tick) => tick >= min && tick <= max)
        .forEach((tick, i) => {
        var _a;
        const labelText = datum.tickFormatter(tick);
        if (i === ticks.length - 1) {
            const availableWidth = Math.abs((start > end ? min : max) - ((_a = ticks.at(i)) !== null && _a !== void 0 ? _a : NaN));
            const { width: labelWidth } = (0, canvas_text_bbox_calculator_1.measureText)(ctx)(labelText, theme_1.TICK_FONT, theme_1.TICK_FONT_SIZE);
            ctx.textAlign = labelWidth >= Math.abs(scale(availableWidth) - scale(0)) ? 'end' : 'start';
        }
        else {
            ctx.textAlign = 'start';
        }
        ctx.fillText(labelText, scale(tick), verticalAlignment + constants_1.TARGET_SIZE / 2 + constants_1.TICK_LABEL_PADDING);
    });
}
//# sourceMappingURL=horizontal.js.map