"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BulletState = void 0;
const react_1 = __importDefault(require("react"));
const canvas_1 = require("./renderer/canvas");
const can_display_chart_titles_1 = require("./selectors/can_display_chart_titles");
const get_debug_state_1 = require("./selectors/get_debug_state");
const get_tooltip_anchor_1 = require("./selectors/get_tooltip_anchor");
const get_tooltip_info_1 = require("./selectors/get_tooltip_info");
const is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
const chart_types_1 = require("../../chart_types");
const constants_1 = require("../../common/constants");
const tooltip_1 = require("../../components/tooltip/tooltip");
const get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
const EMPTY_MAP = new Map();
const EMPTY_LEGEND_LIST = [];
const EMPTY_LEGEND_ITEM_LIST = [];
class BulletState {
    constructor() {
        this.chartType = chart_types_1.ChartType.Bullet;
        this.getChartTypeDescription = () => 'Bullet chart';
        this.chartRenderer = (containerRef, forwardStageRef) => (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(canvas_1.BulletRenderer, { forwardStageRef: forwardStageRef }),
            react_1.default.createElement(tooltip_1.Tooltip, { getChartContainerRef: containerRef })));
        this.isInitialized = () => get_internal_is_intialized_1.InitStatus.Initialized;
        this.isBrushAvailable = () => false;
        this.isBrushing = () => false;
        this.isChartEmpty = () => false;
        this.getLegendItems = () => EMPTY_LEGEND_LIST;
        this.getLegendItemsLabels = () => EMPTY_LEGEND_ITEM_LIST;
        this.getLegendExtraValues = () => EMPTY_MAP;
        this.getPointerCursor = () => constants_1.DEFAULT_CSS_CURSOR;
        this.eventCallbacks = () => { };
        this.getProjectionContainerArea = () => ({ width: 0, height: 0, top: 0, left: 0 });
        this.getMainProjectionArea = () => ({ width: 0, height: 0, top: 0, left: 0 });
        this.getBrushArea = () => null;
        this.getDebugState = (state) => (0, get_debug_state_1.getDebugStateSelector)(state);
    }
    isTooltipVisible(globalState) {
        return (0, is_tooltip_visible_1.isTooltipVisible)(globalState);
    }
    getTooltipInfo(globalState) {
        return (0, get_tooltip_info_1.getTooltipInfo)(globalState);
    }
    getTooltipAnchor(globalState) {
        return (0, get_tooltip_anchor_1.getTooltipAnchor)(globalState);
    }
    getSmallMultiplesDomains() {
        return {
            smHDomain: [],
            smVDomain: [],
        };
    }
    canDisplayChartTitles(globalState) {
        return (0, can_display_chart_titles_1.canDisplayChartTitles)(globalState);
    }
}
exports.BulletState = BulletState;
//# sourceMappingURL=chart_state.js.map