# Elastic Defend Integration

Elastic Defend provides organizations with prevention, detection, and response capabilities with deep visibility for EPP, EDR, SIEM, and Security Analytics use cases across Windows, macOS, and Linux operating systems running on both traditional endpoints and public cloud environments. ​​Use Elastic Defend to:

- **Prevent complex attacks** - Prevent malware (Windows, macOS, Linux) and ransomware (Windows) from executing, and stop advanced threats with malicious behavior (Windows, macOS, Linux), memory threat (Windows, macOS, Linux), and credential hardening (Windows) protections. All powered by [Elastic Labs](https://www.elastic.co/security-labs/) and our global community.
- **Alert in high fidelity** - Bolster team efficacy by detecting threats centrally and minimizing false positives via extensive corroboration.
- **Detect threats in high fidelity** - Elastic Defend facilitates deep visibility by instrumenting the process, file, and network data in your environments with minimal data collection overhead.
- **Triage and respond rapidly** - Quickly analyze detailed data from across your hosts. Examine host-based activity with interactive visualizations. Invoke remote response actions across distributed endpoints. Extend investigation capabilities even further with the Osquery integration, fully integrated into Elastic Security workflows.
- **Secure your cloud workloads** - Stop threats targeting cloud workloads and cloud-native applications. Gain real-time visibility and control with a lightweight user-space agent, powered by eBPF. Automate the identification of cloud threats with detection rules and machine learning (ML). Achieve rapid time-to-value with MITRE ATT&CK-aligned detections honed by Elastic Security Labs. 
- **View terminal sessions** - Give your security team a unique and powerful investigative tool for digital forensics and incident response (DFIR), reducing the mean time to respond (MTTR). Session view provides a time-ordered series of process executions in your Linux workloads in the form of a terminal shell, as well as the ability to replay the terminal session.

**Installation guide**
For in-depth, step-by-step instructions to help you get started with Elastic Defend, read through our [installation guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html). For macOS endpoints, we recommend reviewing our documentation on [enabling full disk access](https://www.elastic.co/guide/en/security/current/deploy-elastic-endpoint.html#enable-fda-endpoint).

## Compatibility

For compatibility information view our [documentation](https://www.elastic.co/guide/en/security/current/index.html).

## Logs

The log type of documents are stored in the `logs-endpoint.*` indices. The following sections define the mapped fields
sent by the endpoint.

### alerts

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Endpoint.policy | The policy fields are used to hold information about applied policy. | object |
| Endpoint.policy.applied | information about the policy that is applied | object |
| Endpoint.policy.applied.artifacts | information about protection artifacts applied. | object |
| Endpoint.policy.applied.artifacts.global | information about global protection artifacts applied. | object |
| Endpoint.policy.applied.artifacts.global.identifiers | the identifiers of global artifacts applied. | nested |
| Endpoint.policy.applied.artifacts.global.identifiers.name | the name of global artifact applied. | keyword |
| Endpoint.policy.applied.artifacts.global.identifiers.sha256 | the sha256 of global artifacts applied. | keyword |
| Endpoint.policy.applied.artifacts.global.snapshot | the snapshot date of applied global artifacts or 'latest' | keyword |
| Endpoint.policy.applied.artifacts.global.update_age | number of days since global artifacts were made up-to-date | unsigned_long |
| Endpoint.policy.applied.artifacts.global.version | the version of global artifacts applied. | keyword |
| Endpoint.policy.applied.artifacts.user | information about user protection artifacts applied. | object |
| Endpoint.policy.applied.artifacts.user.identifiers | the identifiers of user artifacts applied. | nested |
| Endpoint.policy.applied.artifacts.user.identifiers.name | the name of user artifact applied. | keyword |
| Endpoint.policy.applied.artifacts.user.identifiers.sha256 | the sha256 of user artifacts applied. | keyword |
| Endpoint.policy.applied.artifacts.user.version | the version of user artifacts applied. | keyword |
| Endpoint.policy.applied.id | the id of the applied policy | keyword |
| Endpoint.policy.applied.name | the name of this applied policy | keyword |
| Endpoint.policy.applied.status | the status of the applied policy | keyword |
| Endpoint.policy.applied.version | the version of this applied policy | keyword |
| Events | events array | object |
| Memory_protection.cross_session | Is this process injecting across operating system sessions? | boolean |
| Memory_protection.feature | Memory Protection feature which triggered the alert. | keyword |
| Memory_protection.parent_to_child | Is this process injecting into its child? | boolean |
| Memory_protection.self_injection | Is this alert about a process injecting into itself? | boolean |
| Memory_protection.thread_count | The number of threads that this alert applies to. If several alerts occur in a short period of time, they can be combined into a single alert with thread_count > 1. | long |
| Memory_protection.unique_key_v1 | A unique key created by hashing several characteristics of this alert. | keyword |
| Ransomware.child_processes.executable | Absolute path to the process executable. | keyword |
| Ransomware.child_processes.feature | Ransomware feature which triggered the alert. | keyword |
| Ransomware.child_processes.files | Information about each file event attributed to the ransomware. Expected to be an array. | nested |
| Ransomware.child_processes.files.data | File header or MBR bytes. | keyword |
| Ransomware.child_processes.files.entropy | Entropy of file contents. | double |
| Ransomware.child_processes.files.extension | File extension, excluding the leading dot. | keyword |
| Ransomware.child_processes.files.metrics | Suspicious ransomware behaviours associated with the file event. | keyword |
| Ransomware.child_processes.files.operation | Operation applied to file. | keyword |
| Ransomware.child_processes.files.original.extension | Original file extension prior to the file event. | keyword |
| Ransomware.child_processes.files.original.path | Original file path prior to the file event. | keyword |
| Ransomware.child_processes.files.path | Full path to the file, including the file name. | keyword |
| Ransomware.child_processes.files.score | Ransomware score for this particular file event. | double |
| Ransomware.child_processes.pid | Process id. | long |
| Ransomware.child_processes.score | Total ransomware score for aggregated file events. | double |
| Ransomware.child_processes.version | Ransomware artifact version. | keyword |
| Ransomware.executable | Absolute path to the process executable. | keyword |
| Ransomware.feature | Ransomware feature which triggered the alert. | keyword |
| Ransomware.files | Information about each file event attributed to the ransomware. Expected to be an array. | nested |
| Ransomware.files.data | File header or MBR bytes. | keyword |
| Ransomware.files.entropy | Entropy of file contents. | double |
| Ransomware.files.extension | File extension, excluding the leading dot. | keyword |
| Ransomware.files.metrics | Suspicious ransomware behaviours associated with the file event. | keyword |
| Ransomware.files.operation | Operation applied to file. | keyword |
| Ransomware.files.original.extension | Original file extension prior to the file event. | keyword |
| Ransomware.files.original.path | Original file path prior to the file event. | keyword |
| Ransomware.files.path | Full path to the file, including the file name. | keyword |
| Ransomware.files.score | Ransomware score for this particular file event. | double |
| Ransomware.pid | Process id. | long |
| Ransomware.score | Total ransomware score for aggregated file events. | double |
| Ransomware.version | Ransomware artifact version. | keyword |
| Responses.@timestamp | Timestamp in which action was taken | date |
| Responses.action | Dictionary representing requested response action | nested |
| Responses.action.action | Response action name | keyword |
| Responses.action.field | Field in the triggering event to use as input for action | text |
| Responses.action.file.attributes | Destination file attributes | keyword |
| Responses.action.file.path | Destination file path | keyword |
| Responses.action.file.reason | Combined USN file modification reason | long |
| Responses.action.key.actions | Actions taken by Registry Rollback for key | keyword |
| Responses.action.key.path | NT path of registry key recovered by Rollback | keyword |
| Responses.action.key.values | Values modified | object |
| Responses.action.key.values.actions | Actions taken by Registry Rollback for value | keyword |
| Responses.action.key.values.name | Value name recovered by Rollback | keyword |
| Responses.action.process.message | Status message for Process Rollback | keyword |
| Responses.action.process.path | Path of process killed by Process Rollback | keyword |
| Responses.action.process.result | Result code for Process Rollback | long |
| Responses.action.source.attributes | Source file attributes | keyword |
| Responses.action.source.path | Source file path | keyword |
| Responses.action.state | Index of event in events array to use for field lookup | long |
| Responses.action.tree | Indicates whether or not an action was taken against an entire process tree | boolean |
| Responses.message | Result message | text |
| Responses.process | Dictionary representing process information | nested |
| Responses.process.entity_id | Entity id of actionable process | text |
| Responses.process.name | Name of actionable process | keyword |
| Responses.process.pid | pid of actionable process | long |
| Responses.result | Response action result code | long |
| Target.dll.Ext | Object for all custom defined fields to live in. | object |
| Target.dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| Target.dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.dll.Ext.compile_time | Timestamp from when the module was compiled. | date |
| Target.dll.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| Target.dll.Ext.malware_classification.score | The score produced by the classification model. | double |
| Target.dll.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| Target.dll.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| Target.dll.Ext.malware_classification.version | The version of the model used. | keyword |
| Target.dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| Target.dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| Target.dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| Target.dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.dll.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| Target.dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.dll.hash.md5 | MD5 hash. | keyword |
| Target.dll.hash.sha1 | SHA1 hash. | keyword |
| Target.dll.hash.sha256 | SHA256 hash. | keyword |
| Target.dll.hash.sha512 | SHA512 hash. | keyword |
| Target.dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| Target.dll.path | Full file path of the library. | keyword |
| Target.dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.Ext | Object for all custom defined fields to live in. | object |
| Target.process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| Target.process.Ext.architecture | Process architecture.  It can differ from host architecture. | keyword |
| Target.process.Ext.authentication_id | Process authentication ID | keyword |
| Target.process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| Target.process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.Ext.dll.Ext | Object for all custom defined fields to live in. | object |
| Target.process.Ext.dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| Target.process.Ext.dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.Ext.dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.Ext.dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.Ext.dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.Ext.dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.Ext.dll.Ext.compile_time | Timestamp from when the module was compiled. | date |
| Target.process.Ext.dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| Target.process.Ext.dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| Target.process.Ext.dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.Ext.dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| Target.process.Ext.dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.Ext.dll.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.Ext.dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| Target.process.Ext.dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.Ext.dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.Ext.dll.hash.md5 | MD5 hash. | keyword |
| Target.process.Ext.dll.hash.sha1 | SHA1 hash. | keyword |
| Target.process.Ext.dll.hash.sha256 | SHA256 hash. | keyword |
| Target.process.Ext.dll.hash.sha512 | SHA512 hash. | keyword |
| Target.process.Ext.dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| Target.process.Ext.dll.path | Full file path of the library. | keyword |
| Target.process.Ext.dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.process.Ext.dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.process.Ext.dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.process.Ext.dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.process.Ext.dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.process.Ext.dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| Target.process.Ext.malware_classification.score | The score produced by the classification model. | double |
| Target.process.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| Target.process.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| Target.process.Ext.malware_classification.version | The version of the model used. | keyword |
| Target.process.Ext.memory_region.allocation_base | Base address of the memory allocation containing the memory region. | unsigned_long |
| Target.process.Ext.memory_region.allocation_protection | Original memory protection requested when the memory was allocated. Example values include "RWX" and "R-X". | keyword |
| Target.process.Ext.memory_region.allocation_size | Original memory size requested when the memory was allocated. | unsigned_long |
| Target.process.Ext.memory_region.allocation_type | The memory allocation type. Example values include "IMAGE", "MAPPED", and "PRIVATE". | keyword |
| Target.process.Ext.memory_region.bytes_address | The address where bytes_compressed begins. | unsigned_long |
| Target.process.Ext.memory_region.bytes_allocation_offset | Offset of bytes_address the memory allocation. Equal to bytes_address - allocation_base. | unsigned_long |
| Target.process.Ext.memory_region.bytes_compressed | Up to 4MB of raw data from the memory allocation. This is compressed with zlib.To reduce data volume, this is de-duplicated on the endpoint, and may be missing from many alerts if the same data would be sent multiple times. | keyword |
| Target.process.Ext.memory_region.bytes_compressed_present | Whether bytes_compressed is present in this event. | boolean |
| Target.process.Ext.memory_region.malware_signature.all_names | A sequence of signature names matched. | keyword |
| Target.process.Ext.memory_region.malware_signature.identifier | malware signature identifier | keyword |
| Target.process.Ext.memory_region.malware_signature.primary | The first matching details. | object |
| Target.process.Ext.memory_region.malware_signature.primary.matches | The first matching details. | keyword |
| Target.process.Ext.memory_region.malware_signature.primary.signature.hash | hash of file matching signature. | nested |
| Target.process.Ext.memory_region.malware_signature.primary.signature.hash.sha256 | sha256 hash of file matching signature. | keyword |
| Target.process.Ext.memory_region.malware_signature.primary.signature.id | The id of the first yara rule matched. | keyword |
| Target.process.Ext.memory_region.malware_signature.primary.signature.name | The name of the first yara rule matched. | keyword |
| Target.process.Ext.memory_region.malware_signature.version | malware signature version | keyword |
| Target.process.Ext.memory_region.mapped_path | If the memory corresponds to a file mapping, this is the file's path. | keyword |
| Target.process.Ext.memory_region.mapped_pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.mapped_pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.mapped_pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.mapped_pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.process.Ext.memory_region.mapped_pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.mapped_pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.mapped_pe_detected | Whether the file at mapped_path is an executable. | boolean |
| Target.process.Ext.memory_region.memory_pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.memory_pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.memory_pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.memory_pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.process.Ext.memory_region.memory_pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.memory_pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.Ext.memory_region.memory_pe_detected | Whether an executable file was found in memory. | boolean |
| Target.process.Ext.memory_region.region_base | Base address of the memory region. | unsigned_long |
| Target.process.Ext.memory_region.region_protection | Memory protection of the memory region. Example values include "RWX" and "R-X". | keyword |
| Target.process.Ext.memory_region.region_size | Size of the memory region. | unsigned_long |
| Target.process.Ext.memory_region.region_state | State of the memory region. Example values include "RESERVE", "COMMIT", and "FREE". | keyword |
| Target.process.Ext.memory_region.strings | Array of strings found within the memory region. | keyword |
| Target.process.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| Target.process.Ext.services | Services running in this process. | keyword |
| Target.process.Ext.session | Session information for the current process | keyword |
| Target.process.Ext.token.domain | Domain of token user. | keyword |
| Target.process.Ext.token.elevation | Whether the token is elevated or not | boolean |
| Target.process.Ext.token.elevation_type | What level of elevation the token has | keyword |
| Target.process.Ext.token.impersonation_level | Impersonation level. Only valid for impersonation tokens. | keyword |
| Target.process.Ext.token.integrity_level | Numeric integrity level. | long |
| Target.process.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| Target.process.Ext.token.is_appcontainer | Whether or not this is an appcontainer token. | boolean |
| Target.process.Ext.token.privileges | Array describing the privileges associated with the token. | nested |
| Target.process.Ext.token.privileges.description | Description of the privilege. | keyword |
| Target.process.Ext.token.privileges.enabled | Whether or not the privilege is enabled. | boolean |
| Target.process.Ext.token.privileges.name | Name of the privilege. | keyword |
| Target.process.Ext.token.sid | Token user's Security Identifier (SID). | keyword |
| Target.process.Ext.token.type | Type of the token, either primary or impersonation. | keyword |
| Target.process.Ext.token.user | Username of token owner. | keyword |
| Target.process.Ext.user | User associated with the running process. | keyword |
| Target.process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| Target.process.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| Target.process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| Target.process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| Target.process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| Target.process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| Target.process.executable | Absolute path to the process executable. | keyword |
| Target.process.exit_code | The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start). | long |
| Target.process.hash.md5 | MD5 hash. | keyword |
| Target.process.hash.sha1 | SHA1 hash. | keyword |
| Target.process.hash.sha256 | SHA256 hash. | keyword |
| Target.process.hash.sha512 | SHA512 hash. | keyword |
| Target.process.name | Process name. Sometimes called program name or similar. | keyword |
| Target.process.parent.Ext | Object for all custom defined fields to live in. | object |
| Target.process.parent.Ext.architecture | Process architecture.  It can differ from host architecture. | keyword |
| Target.process.parent.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| Target.process.parent.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.parent.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.parent.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.parent.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.parent.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.parent.Ext.dll.Ext | Object for all custom defined fields to live in. | object |
| Target.process.parent.Ext.dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| Target.process.parent.Ext.dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.parent.Ext.dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.parent.Ext.dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.parent.Ext.dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.parent.Ext.dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.parent.Ext.dll.Ext.compile_time | Timestamp from when the module was compiled. | date |
| Target.process.parent.Ext.dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| Target.process.parent.Ext.dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| Target.process.parent.Ext.dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.parent.Ext.dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| Target.process.parent.Ext.dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.parent.Ext.dll.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.parent.Ext.dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| Target.process.parent.Ext.dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.parent.Ext.dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.parent.Ext.dll.hash.md5 | MD5 hash. | keyword |
| Target.process.parent.Ext.dll.hash.sha1 | SHA1 hash. | keyword |
| Target.process.parent.Ext.dll.hash.sha256 | SHA256 hash. | keyword |
| Target.process.parent.Ext.dll.hash.sha512 | SHA512 hash. | keyword |
| Target.process.parent.Ext.dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| Target.process.parent.Ext.dll.path | Full file path of the library. | keyword |
| Target.process.parent.Ext.dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.process.parent.Ext.dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.process.parent.Ext.dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.process.parent.Ext.dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.process.parent.Ext.dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.process.parent.Ext.dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.parent.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| Target.process.parent.Ext.real | The field set containing process info in case of any pid spoofing. This is mainly useful for process.parent. | object |
| Target.process.parent.Ext.real.pid | For process.parent this will be the ppid of the process that actually spawned the current process. | long |
| Target.process.parent.Ext.token.domain | Domain of token user. | keyword |
| Target.process.parent.Ext.token.elevation | Whether the token is elevated or not | boolean |
| Target.process.parent.Ext.token.elevation_type | What level of elevation the token has | keyword |
| Target.process.parent.Ext.token.impersonation_level | Impersonation level. Only valid for impersonation tokens. | keyword |
| Target.process.parent.Ext.token.integrity_level | Numeric integrity level. | long |
| Target.process.parent.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| Target.process.parent.Ext.token.is_appcontainer | Whether or not this is an appcontainer token. | boolean |
| Target.process.parent.Ext.token.privileges | Array describing the privileges associated with the token. | nested |
| Target.process.parent.Ext.token.privileges.description | Description of the privilege. | keyword |
| Target.process.parent.Ext.token.privileges.enabled | Whether or not the privilege is enabled. | boolean |
| Target.process.parent.Ext.token.privileges.name | Name of the privilege. | keyword |
| Target.process.parent.Ext.token.sid | Token user's Security Identifier (SID). | keyword |
| Target.process.parent.Ext.token.type | Type of the token, either primary or impersonation. | keyword |
| Target.process.parent.Ext.token.user | Username of token owner. | keyword |
| Target.process.parent.Ext.user | User associated with the running process. | keyword |
| Target.process.parent.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| Target.process.parent.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| Target.process.parent.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| Target.process.parent.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| Target.process.parent.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| Target.process.parent.code_signature.subject_name | Subject name of the code signer | keyword |
| Target.process.parent.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| Target.process.parent.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| Target.process.parent.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| Target.process.parent.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| Target.process.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| Target.process.parent.executable | Absolute path to the process executable. | keyword |
| Target.process.parent.exit_code | The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start). | long |
| Target.process.parent.hash.md5 | MD5 hash. | keyword |
| Target.process.parent.hash.sha1 | SHA1 hash. | keyword |
| Target.process.parent.hash.sha256 | SHA256 hash. | keyword |
| Target.process.parent.hash.sha512 | SHA512 hash. | keyword |
| Target.process.parent.name | Process name. Sometimes called program name or similar. | keyword |
| Target.process.parent.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.process.parent.pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.process.parent.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.process.parent.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.process.parent.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.process.parent.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.parent.pgid | Deprecated for removal in next major version release. This field is superseded by `process.group_leader.pid`. Identifier of the group of processes the process belongs to. | long |
| Target.process.parent.pid | Process id. | long |
| Target.process.parent.ppid | Parent process' pid. | long |
| Target.process.parent.start | The time the process started. | date |
| Target.process.parent.thread.id | Thread ID. | long |
| Target.process.parent.thread.name | Thread name. | keyword |
| Target.process.parent.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| Target.process.parent.uptime | Seconds the process has been up. | long |
| Target.process.parent.working_directory | The working directory of the process. | keyword |
| Target.process.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| Target.process.pe.description | Internal description of the file, provided at compile-time. | keyword |
| Target.process.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| Target.process.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| Target.process.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| Target.process.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| Target.process.pgid | Deprecated for removal in next major version release. This field is superseded by `process.group_leader.pid`. Identifier of the group of processes the process belongs to. | long |
| Target.process.pid | Process id. | long |
| Target.process.ppid | Parent process' pid. | long |
| Target.process.start | The time the process started. | date |
| Target.process.thread.Ext | Object for all custom defined fields to live in. | object |
| Target.process.thread.Ext.hardware_breakpoint_set | Whether a hardware breakpoint was set for the thread. This field is omitted if false. | boolean |
| Target.process.thread.Ext.original_start_address | When a trampoline was detected, this indicates the original content for the thread start address in memory. | unsigned_long |
| Target.process.thread.Ext.original_start_address_allocation_offset | When a trampoline was detected, this indicates the offset of original_start_address from the allocation base. | unsigned_long |
| Target.process.thread.Ext.original_start_address_bytes | When a trampoline was detected, this holds the hex-encoded bytes at the original thread start address. | keyword |
| Target.process.thread.Ext.original_start_address_bytes_disasm | When a trampoline was detected, this holds the disassembled code at the original thread start address. | keyword |
| Target.process.thread.Ext.original_start_address_bytes_disasm_hash | When a trampoline was detected, this holds the bytes at the original thread start address, with immediate values capped to 0x100, disassembled into human-readable assembly code, then hashed. | keyword |
| Target.process.thread.Ext.original_start_address_module | When a trampoline was detected, this indicates the original content for the dll/module where the thread began execution. | keyword |
| Target.process.thread.Ext.parameter | When a thread is created, this is the raw numerical value of its parameter. | unsigned_long |
| Target.process.thread.Ext.parameter_bytes_compressed | Up to 512KB of raw data from the thread parameter, if it is a valid pointer. This is compressed with zlib. To reduce data volume, this is de-duplicated on the endpoint, and may be missing from many alerts if the same data would be sent multiple times. | keyword |
| Target.process.thread.Ext.parameter_bytes_compressed_present | Whether parameter_bytes_compressed is present in this event. | boolean |
| Target.process.thread.Ext.service | Service associated with the thread. | keyword |
| Target.process.thread.Ext.start | The time the thread started. | date |
| Target.process.thread.Ext.start_address | Memory address where the thread began execution. | unsigned_long |
| Target.process.thread.Ext.start_address_allocation_offset | Offset of start_address into the memory allocation. Equal to start_address - start_address_details.allocation_base. | unsigned_long |
| Target.process.thread.Ext.start_address_bytes | A few (typically 32) raw opcode bytes at the thread start address, hex-encoded. | keyword |
| Target.process.thread.Ext.start_address_bytes_disasm | The bytes at the thread start address, disassembled into human-readable assembly code. | keyword |
| Target.process.thread.Ext.start_address_bytes_disasm_hash | The bytes at the thread start address, with immediate values capped to 0x100, disassembled into human-readable assembly code, then hashed. | keyword |
| Target.process.thread.Ext.start_address_module | The dll/module where the thread began execution. | keyword |
| Target.process.thread.Ext.token.domain | Domain of token user. | keyword |
| Target.process.thread.Ext.token.elevation | Whether the token is elevated or not | boolean |
| Target.process.thread.Ext.token.elevation_type | What level of elevation the token has | keyword |
| Target.process.thread.Ext.token.impersonation_level | Impersonation level. Only valid for impersonation tokens. | keyword |
| Target.process.thread.Ext.token.integrity_level | Numeric integrity level. | long |
| Target.process.thread.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| Target.process.thread.Ext.token.is_appcontainer | Whether or not this is an appcontainer token. | boolean |
| Target.process.thread.Ext.token.privileges | Array describing the privileges associated with the token. | nested |
| Target.process.thread.Ext.token.privileges.description | Description of the privilege. | keyword |
| Target.process.thread.Ext.token.privileges.enabled | Whether or not the privilege is enabled. | boolean |
| Target.process.thread.Ext.token.privileges.name | Name of the privilege. | keyword |
| Target.process.thread.Ext.token.sid | Token user's Security Identifier (SID). | keyword |
| Target.process.thread.Ext.token.type | Type of the token, either primary or impersonation. | keyword |
| Target.process.thread.Ext.token.user | Username of token owner. | keyword |
| Target.process.thread.Ext.uptime | Seconds since thread started. | long |
| Target.process.thread.id | Thread ID. | long |
| Target.process.thread.name | Thread name. | keyword |
| Target.process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| Target.process.uptime | Seconds the process has been up. | long |
| Target.process.working_directory | The working directory of the process. | keyword |
| agent.ephemeral_id | Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not. | keyword |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| cloud.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword |
| cloud.instance.name | Instance name of the host machine. | keyword |
| cloud.project.id | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id. | keyword |
| cloud.provider | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean. | keyword |
| cloud.region | Region in which this host, resource, or service is located. | keyword |
| container.id | Unique container id. | keyword |
| container.image.name | Name of the image the container was built on. | keyword |
| container.image.tag | Container image tags. | keyword |
| container.name | Container name. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| destination.ip | IP address of the destination (IPv4 or IPv6). | ip |
| dll.Ext | Object for all custom defined fields to live in. | object |
| dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| dll.Ext.compile_time | Timestamp from when the module was compiled. | date |
| dll.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| dll.Ext.malware_classification.score | The score produced by the classification model. | double |
| dll.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| dll.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| dll.Ext.malware_classification.version | The version of the model used. | keyword |
| dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| dll.code_signature.subject_name | Subject name of the code signer | keyword |
| dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| dll.hash.md5 | MD5 hash. | keyword |
| dll.hash.sha1 | SHA1 hash. | keyword |
| dll.hash.sha256 | SHA256 hash. | keyword |
| dll.hash.sha512 | SHA512 hash. | keyword |
| dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| dll.path | Full file path of the library. | keyword |
| dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| dns.question.name | The name being queried. If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively. | keyword |
| dns.question.type | The type of record being queried. | keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| elastic.agent | The agent fields contain data about the Elastic Agent. The Elastic Agent is the management agent that manages other agents or process on the host. | object |
| elastic.agent.id | Unique identifier of this elastic agent (if one exists). | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.risk_score | Risk score or priority of the event (e.g. security solutions). Use your system's original value here. | float |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| file.Ext | Object for all custom defined fields to live in. | object |
| file.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| file.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| file.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| file.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| file.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| file.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| file.Ext.entry_modified | Time of last status change.  See `st_ctim` member of `struct stat`. | double |
| file.Ext.macro.code_page | Identifies the character encoding used for this macro.  https://docs.microsoft.com/en-us/windows/win32/intl/code-page-identifiers | long |
| file.Ext.macro.collection | Object containing hashes for the macro collection. | object |
| file.Ext.macro.collection.hash.md5 | MD5 hash. | keyword |
| file.Ext.macro.collection.hash.sha1 | SHA1 hash. | keyword |
| file.Ext.macro.collection.hash.sha256 | SHA256 hash. | keyword |
| file.Ext.macro.collection.hash.sha512 | SHA512 hash. | keyword |
| file.Ext.macro.errors | Errors that occurred when parsing this document file. | nested |
| file.Ext.macro.errors.count | Number of times this error that occurred. | long |
| file.Ext.macro.errors.error_type | The type of parsing error that occurred. | keyword |
| file.Ext.macro.file_extension | The extension of the file containing this macro (e.g. .docm) | keyword |
| file.Ext.macro.project_file | Metadata about the corresponding VBA project file | object |
| file.Ext.macro.project_file.hash.md5 | MD5 hash. | keyword |
| file.Ext.macro.project_file.hash.sha1 | SHA1 hash. | keyword |
| file.Ext.macro.project_file.hash.sha256 | SHA256 hash. | keyword |
| file.Ext.macro.project_file.hash.sha512 | SHA512 hash. | keyword |
| file.Ext.macro.stream | Streams associated with the document. | nested |
| file.Ext.macro.stream.hash.md5 | MD5 hash. | keyword |
| file.Ext.macro.stream.hash.sha1 | SHA1 hash. | keyword |
| file.Ext.macro.stream.hash.sha256 | SHA256 hash. | keyword |
| file.Ext.macro.stream.hash.sha512 | SHA512 hash. | keyword |
| file.Ext.macro.stream.name | Name of the stream. | keyword |
| file.Ext.macro.stream.raw_code | First 100KB of raw stream binary.  Can be useful to analyze false positives and malicious payloads. | keyword |
| file.Ext.macro.stream.raw_code_size | The original stream size.  Indicates whether stream.raw_code was truncated. | keyword |
| file.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| file.Ext.malware_classification.score | The score produced by the classification model. | double |
| file.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| file.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| file.Ext.malware_classification.version | The version of the model used. | keyword |
| file.Ext.original | Original file information during a modification event. | object |
| file.Ext.original.gid | Primary group ID (GID) of the file. | keyword |
| file.Ext.original.group | Primary group name of the file. | keyword |
| file.Ext.original.mode | Original file mode prior to a modification event | keyword |
| file.Ext.original.name | Original file name prior to a modification event | keyword |
| file.Ext.original.owner | File owner's username. | keyword |
| file.Ext.original.path | Original file path prior to a modification event | keyword |
| file.Ext.original.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| file.Ext.quarantine_message | Message describing quarantine results. | keyword |
| file.Ext.quarantine_path | Path on endpoint the quarantined file was originally. | keyword |
| file.Ext.quarantine_result | Boolean representing whether or not file quarantine succeeded. | boolean |
| file.Ext.temp_file_path | Path on endpoint where a copy of the file is being stored.  Used to make ephemeral files retrievable. | keyword |
| file.Ext.windows | Platform-specific Windows fields | object |
| file.Ext.windows.zone_identifier | Windows zone identifier for a file | keyword |
| file.accessed | Last time the file was accessed. Note that not all filesystems keep track of access time. | date |
| file.attributes | Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write. | keyword |
| file.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| file.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| file.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| file.code_signature.subject_name | Subject name of the code signer | keyword |
| file.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| file.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| file.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| file.created | File creation time. Note that not all filesystems store the creation time. | date |
| file.ctime | Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file. | date |
| file.device | Device that is the source of the file. | keyword |
| file.directory | Directory where the file is located. It should include the drive letter, when appropriate. | keyword |
| file.drive_letter | Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon. | keyword |
| file.extension | File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword |
| file.gid | Primary group ID (GID) of the file. | keyword |
| file.group | Primary group name of the file. | keyword |
| file.hash.md5 | MD5 hash. | keyword |
| file.hash.sha1 | SHA1 hash. | keyword |
| file.hash.sha256 | SHA256 hash. | keyword |
| file.hash.sha512 | SHA512 hash. | keyword |
| file.inode | Inode representing the file in the filesystem. | keyword |
| file.mime_type | MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used. | keyword |
| file.mode | Mode of the file in octal representation. | keyword |
| file.mtime | Last time the file content was modified. | date |
| file.name | Name of the file including the extension, without the directory. | keyword |
| file.owner | File owner's username. | keyword |
| file.path | Full path to the file, including the file name. It should include the drive letter, when appropriate. | keyword |
| file.pe.Ext.dotnet | Whether this file is a .NET PE | boolean |
| file.pe.Ext.sections | The file's relevant sections, if it is a PE | object |
| file.pe.Ext.sections.hash.md5 | MD5 hash. | keyword |
| file.pe.Ext.sections.hash.sha256 | SHA256 hash. | keyword |
| file.pe.Ext.sections.name | The section's name | keyword |
| file.pe.Ext.streams | The file's streams, if it is a PE | object |
| file.pe.Ext.streams.hash.md5 | MD5 hash. | keyword |
| file.pe.Ext.streams.hash.sha256 | SHA256 hash. | keyword |
| file.pe.Ext.streams.name | The stream's name | keyword |
| file.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| file.pe.description | Internal description of the file, provided at compile-time. | keyword |
| file.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| file.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| file.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| file.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| file.size | File size in bytes. Only relevant when `file.type` is "file". | long |
| file.target_path | Target path for symlinks. | keyword |
| file.type | File type (file, dir, or symlink). | keyword |
| file.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.boot.id | Linux boot uuid taken from /proc/sys/kernel/random/boot_id. Note the boot_id value from /proc may or may not be the same in containers as on the host. Some container runtimes will bind mount a new boot_id value onto the proc file in each container. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.geo.city_name | City name. | keyword |
| host.geo.continent_code | Two-letter code representing continent's name. | keyword |
| host.geo.continent_name | Name of the continent. | keyword |
| host.geo.country_iso_code | Country ISO code. | keyword |
| host.geo.country_name | Country name. | keyword |
| host.geo.location | Longitude and latitude. | geo_point |
| host.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| host.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| host.geo.region_iso_code | Region ISO code. | keyword |
| host.geo.region_name | Region name. | keyword |
| host.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.pid_ns_ino | This is the inode number of the namespace in the namespace file system (nsfs). Unsigned int inum in include/linux/ns_common.h. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| host.user.Ext | Object for all custom defined fields to live in. | object |
| host.user.Ext.real | User info prior to any setuid operations. | object |
| host.user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| host.user.Ext.real.name | Short name or login of the user. | keyword |
| host.user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| host.user.email | User email address. | keyword |
| host.user.full_name | User's full name, if available. | keyword |
| host.user.group.Ext | Object for all custom defined fields to live in. | object |
| host.user.group.Ext.real | Group info prior to any setgid operations. | object |
| host.user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| host.user.group.Ext.real.name | Name of the group. | keyword |
| host.user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| host.user.group.id | Unique identifier for the group on the system/platform. | keyword |
| host.user.group.name | Name of the group. | keyword |
| host.user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| host.user.id | Unique identifier of the user. | keyword |
| host.user.name | Short name or login of the user. | keyword |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| orchestrator.cluster.name | Name of the cluster. | keyword |
| orchestrator.namespace | Namespace in which the action is taking place. | keyword |
| orchestrator.resource.name | Name of the resource being acted upon. | keyword |
| orchestrator.resource.type | Type of resource being acted upon. | keyword |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.architecture | Process architecture.  It can differ from host architecture. | keyword |
| process.Ext.authentication_id | Process authentication ID | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.Ext.dll.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.Ext.dll.Ext.compile_time | Timestamp from when the module was compiled. | date |
| process.Ext.dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| process.Ext.dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| process.Ext.dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.Ext.dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.dll.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.Ext.dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.Ext.dll.hash.md5 | MD5 hash. | keyword |
| process.Ext.dll.hash.sha1 | SHA1 hash. | keyword |
| process.Ext.dll.hash.sha256 | SHA256 hash. | keyword |
| process.Ext.dll.hash.sha512 | SHA512 hash. | keyword |
| process.Ext.dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| process.Ext.dll.path | Full file path of the library. | keyword |
| process.Ext.dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.Ext.dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.Ext.dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.Ext.dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.Ext.dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.Ext.dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| process.Ext.malware_classification.score | The score produced by the classification model. | double |
| process.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| process.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| process.Ext.malware_classification.version | The version of the model used. | keyword |
| process.Ext.memory_region.allocation_base | Base address of the memory allocation containing the memory region. | unsigned_long |
| process.Ext.memory_region.allocation_protection | Original memory protection requested when the memory was allocated. Example values include "RWX" and "R-X". | keyword |
| process.Ext.memory_region.allocation_size | Original memory size requested when the memory was allocated. | unsigned_long |
| process.Ext.memory_region.allocation_type | The memory allocation type. Example values include "IMAGE", "MAPPED", and "PRIVATE". | keyword |
| process.Ext.memory_region.bytes_address | The address where bytes_compressed begins. | unsigned_long |
| process.Ext.memory_region.bytes_allocation_offset | Offset of bytes_address the memory allocation. Equal to bytes_address - allocation_base. | unsigned_long |
| process.Ext.memory_region.bytes_compressed | Up to 4MB of raw data from the memory allocation. This is compressed with zlib.To reduce data volume, this is de-duplicated on the endpoint, and may be missing from many alerts if the same data would be sent multiple times. | keyword |
| process.Ext.memory_region.bytes_compressed_present | Whether bytes_compressed is present in this event. | boolean |
| process.Ext.memory_region.malware_signature.all_names | A sequence of signature names matched. | keyword |
| process.Ext.memory_region.malware_signature.identifier | malware signature identifier | keyword |
| process.Ext.memory_region.malware_signature.primary | The first matching details. | object |
| process.Ext.memory_region.malware_signature.primary.matches | The first matching details. | keyword |
| process.Ext.memory_region.malware_signature.primary.signature.hash | hash of file matching signature. | nested |
| process.Ext.memory_region.malware_signature.primary.signature.hash.sha256 | sha256 hash of file matching signature. | keyword |
| process.Ext.memory_region.malware_signature.primary.signature.id | The id of the first yara rule matched. | keyword |
| process.Ext.memory_region.malware_signature.primary.signature.name | The name of the first yara rule matched. | keyword |
| process.Ext.memory_region.malware_signature.version | malware signature version | keyword |
| process.Ext.memory_region.mapped_path | If the memory corresponds to a file mapping, this is the file's path. | keyword |
| process.Ext.memory_region.mapped_pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.mapped_pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.mapped_pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.mapped_pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.Ext.memory_region.mapped_pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.mapped_pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.mapped_pe_detected | Whether the file at mapped_path is an executable. | boolean |
| process.Ext.memory_region.memory_pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.memory_pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.memory_pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.memory_pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.Ext.memory_region.memory_pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.memory_pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.Ext.memory_region.memory_pe_detected | Whether an executable file was found in memory. | boolean |
| process.Ext.memory_region.region_base | Base address of the memory region. | unsigned_long |
| process.Ext.memory_region.region_protection | Memory protection of the memory region. Example values include "RWX" and "R-X". | keyword |
| process.Ext.memory_region.region_size | Size of the memory region. | unsigned_long |
| process.Ext.memory_region.region_state | State of the memory region. Example values include "RESERVE", "COMMIT", and "FREE". | keyword |
| process.Ext.memory_region.strings | Array of strings found within the memory region. | keyword |
| process.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| process.Ext.services | Services running in this process. | keyword |
| process.Ext.session | Session information for the current process | keyword |
| process.Ext.token.domain | Domain of token user. | keyword |
| process.Ext.token.elevation | Whether the token is elevated or not | boolean |
| process.Ext.token.elevation_type | What level of elevation the token has | keyword |
| process.Ext.token.impersonation_level | Impersonation level. Only valid for impersonation tokens. | keyword |
| process.Ext.token.integrity_level | Numeric integrity level. | long |
| process.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| process.Ext.token.is_appcontainer | Whether or not this is an appcontainer token. | boolean |
| process.Ext.token.privileges | Array describing the privileges associated with the token. | nested |
| process.Ext.token.privileges.description | Description of the privilege. | keyword |
| process.Ext.token.privileges.enabled | Whether or not the privilege is enabled. | boolean |
| process.Ext.token.privileges.name | Name of the privilege. | keyword |
| process.Ext.token.sid | Token user's Security Identifier (SID). | keyword |
| process.Ext.token.type | Type of the token, either primary or impersonation. | keyword |
| process.Ext.token.user | Username of token owner. | keyword |
| process.Ext.user | User associated with the running process. | keyword |
| process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.entry_leader.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.entry_leader.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.entry_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.entry_meta.source.ip | IP address of the source (IPv4 or IPv6). | ip |
| process.entry_leader.entry_meta.type | The entry type for the entry session leader. Values include: init(e.g systemd), sshd, ssm, kubelet, teleport, terminal, console Note: This field is only set on process.session_leader. | keyword |
| process.entry_leader.executable | Absolute path to the process executable. | keyword |
| process.entry_leader.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.group.name | Name of the group. | keyword |
| process.entry_leader.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.entry_leader.name | Process name. Sometimes called program name or similar. | keyword |
| process.entry_leader.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.parent.pid | Process id. | long |
| process.entry_leader.parent.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.parent.session_leader.pid | Process id. | long |
| process.entry_leader.parent.session_leader.start | The time the process started. | date |
| process.entry_leader.parent.start | The time the process started. | date |
| process.entry_leader.pid | Process id. | long |
| process.entry_leader.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.real_group.name | Name of the group. | keyword |
| process.entry_leader.real_user.id | Unique identifier of the user. | keyword |
| process.entry_leader.real_user.name | Short name or login of the user. | keyword |
| process.entry_leader.same_as_process | This boolean is used to identify if a leader process is the same as the top level process. For example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`. This field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader) Instead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true` Note: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`. | boolean |
| process.entry_leader.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.saved_group.name | Name of the group. | keyword |
| process.entry_leader.saved_user.id | Unique identifier of the user. | keyword |
| process.entry_leader.saved_user.name | Short name or login of the user. | keyword |
| process.entry_leader.start | The time the process started. | date |
| process.entry_leader.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.supplemental_groups.name | Name of the group. | keyword |
| process.entry_leader.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.entry_leader.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.entry_leader.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.entry_leader.user.id | Unique identifier of the user. | keyword |
| process.entry_leader.user.name | Short name or login of the user. | keyword |
| process.entry_leader.working_directory | The working directory of the process. | keyword |
| process.env_vars | Array of environment variable bindings. Captured from a snapshot of the environment at the time of execution. May be filtered to protect sensitive information. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.exit_code | The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start). | long |
| process.group_leader.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.group_leader.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.group_leader.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.group_leader.executable | Absolute path to the process executable. | keyword |
| process.group_leader.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.group.name | Name of the group. | keyword |
| process.group_leader.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.group_leader.name | Process name. Sometimes called program name or similar. | keyword |
| process.group_leader.pid | Process id. | long |
| process.group_leader.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.real_group.name | Name of the group. | keyword |
| process.group_leader.real_user.id | Unique identifier of the user. | keyword |
| process.group_leader.real_user.name | Short name or login of the user. | keyword |
| process.group_leader.same_as_process | This boolean is used to identify if a leader process is the same as the top level process. For example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`. This field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader) Instead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true` Note: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`. | boolean |
| process.group_leader.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.saved_group.name | Name of the group. | keyword |
| process.group_leader.saved_user.id | Unique identifier of the user. | keyword |
| process.group_leader.saved_user.name | Short name or login of the user. | keyword |
| process.group_leader.start | The time the process started. | date |
| process.group_leader.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.supplemental_groups.name | Name of the group. | keyword |
| process.group_leader.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.group_leader.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.group_leader.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.group_leader.user.id | Unique identifier of the user. | keyword |
| process.group_leader.user.name | Short name or login of the user. | keyword |
| process.group_leader.working_directory | The working directory of the process. | keyword |
| process.hash.md5 | MD5 hash. | keyword |
| process.hash.sha1 | SHA1 hash. | keyword |
| process.hash.sha256 | SHA256 hash. | keyword |
| process.hash.sha512 | SHA512 hash. | keyword |
| process.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.parent.Ext | Object for all custom defined fields to live in. | object |
| process.parent.Ext.architecture | Process architecture.  It can differ from host architecture. | keyword |
| process.parent.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.parent.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.parent.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.parent.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.parent.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.parent.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.parent.Ext.dll.Ext | Object for all custom defined fields to live in. | object |
| process.parent.Ext.dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.parent.Ext.dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.parent.Ext.dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.parent.Ext.dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.parent.Ext.dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.parent.Ext.dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.parent.Ext.dll.Ext.compile_time | Timestamp from when the module was compiled. | date |
| process.parent.Ext.dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| process.parent.Ext.dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| process.parent.Ext.dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.parent.Ext.dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.parent.Ext.dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.parent.Ext.dll.code_signature.subject_name | Subject name of the code signer | keyword |
| process.parent.Ext.dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.parent.Ext.dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.parent.Ext.dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.parent.Ext.dll.hash.md5 | MD5 hash. | keyword |
| process.parent.Ext.dll.hash.sha1 | SHA1 hash. | keyword |
| process.parent.Ext.dll.hash.sha256 | SHA256 hash. | keyword |
| process.parent.Ext.dll.hash.sha512 | SHA512 hash. | keyword |
| process.parent.Ext.dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| process.parent.Ext.dll.path | Full file path of the library. | keyword |
| process.parent.Ext.dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.parent.Ext.dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.parent.Ext.dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.parent.Ext.dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.parent.Ext.dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.parent.Ext.dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.parent.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| process.parent.Ext.real | The field set containing process info in case of any pid spoofing. This is mainly useful for process.parent. | object |
| process.parent.Ext.real.pid | For process.parent this will be the ppid of the process that actually spawned the current process. | long |
| process.parent.Ext.token.domain | Domain of token user. | keyword |
| process.parent.Ext.token.elevation | Whether the token is elevated or not | boolean |
| process.parent.Ext.token.elevation_type | What level of elevation the token has | keyword |
| process.parent.Ext.token.impersonation_level | Impersonation level. Only valid for impersonation tokens. | keyword |
| process.parent.Ext.token.integrity_level | Numeric integrity level. | long |
| process.parent.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| process.parent.Ext.token.is_appcontainer | Whether or not this is an appcontainer token. | boolean |
| process.parent.Ext.token.privileges | Array describing the privileges associated with the token. | nested |
| process.parent.Ext.token.privileges.description | Description of the privilege. | keyword |
| process.parent.Ext.token.privileges.enabled | Whether or not the privilege is enabled. | boolean |
| process.parent.Ext.token.privileges.name | Name of the privilege. | keyword |
| process.parent.Ext.token.sid | Token user's Security Identifier (SID). | keyword |
| process.parent.Ext.token.type | Type of the token, either primary or impersonation. | keyword |
| process.parent.Ext.token.user | Username of token owner. | keyword |
| process.parent.Ext.user | User associated with the running process. | keyword |
| process.parent.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.parent.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.parent.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.parent.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.parent.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.parent.code_signature.subject_name | Subject name of the code signer | keyword |
| process.parent.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.parent.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.parent.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.parent.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.executable | Absolute path to the process executable. | keyword |
| process.parent.exit_code | The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start). | long |
| process.parent.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.group.name | Name of the group. | keyword |
| process.parent.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.group_leader.pid | Process id. | long |
| process.parent.group_leader.start | The time the process started. | date |
| process.parent.hash.md5 | MD5 hash. | keyword |
| process.parent.hash.sha1 | SHA1 hash. | keyword |
| process.parent.hash.sha256 | SHA256 hash. | keyword |
| process.parent.hash.sha512 | SHA512 hash. | keyword |
| process.parent.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.parent.name | Process name. Sometimes called program name or similar. | keyword |
| process.parent.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.parent.pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.parent.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.parent.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.parent.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.parent.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.parent.pgid | Deprecated for removal in next major version release. This field is superseded by `process.group_leader.pid`. Identifier of the group of processes the process belongs to. | long |
| process.parent.pid | Process id. | long |
| process.parent.ppid | Parent process' pid. | long |
| process.parent.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.real_group.name | Name of the group. | keyword |
| process.parent.real_user.id | Unique identifier of the user. | keyword |
| process.parent.real_user.name | Short name or login of the user. | keyword |
| process.parent.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.saved_group.name | Name of the group. | keyword |
| process.parent.saved_user.id | Unique identifier of the user. | keyword |
| process.parent.saved_user.name | Short name or login of the user. | keyword |
| process.parent.start | The time the process started. | date |
| process.parent.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.supplemental_groups.name | Name of the group. | keyword |
| process.parent.thread.id | Thread ID. | long |
| process.parent.thread.name | Thread name. | keyword |
| process.parent.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| process.parent.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.parent.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.parent.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.parent.uptime | Seconds the process has been up. | long |
| process.parent.user.id | Unique identifier of the user. | keyword |
| process.parent.user.name | Short name or login of the user. | keyword |
| process.parent.working_directory | The working directory of the process. | keyword |
| process.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.pgid | Deprecated for removal in next major version release. This field is superseded by `process.group_leader.pid`. Identifier of the group of processes the process belongs to. | long |
| process.pid | Process id. | long |
| process.ppid | Parent process' pid. | long |
| process.previous.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.previous.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.previous.executable | Absolute path to the process executable. | keyword |
| process.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.real_group.name | Name of the group. | keyword |
| process.real_user.id | Unique identifier of the user. | keyword |
| process.real_user.name | Short name or login of the user. | keyword |
| process.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.saved_group.name | Name of the group. | keyword |
| process.saved_user.id | Unique identifier of the user. | keyword |
| process.saved_user.name | Short name or login of the user. | keyword |
| process.session_leader.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.session_leader.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.session_leader.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.session_leader.executable | Absolute path to the process executable. | keyword |
| process.session_leader.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.group.name | Name of the group. | keyword |
| process.session_leader.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.session_leader.name | Process name. Sometimes called program name or similar. | keyword |
| process.session_leader.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.session_leader.parent.pid | Process id. | long |
| process.session_leader.parent.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.session_leader.parent.session_leader.pid | Process id. | long |
| process.session_leader.parent.session_leader.start | The time the process started. | date |
| process.session_leader.parent.start | The time the process started. | date |
| process.session_leader.pid | Process id. | long |
| process.session_leader.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.real_group.name | Name of the group. | keyword |
| process.session_leader.real_user.id | Unique identifier of the user. | keyword |
| process.session_leader.real_user.name | Short name or login of the user. | keyword |
| process.session_leader.same_as_process | This boolean is used to identify if a leader process is the same as the top level process. For example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`. This field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader) Instead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true` Note: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`. | boolean |
| process.session_leader.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.saved_group.name | Name of the group. | keyword |
| process.session_leader.saved_user.id | Unique identifier of the user. | keyword |
| process.session_leader.saved_user.name | Short name or login of the user. | keyword |
| process.session_leader.start | The time the process started. | date |
| process.session_leader.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.supplemental_groups.name | Name of the group. | keyword |
| process.session_leader.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.session_leader.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.session_leader.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.session_leader.user.id | Unique identifier of the user. | keyword |
| process.session_leader.user.name | Short name or login of the user. | keyword |
| process.session_leader.working_directory | The working directory of the process. | keyword |
| process.start | The time the process started. | date |
| process.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.supplemental_groups.name | Name of the group. | keyword |
| process.thread.Ext | Object for all custom defined fields to live in. | object |
| process.thread.Ext.hardware_breakpoint_set | Whether a hardware breakpoint was set for the thread. This field is omitted if false. | boolean |
| process.thread.Ext.original_start_address | When a trampoline was detected, this indicates the original content for the thread start address in memory. | unsigned_long |
| process.thread.Ext.original_start_address_allocation_offset | When a trampoline was detected, this indicates the offset of original_start_address from the allocation base. | unsigned_long |
| process.thread.Ext.original_start_address_bytes | When a trampoline was detected, this holds the hex-encoded bytes at the original thread start address. | keyword |
| process.thread.Ext.original_start_address_bytes_disasm | When a trampoline was detected, this holds the disassembled code at the original thread start address. | keyword |
| process.thread.Ext.original_start_address_bytes_disasm_hash | When a trampoline was detected, this holds the bytes at the original thread start address, with immediate values capped to 0x100, disassembled into human-readable assembly code, then hashed. | keyword |
| process.thread.Ext.original_start_address_module | When a trampoline was detected, this indicates the original content for the dll/module where the thread began execution. | keyword |
| process.thread.Ext.parameter | When a thread is created, this is the raw numerical value of its parameter. | unsigned_long |
| process.thread.Ext.parameter_bytes_compressed | Up to 512KB of raw data from the thread parameter, if it is a valid pointer. This is compressed with zlib. To reduce data volume, this is de-duplicated on the endpoint, and may be missing from many alerts if the same data would be sent multiple times. | keyword |
| process.thread.Ext.parameter_bytes_compressed_present | Whether parameter_bytes_compressed is present in this event. | boolean |
| process.thread.Ext.service | Service associated with the thread. | keyword |
| process.thread.Ext.start | The time the thread started. | date |
| process.thread.Ext.start_address | Memory address where the thread began execution. | unsigned_long |
| process.thread.Ext.start_address_allocation_offset | Offset of start_address into the memory allocation. Equal to start_address - start_address_details.allocation_base. | unsigned_long |
| process.thread.Ext.start_address_bytes | A few (typically 32) raw opcode bytes at the thread start address, hex-encoded. | keyword |
| process.thread.Ext.start_address_bytes_disasm | The bytes at the thread start address, disassembled into human-readable assembly code. | keyword |
| process.thread.Ext.start_address_bytes_disasm_hash | The bytes at the thread start address, with immediate values capped to 0x100, disassembled into human-readable assembly code, then hashed. | keyword |
| process.thread.Ext.start_address_module | The dll/module where the thread began execution. | keyword |
| process.thread.Ext.token.domain | Domain of token user. | keyword |
| process.thread.Ext.token.elevation | Whether the token is elevated or not | boolean |
| process.thread.Ext.token.elevation_type | What level of elevation the token has | keyword |
| process.thread.Ext.token.impersonation_level | Impersonation level. Only valid for impersonation tokens. | keyword |
| process.thread.Ext.token.integrity_level | Numeric integrity level. | long |
| process.thread.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| process.thread.Ext.token.is_appcontainer | Whether or not this is an appcontainer token. | boolean |
| process.thread.Ext.token.privileges | Array describing the privileges associated with the token. | nested |
| process.thread.Ext.token.privileges.description | Description of the privilege. | keyword |
| process.thread.Ext.token.privileges.enabled | Whether or not the privilege is enabled. | boolean |
| process.thread.Ext.token.privileges.name | Name of the privilege. | keyword |
| process.thread.Ext.token.sid | Token user's Security Identifier (SID). | keyword |
| process.thread.Ext.token.type | Type of the token, either primary or impersonation. | keyword |
| process.thread.Ext.token.user | Username of token owner. | keyword |
| process.thread.Ext.uptime | Seconds since thread started. | long |
| process.thread.id | Thread ID. | long |
| process.thread.name | Thread name. | keyword |
| process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| process.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.uptime | Seconds the process has been up. | long |
| process.user.id | Unique identifier of the user. | keyword |
| process.user.name | Short name or login of the user. | keyword |
| process.working_directory | The working directory of the process. | keyword |
| registry.data.strings | Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`). | wildcard |
| registry.path | Full path, including hive, key and value | keyword |
| registry.value | Name of the value written. | keyword |
| rule.author | Name, organization, or pseudonym of the author or authors who created the rule used to generate this event. | keyword |
| rule.category | A categorization value keyword used by the entity using the rule for detection of this event. | keyword |
| rule.description | The description of the rule generating the event. | keyword |
| rule.id | A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event. | keyword |
| rule.license | Name of the license under which the rule used to generate this event is made available. | keyword |
| rule.name | The name of the rule or signature generating the event. | keyword |
| rule.reference | Reference URL to additional information about the rule used to generate this event. The URL can point to the vendor's documentation about the rule. If that's not available, it can also be a link to a more general page describing this type of alert. | keyword |
| rule.ruleset | Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member. | keyword |
| rule.uuid | A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event. | keyword |
| rule.version | The version / revision of the rule being used for analysis. | keyword |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| source.ip | IP address of the source (IPv4 or IPv6). | ip |
| threat.enrichments | A list of associated indicators objects enriching the event, and the context of that association/enrichment. | nested |
| threat.enrichments.indicator | Object containing associated indicators enriching the event. | object |
| threat.enrichments.indicator.file.Ext | Object for all custom defined fields to live in. | object |
| threat.enrichments.indicator.file.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| threat.enrichments.indicator.file.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| threat.enrichments.indicator.file.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| threat.enrichments.indicator.file.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| threat.enrichments.indicator.file.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| threat.enrichments.indicator.file.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| threat.enrichments.indicator.file.Ext.device.bus_type | Bus type of the device, such as Nvme, Usb, FileBackedVirtual,... etc. | keyword |
| threat.enrichments.indicator.file.Ext.device.dos_name | DOS name of the device. DOS device name is in the format of driver letters such as C:, D:,... | keyword |
| threat.enrichments.indicator.file.Ext.device.file_system_type | Volume device file system type. Following are examples of the most frequently seen volume device file system types: NTFS UDF | keyword |
| threat.enrichments.indicator.file.Ext.device.nt_name | NT name of the device. NT device name is in the format such as: \Device\HarddiskVolume2 | keyword |
| threat.enrichments.indicator.file.Ext.device.product_id | ProductID of the device. It is provided by the vendor of the device if any. | keyword |
| threat.enrichments.indicator.file.Ext.device.serial_number | Serial Number of the device. It is provided by the vendor of the device if any. | keyword |
| threat.enrichments.indicator.file.Ext.device.vendor_id | VendorID of the device. It is provided by the vendor of the device. | keyword |
| threat.enrichments.indicator.file.Ext.device.volume_device_type | Volume device type. Following are examples of the most frequently seen volume device types: Disk File System CD-ROM File System | keyword |
| threat.enrichments.indicator.file.Ext.entropy | Entropy calculation of file's header and footer used to check file integrity. | double |
| threat.enrichments.indicator.file.Ext.entry_modified | Time of last status change.  See `st_ctim` member of `struct stat`. | double |
| threat.enrichments.indicator.file.Ext.header_bytes | First 16 bytes of file used to check file integrity. | keyword |
| threat.enrichments.indicator.file.Ext.header_data | First 16 bytes of file used to check file integrity. | text |
| threat.enrichments.indicator.file.Ext.malware_classification.features.data.buffer | The features extracted from this file and evaluated by the model.  Usually an array of floats.  Likely zlib-encoded. | keyword |
| threat.enrichments.indicator.file.Ext.malware_classification.features.data.decompressed_size | The decompressed size of buffer. | integer |
| threat.enrichments.indicator.file.Ext.malware_classification.features.data.encoding | The encoding of buffer (e.g. zlib). | keyword |
| threat.enrichments.indicator.file.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| threat.enrichments.indicator.file.Ext.malware_classification.score | The score produced by the classification model. | double |
| threat.enrichments.indicator.file.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| threat.enrichments.indicator.file.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| threat.enrichments.indicator.file.Ext.malware_classification.version | The version of the model used. | keyword |
| threat.enrichments.indicator.file.Ext.malware_signature | Nested version of malware_signature fieldset. | nested |
| threat.enrichments.indicator.file.Ext.malware_signature.all_names | The concatenated names of all yara signatures | text |
| threat.enrichments.indicator.file.Ext.malware_signature.identifier | Malware artifact identifier. | text |
| threat.enrichments.indicator.file.Ext.malware_signature.primary | Primary malware signature match. | nested |
| threat.enrichments.indicator.file.Ext.malware_signature.primary.matches | An array of bytes representing yara signature matches | nested |
| threat.enrichments.indicator.file.Ext.malware_signature.primary.signature | Primary malware signature match. | nested |
| threat.enrichments.indicator.file.Ext.malware_signature.primary.signature.hash | Primary malware signature hash. | nested |
| threat.enrichments.indicator.file.Ext.malware_signature.primary.signature.hash.sha256 | Primary malware signature sha256. | keyword |
| threat.enrichments.indicator.file.Ext.malware_signature.primary.signature.id | Primary malware signature id. | keyword |
| threat.enrichments.indicator.file.Ext.malware_signature.primary.signature.name | Primary malware signature name. | keyword |
| threat.enrichments.indicator.file.Ext.malware_signature.secondary | An array of malware signature matches | nested |
| threat.enrichments.indicator.file.Ext.malware_signature.version | Primary malware signature version. | keyword |
| threat.enrichments.indicator.file.Ext.monotonic_id | File event monotonic ID. | unsigned_long |
| threat.enrichments.indicator.file.Ext.original | Original file information during a modification event. | object |
| threat.enrichments.indicator.file.Ext.original.gid | Primary group ID (GID) of the file. | keyword |
| threat.enrichments.indicator.file.Ext.original.group | Primary group name of the file. | keyword |
| threat.enrichments.indicator.file.Ext.original.mode | Original file mode prior to a modification event | keyword |
| threat.enrichments.indicator.file.Ext.original.name | Original file name prior to a modification event | keyword |
| threat.enrichments.indicator.file.Ext.original.owner | File owner's username. | keyword |
| threat.enrichments.indicator.file.Ext.original.path | Original file path prior to a modification event | keyword |
| threat.enrichments.indicator.file.Ext.original.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| threat.enrichments.indicator.file.Ext.quarantine_message | Message describing quarantine results. | keyword |
| threat.enrichments.indicator.file.Ext.quarantine_path | Path on endpoint the quarantined file was originally. | keyword |
| threat.enrichments.indicator.file.Ext.quarantine_result | Boolean representing whether or not file quarantine succeeded. | boolean |
| threat.enrichments.indicator.file.Ext.temp_file_path | Path on endpoint where a copy of the file is being stored.  Used to make ephemeral files retrievable. | keyword |
| threat.enrichments.indicator.file.Ext.windows | Platform-specific Windows fields | object |
| threat.enrichments.indicator.file.Ext.windows.zone_identifier | Windows zone identifier for a file | keyword |
| threat.enrichments.indicator.file.accessed | Last time the file was accessed. Note that not all filesystems keep track of access time. | date |
| threat.enrichments.indicator.file.attributes | Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write. | keyword |
| threat.enrichments.indicator.file.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| threat.enrichments.indicator.file.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| threat.enrichments.indicator.file.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| threat.enrichments.indicator.file.code_signature.subject_name | Subject name of the code signer | keyword |
| threat.enrichments.indicator.file.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| threat.enrichments.indicator.file.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| threat.enrichments.indicator.file.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| threat.enrichments.indicator.file.created | File creation time. Note that not all filesystems store the creation time. | date |
| threat.enrichments.indicator.file.ctime | Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file. | date |
| threat.enrichments.indicator.file.device | Device that is the source of the file. | keyword |
| threat.enrichments.indicator.file.directory | Directory where the file is located. It should include the drive letter, when appropriate. | keyword |
| threat.enrichments.indicator.file.drive_letter | Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon. | keyword |
| threat.enrichments.indicator.file.elf.architecture | Machine architecture of the ELF file. | keyword |
| threat.enrichments.indicator.file.elf.byte_order | Byte sequence of ELF file. | keyword |
| threat.enrichments.indicator.file.elf.cpu_type | CPU type of the ELF file. | keyword |
| threat.enrichments.indicator.file.elf.creation_date | Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators. | date |
| threat.enrichments.indicator.file.elf.exports | List of exported element names and types. | flattened |
| threat.enrichments.indicator.file.elf.go_import_hash | A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. The algorithm used to calculate the Go symbol hash and a reference implementation are available [here](https://github.com/elastic/toutoumomoma). | keyword |
| threat.enrichments.indicator.file.elf.go_imports | List of imported Go language element names and types. | flattened |
| threat.enrichments.indicator.file.elf.go_imports_names_entropy | Shannon entropy calculation from the list of Go imports. | long |
| threat.enrichments.indicator.file.elf.go_imports_names_var_entropy | Variance for Shannon entropy calculation from the list of Go imports. | long |
| threat.enrichments.indicator.file.elf.go_stripped | Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable. | boolean |
| threat.enrichments.indicator.file.elf.header.abi_version | Version of the ELF Application Binary Interface (ABI). | keyword |
| threat.enrichments.indicator.file.elf.header.class | Header class of the ELF file. | keyword |
| threat.enrichments.indicator.file.elf.header.data | Data table of the ELF header. | keyword |
| threat.enrichments.indicator.file.elf.header.entrypoint | Header entrypoint of the ELF file. | long |
| threat.enrichments.indicator.file.elf.header.object_version | "0x1" for original ELF files. | keyword |
| threat.enrichments.indicator.file.elf.header.os_abi | Application Binary Interface (ABI) of the Linux OS. | keyword |
| threat.enrichments.indicator.file.elf.header.type | Header type of the ELF file. | keyword |
| threat.enrichments.indicator.file.elf.header.version | Version of the ELF header. | keyword |
| threat.enrichments.indicator.file.elf.import_hash | A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. This is an ELF implementation of the Windows PE imphash. | keyword |
| threat.enrichments.indicator.file.elf.imports | List of imported element names and types. | flattened |
| threat.enrichments.indicator.file.elf.imports_names_entropy | Shannon entropy calculation from the list of imported element names and types. | long |
| threat.enrichments.indicator.file.elf.imports_names_var_entropy | Variance for Shannon entropy calculation from the list of imported element names and types. | long |
| threat.enrichments.indicator.file.elf.sections | An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`. | nested |
| threat.enrichments.indicator.file.elf.sections.chi2 | Chi-square probability distribution of the section. | long |
| threat.enrichments.indicator.file.elf.sections.entropy | Shannon entropy calculation from the section. | long |
| threat.enrichments.indicator.file.elf.sections.flags | ELF Section List flags. | keyword |
| threat.enrichments.indicator.file.elf.sections.name | ELF Section List name. | keyword |
| threat.enrichments.indicator.file.elf.sections.physical_offset | ELF Section List offset. | keyword |
| threat.enrichments.indicator.file.elf.sections.physical_size | ELF Section List physical size. | long |
| threat.enrichments.indicator.file.elf.sections.type | ELF Section List type. | keyword |
| threat.enrichments.indicator.file.elf.sections.var_entropy | Variance for Shannon entropy calculation from the section. | long |
| threat.enrichments.indicator.file.elf.sections.virtual_address | ELF Section List virtual address. | long |
| threat.enrichments.indicator.file.elf.sections.virtual_size | ELF Section List virtual size. | long |
| threat.enrichments.indicator.file.elf.segments | An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`. | nested |
| threat.enrichments.indicator.file.elf.segments.sections | ELF object segment sections. | keyword |
| threat.enrichments.indicator.file.elf.segments.type | ELF object segment type. | keyword |
| threat.enrichments.indicator.file.elf.shared_libraries | List of shared libraries used by this ELF object. | keyword |
| threat.enrichments.indicator.file.elf.telfhash | telfhash symbol hash for ELF file. | keyword |
| threat.enrichments.indicator.file.extension | File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword |
| threat.enrichments.indicator.file.gid | Primary group ID (GID) of the file. | keyword |
| threat.enrichments.indicator.file.group | Primary group name of the file. | keyword |
| threat.enrichments.indicator.file.hash.md5 | MD5 hash. | keyword |
| threat.enrichments.indicator.file.hash.sha1 | SHA1 hash. | keyword |
| threat.enrichments.indicator.file.hash.sha256 | SHA256 hash. | keyword |
| threat.enrichments.indicator.file.hash.sha512 | SHA512 hash. | keyword |
| threat.enrichments.indicator.file.hash.ssdeep | SSDEEP hash. | keyword |
| threat.enrichments.indicator.file.inode | Inode representing the file in the filesystem. | keyword |
| threat.enrichments.indicator.file.mime_type | MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used. | keyword |
| threat.enrichments.indicator.file.mode | Mode of the file in octal representation. | keyword |
| threat.enrichments.indicator.file.mtime | Last time the file content was modified. | date |
| threat.enrichments.indicator.file.name | Name of the file including the extension, without the directory. | keyword |
| threat.enrichments.indicator.file.owner | File owner's username. | keyword |
| threat.enrichments.indicator.file.path | Full path to the file, including the file name. It should include the drive letter, when appropriate. | keyword |
| threat.enrichments.indicator.file.pe.architecture | CPU architecture target for the file. | keyword |
| threat.enrichments.indicator.file.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| threat.enrichments.indicator.file.pe.description | Internal description of the file, provided at compile-time. | keyword |
| threat.enrichments.indicator.file.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| threat.enrichments.indicator.file.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| threat.enrichments.indicator.file.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| threat.enrichments.indicator.file.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| threat.enrichments.indicator.file.size | File size in bytes. Only relevant when `file.type` is "file". | long |
| threat.enrichments.indicator.file.target_path | Target path for symlinks. | keyword |
| threat.enrichments.indicator.file.type | File type (file, dir, or symlink). | keyword |
| threat.enrichments.indicator.file.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| threat.enrichments.indicator.first_seen | The date and time when intelligence source first reported sighting this indicator. | date |
| threat.enrichments.indicator.geo.city_name | City name. | keyword |
| threat.enrichments.indicator.geo.continent_code | Two-letter code representing continent's name. | keyword |
| threat.enrichments.indicator.geo.continent_name | Name of the continent. | keyword |
| threat.enrichments.indicator.geo.country_iso_code | Country ISO code. | keyword |
| threat.enrichments.indicator.geo.country_name | Country name. | keyword |
| threat.enrichments.indicator.geo.location | Longitude and latitude. | geo_point |
| threat.enrichments.indicator.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| threat.enrichments.indicator.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| threat.enrichments.indicator.geo.region_iso_code | Region ISO code. | keyword |
| threat.enrichments.indicator.geo.region_name | Region name. | keyword |
| threat.enrichments.indicator.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| threat.enrichments.indicator.ip | Identifies a threat indicator as an IP address (irrespective of direction). | ip |
| threat.enrichments.indicator.last_seen | The date and time when intelligence source last reported sighting this indicator. | date |
| threat.enrichments.indicator.marking.tlp | Traffic Light Protocol sharing markings. | keyword |
| threat.enrichments.indicator.modified_at | The date and time when intelligence source last modified information for this indicator. | date |
| threat.enrichments.indicator.port | Identifies a threat indicator as a port number (irrespective of direction). | long |
| threat.enrichments.indicator.provider | The name of the indicator's provider. | keyword |
| threat.enrichments.indicator.reference | Reference URL linking to additional information about this indicator. | keyword |
| threat.enrichments.indicator.registry.data.bytes | Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values. | keyword |
| threat.enrichments.indicator.registry.data.strings | Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`). | wildcard |
| threat.enrichments.indicator.registry.data.type | Standard registry type for encoding contents | keyword |
| threat.enrichments.indicator.registry.hive | Abbreviated name for the hive. | keyword |
| threat.enrichments.indicator.registry.key | Hive-relative path of keys. | keyword |
| threat.enrichments.indicator.registry.path | Full path, including hive, key and value | keyword |
| threat.enrichments.indicator.registry.value | Name of the value written. | keyword |
| threat.enrichments.indicator.scanner_stats | Count of AV/EDR vendors that successfully detected malicious file or URL. | long |
| threat.enrichments.indicator.sightings | Number of times this indicator was observed conducting threat activity. | long |
| threat.enrichments.indicator.type | Type of indicator as represented by Cyber Observable in STIX 2.0. | keyword |
| threat.enrichments.indicator.url.domain | Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field. | keyword |
| threat.enrichments.indicator.url.extension | The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword |
| threat.enrichments.indicator.url.fragment | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment. | keyword |
| threat.enrichments.indicator.url.full | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source. | wildcard |
| threat.enrichments.indicator.url.original | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not. | wildcard |
| threat.enrichments.indicator.url.password | Password of the request. | keyword |
| threat.enrichments.indicator.url.path | Path of the request, such as "/search". | wildcard |
| threat.enrichments.indicator.url.port | Port of the request, such as 443. | long |
| threat.enrichments.indicator.url.query | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases. | keyword |
| threat.enrichments.indicator.url.registered_domain | The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk". | keyword |
| threat.enrichments.indicator.url.scheme | Scheme of the request, such as "https". Note: The `:` is not part of the scheme. | keyword |
| threat.enrichments.indicator.url.subdomain | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period. | keyword |
| threat.enrichments.indicator.url.top_level_domain | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk". | keyword |
| threat.enrichments.indicator.url.username | Username of the request. | keyword |
| threat.enrichments.indicator.x509.alternative_names | List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses. | keyword |
| threat.enrichments.indicator.x509.issuer.common_name | List of common name (CN) of issuing certificate authority. | keyword |
| threat.enrichments.indicator.x509.issuer.country | List of country \(C) codes | keyword |
| threat.enrichments.indicator.x509.issuer.distinguished_name | Distinguished name (DN) of issuing certificate authority. | keyword |
| threat.enrichments.indicator.x509.issuer.locality | List of locality names (L) | keyword |
| threat.enrichments.indicator.x509.issuer.organization | List of organizations (O) of issuing certificate authority. | keyword |
| threat.enrichments.indicator.x509.issuer.organizational_unit | List of organizational units (OU) of issuing certificate authority. | keyword |
| threat.enrichments.indicator.x509.issuer.state_or_province | List of state or province names (ST, S, or P) | keyword |
| threat.enrichments.indicator.x509.not_after | Time at which the certificate is no longer considered valid. | date |
| threat.enrichments.indicator.x509.not_before | Time at which the certificate is first considered valid. | date |
| threat.enrichments.indicator.x509.public_key_algorithm | Algorithm used to generate the public key. | keyword |
| threat.enrichments.indicator.x509.public_key_curve | The curve used by the elliptic curve public key algorithm. This is algorithm specific. | keyword |
| threat.enrichments.indicator.x509.public_key_exponent | Exponent used to derive the public key. This is algorithm specific. | long |
| threat.enrichments.indicator.x509.public_key_size | The size of the public key space in bits. | long |
| threat.enrichments.indicator.x509.serial_number | Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters. | keyword |
| threat.enrichments.indicator.x509.signature_algorithm | Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353. | keyword |
| threat.enrichments.indicator.x509.subject.common_name | List of common names (CN) of subject. | keyword |
| threat.enrichments.indicator.x509.subject.country | List of country \(C) code | keyword |
| threat.enrichments.indicator.x509.subject.distinguished_name | Distinguished name (DN) of the certificate subject entity. | keyword |
| threat.enrichments.indicator.x509.subject.locality | List of locality names (L) | keyword |
| threat.enrichments.indicator.x509.subject.organization | List of organizations (O) of subject. | keyword |
| threat.enrichments.indicator.x509.subject.organizational_unit | List of organizational units (OU) of subject. | keyword |
| threat.enrichments.indicator.x509.subject.state_or_province | List of state or province names (ST, S, or P) | keyword |
| threat.enrichments.indicator.x509.version_number | Version of x509 format. | keyword |
| threat.enrichments.matched.atomic | Identifies the atomic indicator value that matched a local environment endpoint or network event. | keyword |
| threat.enrichments.matched.field | Identifies the field of the atomic indicator that matched a local environment endpoint or network event. | keyword |
| threat.enrichments.matched.id | Identifies the _id of the indicator document enriching the event. | keyword |
| threat.enrichments.matched.index | Identifies the _index of the indicator document enriching the event. | keyword |
| threat.enrichments.matched.type | Identifies the type of match that caused the event to be enriched with the given indicator | keyword |
| threat.framework | Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events. | keyword |
| threat.group.alias | The alias(es) of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group alias(es). | keyword |
| threat.group.id | The id of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group id. | keyword |
| threat.group.name | The name of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group name. | keyword |
| threat.group.reference | The reference URL of the group for a set of related intrusion activity that are tracked by a common name in the security community. While not required, you can use a MITRE ATT&CK® group reference URL. | keyword |
| threat.indicator.as.number | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet. | long |
| threat.indicator.as.organization.name | Organization name. | keyword |
| threat.indicator.confidence | Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields. | keyword |
| threat.indicator.description | Describes the type of action conducted by the threat. | keyword |
| threat.indicator.email.address | Identifies a threat indicator as an email address (irrespective of direction). | keyword |
| threat.indicator.file.Ext | Object for all custom defined fields to live in. | object |
| threat.indicator.file.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| threat.indicator.file.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| threat.indicator.file.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| threat.indicator.file.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| threat.indicator.file.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| threat.indicator.file.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| threat.indicator.file.Ext.device.bus_type | Bus type of the device, such as Nvme, Usb, FileBackedVirtual,... etc. | keyword |
| threat.indicator.file.Ext.device.dos_name | DOS name of the device. DOS device name is in the format of driver letters such as C:, D:,... | keyword |
| threat.indicator.file.Ext.device.file_system_type | Volume device file system type. Following are examples of the most frequently seen volume device file system types: NTFS UDF | keyword |
| threat.indicator.file.Ext.device.nt_name | NT name of the device. NT device name is in the format such as: \Device\HarddiskVolume2 | keyword |
| threat.indicator.file.Ext.device.product_id | ProductID of the device. It is provided by the vendor of the device if any. | keyword |
| threat.indicator.file.Ext.device.serial_number | Serial Number of the device. It is provided by the vendor of the device if any. | keyword |
| threat.indicator.file.Ext.device.vendor_id | VendorID of the device. It is provided by the vendor of the device. | keyword |
| threat.indicator.file.Ext.device.volume_device_type | Volume device type. Following are examples of the most frequently seen volume device types: Disk File System CD-ROM File System | keyword |
| threat.indicator.file.Ext.entropy | Entropy calculation of file's header and footer used to check file integrity. | double |
| threat.indicator.file.Ext.entry_modified | Time of last status change.  See `st_ctim` member of `struct stat`. | double |
| threat.indicator.file.Ext.header_bytes | First 16 bytes of file used to check file integrity. | keyword |
| threat.indicator.file.Ext.header_data | First 16 bytes of file used to check file integrity. | text |
| threat.indicator.file.Ext.malware_classification.features.data.buffer | The features extracted from this file and evaluated by the model.  Usually an array of floats.  Likely zlib-encoded. | keyword |
| threat.indicator.file.Ext.malware_classification.features.data.decompressed_size | The decompressed size of buffer. | integer |
| threat.indicator.file.Ext.malware_classification.features.data.encoding | The encoding of buffer (e.g. zlib). | keyword |
| threat.indicator.file.Ext.malware_classification.identifier | The model's unique identifier. | keyword |
| threat.indicator.file.Ext.malware_classification.score | The score produced by the classification model. | double |
| threat.indicator.file.Ext.malware_classification.threshold | The score threshold for the model.  Files that score above this threshold are considered malicious. | double |
| threat.indicator.file.Ext.malware_classification.upx_packed | Whether UPX packing was detected. | boolean |
| threat.indicator.file.Ext.malware_classification.version | The version of the model used. | keyword |
| threat.indicator.file.Ext.malware_signature | Nested version of malware_signature fieldset. | nested |
| threat.indicator.file.Ext.malware_signature.all_names | The concatenated names of all yara signatures | text |
| threat.indicator.file.Ext.malware_signature.identifier | Malware artifact identifier. | text |
| threat.indicator.file.Ext.malware_signature.primary | Primary malware signature match. | nested |
| threat.indicator.file.Ext.malware_signature.primary.matches | An array of bytes representing yara signature matches | nested |
| threat.indicator.file.Ext.malware_signature.primary.signature | Primary malware signature match. | nested |
| threat.indicator.file.Ext.malware_signature.primary.signature.hash | Primary malware signature hash. | nested |
| threat.indicator.file.Ext.malware_signature.primary.signature.hash.sha256 | Primary malware signature sha256. | keyword |
| threat.indicator.file.Ext.malware_signature.primary.signature.id | Primary malware signature id. | keyword |
| threat.indicator.file.Ext.malware_signature.primary.signature.name | Primary malware signature name. | keyword |
| threat.indicator.file.Ext.malware_signature.secondary | An array of malware signature matches | nested |
| threat.indicator.file.Ext.malware_signature.version | Primary malware signature version. | keyword |
| threat.indicator.file.Ext.monotonic_id | File event monotonic ID. | unsigned_long |
| threat.indicator.file.Ext.original | Original file information during a modification event. | object |
| threat.indicator.file.Ext.original.gid | Primary group ID (GID) of the file. | keyword |
| threat.indicator.file.Ext.original.group | Primary group name of the file. | keyword |
| threat.indicator.file.Ext.original.mode | Original file mode prior to a modification event | keyword |
| threat.indicator.file.Ext.original.name | Original file name prior to a modification event | keyword |
| threat.indicator.file.Ext.original.owner | File owner's username. | keyword |
| threat.indicator.file.Ext.original.path | Original file path prior to a modification event | keyword |
| threat.indicator.file.Ext.original.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| threat.indicator.file.Ext.quarantine_message | Message describing quarantine results. | keyword |
| threat.indicator.file.Ext.quarantine_path | Path on endpoint the quarantined file was originally. | keyword |
| threat.indicator.file.Ext.quarantine_result | Boolean representing whether or not file quarantine succeeded. | boolean |
| threat.indicator.file.Ext.temp_file_path | Path on endpoint where a copy of the file is being stored.  Used to make ephemeral files retrievable. | keyword |
| threat.indicator.file.Ext.windows | Platform-specific Windows fields | object |
| threat.indicator.file.Ext.windows.zone_identifier | Windows zone identifier for a file | keyword |
| threat.indicator.file.accessed | Last time the file was accessed. Note that not all filesystems keep track of access time. | date |
| threat.indicator.file.attributes | Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write. | keyword |
| threat.indicator.file.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| threat.indicator.file.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| threat.indicator.file.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| threat.indicator.file.code_signature.subject_name | Subject name of the code signer | keyword |
| threat.indicator.file.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| threat.indicator.file.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| threat.indicator.file.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| threat.indicator.file.created | File creation time. Note that not all filesystems store the creation time. | date |
| threat.indicator.file.ctime | Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file. | date |
| threat.indicator.file.device | Device that is the source of the file. | keyword |
| threat.indicator.file.directory | Directory where the file is located. It should include the drive letter, when appropriate. | keyword |
| threat.indicator.file.drive_letter | Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon. | keyword |
| threat.indicator.file.elf.architecture | Machine architecture of the ELF file. | keyword |
| threat.indicator.file.elf.byte_order | Byte sequence of ELF file. | keyword |
| threat.indicator.file.elf.cpu_type | CPU type of the ELF file. | keyword |
| threat.indicator.file.elf.creation_date | Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators. | date |
| threat.indicator.file.elf.exports | List of exported element names and types. | flattened |
| threat.indicator.file.elf.go_import_hash | A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. The algorithm used to calculate the Go symbol hash and a reference implementation are available [here](https://github.com/elastic/toutoumomoma). | keyword |
| threat.indicator.file.elf.go_imports | List of imported Go language element names and types. | flattened |
| threat.indicator.file.elf.go_imports_names_entropy | Shannon entropy calculation from the list of Go imports. | long |
| threat.indicator.file.elf.go_imports_names_var_entropy | Variance for Shannon entropy calculation from the list of Go imports. | long |
| threat.indicator.file.elf.go_stripped | Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable. | boolean |
| threat.indicator.file.elf.header.abi_version | Version of the ELF Application Binary Interface (ABI). | keyword |
| threat.indicator.file.elf.header.class | Header class of the ELF file. | keyword |
| threat.indicator.file.elf.header.data | Data table of the ELF header. | keyword |
| threat.indicator.file.elf.header.entrypoint | Header entrypoint of the ELF file. | long |
| threat.indicator.file.elf.header.object_version | "0x1" for original ELF files. | keyword |
| threat.indicator.file.elf.header.os_abi | Application Binary Interface (ABI) of the Linux OS. | keyword |
| threat.indicator.file.elf.header.type | Header type of the ELF file. | keyword |
| threat.indicator.file.elf.header.version | Version of the ELF header. | keyword |
| threat.indicator.file.elf.import_hash | A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. This is an ELF implementation of the Windows PE imphash. | keyword |
| threat.indicator.file.elf.imports | List of imported element names and types. | flattened |
| threat.indicator.file.elf.imports_names_entropy | Shannon entropy calculation from the list of imported element names and types. | long |
| threat.indicator.file.elf.imports_names_var_entropy | Variance for Shannon entropy calculation from the list of imported element names and types. | long |
| threat.indicator.file.elf.sections | An array containing an object for each section of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`. | nested |
| threat.indicator.file.elf.sections.chi2 | Chi-square probability distribution of the section. | long |
| threat.indicator.file.elf.sections.entropy | Shannon entropy calculation from the section. | long |
| threat.indicator.file.elf.sections.flags | ELF Section List flags. | keyword |
| threat.indicator.file.elf.sections.name | ELF Section List name. | keyword |
| threat.indicator.file.elf.sections.physical_offset | ELF Section List offset. | keyword |
| threat.indicator.file.elf.sections.physical_size | ELF Section List physical size. | long |
| threat.indicator.file.elf.sections.type | ELF Section List type. | keyword |
| threat.indicator.file.elf.sections.var_entropy | Variance for Shannon entropy calculation from the section. | long |
| threat.indicator.file.elf.sections.virtual_address | ELF Section List virtual address. | long |
| threat.indicator.file.elf.sections.virtual_size | ELF Section List virtual size. | long |
| threat.indicator.file.elf.segments | An array containing an object for each segment of the ELF file. The keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`. | nested |
| threat.indicator.file.elf.segments.sections | ELF object segment sections. | keyword |
| threat.indicator.file.elf.segments.type | ELF object segment type. | keyword |
| threat.indicator.file.elf.shared_libraries | List of shared libraries used by this ELF object. | keyword |
| threat.indicator.file.elf.telfhash | telfhash symbol hash for ELF file. | keyword |
| threat.indicator.file.extension | File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword |
| threat.indicator.file.gid | Primary group ID (GID) of the file. | keyword |
| threat.indicator.file.group | Primary group name of the file. | keyword |
| threat.indicator.file.hash.md5 | MD5 hash. | keyword |
| threat.indicator.file.hash.sha1 | SHA1 hash. | keyword |
| threat.indicator.file.hash.sha256 | SHA256 hash. | keyword |
| threat.indicator.file.hash.sha512 | SHA512 hash. | keyword |
| threat.indicator.file.hash.ssdeep | SSDEEP hash. | keyword |
| threat.indicator.file.inode | Inode representing the file in the filesystem. | keyword |
| threat.indicator.file.mime_type | MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used. | keyword |
| threat.indicator.file.mode | Mode of the file in octal representation. | keyword |
| threat.indicator.file.mtime | Last time the file content was modified. | date |
| threat.indicator.file.name | Name of the file including the extension, without the directory. | keyword |
| threat.indicator.file.owner | File owner's username. | keyword |
| threat.indicator.file.path | Full path to the file, including the file name. It should include the drive letter, when appropriate. | keyword |
| threat.indicator.file.pe.architecture | CPU architecture target for the file. | keyword |
| threat.indicator.file.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| threat.indicator.file.pe.description | Internal description of the file, provided at compile-time. | keyword |
| threat.indicator.file.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| threat.indicator.file.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| threat.indicator.file.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| threat.indicator.file.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| threat.indicator.file.size | File size in bytes. Only relevant when `file.type` is "file". | long |
| threat.indicator.file.target_path | Target path for symlinks. | keyword |
| threat.indicator.file.type | File type (file, dir, or symlink). | keyword |
| threat.indicator.file.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| threat.indicator.first_seen | The date and time when intelligence source first reported sighting this indicator. | date |
| threat.indicator.geo.city_name | City name. | keyword |
| threat.indicator.geo.continent_code | Two-letter code representing continent's name. | keyword |
| threat.indicator.geo.continent_name | Name of the continent. | keyword |
| threat.indicator.geo.country_iso_code | Country ISO code. | keyword |
| threat.indicator.geo.country_name | Country name. | keyword |
| threat.indicator.geo.location | Longitude and latitude. | geo_point |
| threat.indicator.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| threat.indicator.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| threat.indicator.geo.region_iso_code | Region ISO code. | keyword |
| threat.indicator.geo.region_name | Region name. | keyword |
| threat.indicator.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| threat.indicator.ip | Identifies a threat indicator as an IP address (irrespective of direction). | ip |
| threat.indicator.last_seen | The date and time when intelligence source last reported sighting this indicator. | date |
| threat.indicator.marking.tlp | Traffic Light Protocol sharing markings. | keyword |
| threat.indicator.modified_at | The date and time when intelligence source last modified information for this indicator. | date |
| threat.indicator.port | Identifies a threat indicator as a port number (irrespective of direction). | long |
| threat.indicator.provider | The name of the indicator's provider. | keyword |
| threat.indicator.reference | Reference URL linking to additional information about this indicator. | keyword |
| threat.indicator.registry.data.bytes | Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values. | keyword |
| threat.indicator.registry.data.strings | Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`). | wildcard |
| threat.indicator.registry.data.type | Standard registry type for encoding contents | keyword |
| threat.indicator.registry.hive | Abbreviated name for the hive. | keyword |
| threat.indicator.registry.key | Hive-relative path of keys. | keyword |
| threat.indicator.registry.path | Full path, including hive, key and value | keyword |
| threat.indicator.registry.value | Name of the value written. | keyword |
| threat.indicator.scanner_stats | Count of AV/EDR vendors that successfully detected malicious file or URL. | long |
| threat.indicator.sightings | Number of times this indicator was observed conducting threat activity. | long |
| threat.indicator.type | Type of indicator as represented by Cyber Observable in STIX 2.0. | keyword |
| threat.indicator.url.domain | Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field. | keyword |
| threat.indicator.url.extension | The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword |
| threat.indicator.url.fragment | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment. | keyword |
| threat.indicator.url.full | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source. | wildcard |
| threat.indicator.url.original | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not. | wildcard |
| threat.indicator.url.password | Password of the request. | keyword |
| threat.indicator.url.path | Path of the request, such as "/search". | wildcard |
| threat.indicator.url.port | Port of the request, such as 443. | long |
| threat.indicator.url.query | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases. | keyword |
| threat.indicator.url.registered_domain | The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk". | keyword |
| threat.indicator.url.scheme | Scheme of the request, such as "https". Note: The `:` is not part of the scheme. | keyword |
| threat.indicator.url.subdomain | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period. | keyword |
| threat.indicator.url.top_level_domain | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk". | keyword |
| threat.indicator.url.username | Username of the request. | keyword |
| threat.indicator.x509.alternative_names | List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses. | keyword |
| threat.indicator.x509.issuer.common_name | List of common name (CN) of issuing certificate authority. | keyword |
| threat.indicator.x509.issuer.country | List of country \(C) codes | keyword |
| threat.indicator.x509.issuer.distinguished_name | Distinguished name (DN) of issuing certificate authority. | keyword |
| threat.indicator.x509.issuer.locality | List of locality names (L) | keyword |
| threat.indicator.x509.issuer.organization | List of organizations (O) of issuing certificate authority. | keyword |
| threat.indicator.x509.issuer.organizational_unit | List of organizational units (OU) of issuing certificate authority. | keyword |
| threat.indicator.x509.issuer.state_or_province | List of state or province names (ST, S, or P) | keyword |
| threat.indicator.x509.not_after | Time at which the certificate is no longer considered valid. | date |
| threat.indicator.x509.not_before | Time at which the certificate is first considered valid. | date |
| threat.indicator.x509.public_key_algorithm | Algorithm used to generate the public key. | keyword |
| threat.indicator.x509.public_key_curve | The curve used by the elliptic curve public key algorithm. This is algorithm specific. | keyword |
| threat.indicator.x509.public_key_exponent | Exponent used to derive the public key. This is algorithm specific. | long |
| threat.indicator.x509.public_key_size | The size of the public key space in bits. | long |
| threat.indicator.x509.serial_number | Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters. | keyword |
| threat.indicator.x509.signature_algorithm | Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353. | keyword |
| threat.indicator.x509.subject.common_name | List of common names (CN) of subject. | keyword |
| threat.indicator.x509.subject.country | List of country \(C) code | keyword |
| threat.indicator.x509.subject.distinguished_name | Distinguished name (DN) of the certificate subject entity. | keyword |
| threat.indicator.x509.subject.locality | List of locality names (L) | keyword |
| threat.indicator.x509.subject.organization | List of organizations (O) of subject. | keyword |
| threat.indicator.x509.subject.organizational_unit | List of organizational units (OU) of subject. | keyword |
| threat.indicator.x509.subject.state_or_province | List of state or province names (ST, S, or P) | keyword |
| threat.indicator.x509.version_number | Version of x509 format. | keyword |
| threat.software.id | The id of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software id. | keyword |
| threat.software.name | The name of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software name. | keyword |
| threat.software.platforms | The platforms of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use MITRE ATT&CK® software platform values. | keyword |
| threat.software.reference | The reference URL of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software reference URL. | keyword |
| threat.software.type | The type of software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. While not required, you can use a MITRE ATT&CK® software type. | keyword |
| threat.tactic.id | The id of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. https://attack.mitre.org/tactics/TA0002/ ) | keyword |
| threat.tactic.name | Name of the type of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. https://attack.mitre.org/tactics/TA0002/) | keyword |
| threat.tactic.reference | The reference url of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. https://attack.mitre.org/tactics/TA0002/ ) | keyword |
| threat.technique.id | The id of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. https://attack.mitre.org/techniques/T1059/) | keyword |
| threat.technique.name | The name of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. https://attack.mitre.org/techniques/T1059/) | keyword |
| threat.technique.reference | The reference url of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. https://attack.mitre.org/techniques/T1059/) | keyword |
| threat.technique.subtechnique.id | The full id of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. https://attack.mitre.org/techniques/T1059/001/) | keyword |
| threat.technique.subtechnique.name | The name of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. https://attack.mitre.org/techniques/T1059/001/) | keyword |
| threat.technique.subtechnique.reference | The reference url of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. https://attack.mitre.org/techniques/T1059/001/) | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |


### file

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Effective_process.entity_id | Unique identifier for the effective process. | keyword |
| Effective_process.executable | Executable name for the effective process. | keyword |
| Effective_process.name | Process name for the effective process. | keyword |
| Effective_process.pid | Process ID. | long |
| Persistence.args | Arguments used to execute the persistence item | keyword |
| Persistence.executable | The persistence item's executable | keyword |
| Persistence.keepalive | Keep alive option boolean | boolean |
| Persistence.name | The persistence item's name | keyword |
| Persistence.path | The file's path | keyword |
| Persistence.runatload | Run at load option boolean | boolean |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.Ext | Object for all custom defined fields to live in. | object |
| event.Ext.correlation | Information about event this should be correlated with. | object |
| event.Ext.correlation.id | ID of event that this event is correlated to, e.g. quarantine event associated with an unquarantine event | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| file.Ext | Object for all custom defined fields to live in. | object |
| file.Ext.device.bus_type | Bus type of the device, such as Nvme, Usb, FileBackedVirtual,... etc. | keyword |
| file.Ext.device.dos_name | DOS name of the device. DOS device name is in the format of driver letters such as C:, D:,... | keyword |
| file.Ext.device.file_system_type | Volume device file system type. Following are examples of the most frequently seen volume device file system types: NTFS UDF | keyword |
| file.Ext.device.nt_name | NT name of the device. NT device name is in the format such as: \Device\HarddiskVolume2 | keyword |
| file.Ext.device.product_id | ProductID of the device. It is provided by the vendor of the device if any. | keyword |
| file.Ext.device.serial_number | Serial Number of the device. It is provided by the vendor of the device if any. | keyword |
| file.Ext.device.vendor_id | VendorID of the device. It is provided by the vendor of the device. | keyword |
| file.Ext.device.volume_device_type | Volume device type. Following are examples of the most frequently seen volume device types: Disk File System CD-ROM File System | keyword |
| file.Ext.entropy | Entropy calculation of file's header and footer used to check file integrity. | double |
| file.Ext.header_bytes | First 16 bytes of file used to check file integrity. | keyword |
| file.Ext.header_data | First 16 bytes of file used to check file integrity. | text |
| file.Ext.malware_signature | Nested version of malware_signature fieldset. | nested |
| file.Ext.malware_signature.all_names | The concatenated names of all yara signatures | text |
| file.Ext.malware_signature.identifier | Malware artifact identifier. | text |
| file.Ext.malware_signature.primary | Primary malware signature match. | nested |
| file.Ext.malware_signature.primary.matches | An array of bytes representing yara signature matches | nested |
| file.Ext.malware_signature.primary.signature | Primary malware signature match. | nested |
| file.Ext.malware_signature.primary.signature.hash | Primary malware signature hash. | nested |
| file.Ext.malware_signature.primary.signature.hash.sha256 | Primary malware signature sha256. | keyword |
| file.Ext.malware_signature.primary.signature.id | Primary malware signature id. | keyword |
| file.Ext.malware_signature.primary.signature.name | Primary malware signature name. | keyword |
| file.Ext.malware_signature.secondary | An array of malware signature matches | nested |
| file.Ext.malware_signature.version | Primary malware signature version. | keyword |
| file.Ext.monotonic_id | File event monotonic ID. | unsigned_long |
| file.Ext.original | Original file information during a modification event. | object |
| file.Ext.original.extension | Original file extension prior to a modification event | keyword |
| file.Ext.original.gid | Primary group ID (GID) of the file. | keyword |
| file.Ext.original.group | Primary group name of the file. | keyword |
| file.Ext.original.mode | Original file mode prior to a modification event | keyword |
| file.Ext.original.name | Original file name prior to a modification event | keyword |
| file.Ext.original.owner | File owner's username. | keyword |
| file.Ext.original.path | Original file path prior to a modification event | keyword |
| file.Ext.original.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| file.Ext.windows | Platform-specific Windows fields | object |
| file.Ext.windows.zone_identifier | Windows zone identifier for a file | keyword |
| file.accessed | Last time the file was accessed. Note that not all filesystems keep track of access time. | date |
| file.attributes | Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write. | keyword |
| file.created | File creation time. Note that not all filesystems store the creation time. | date |
| file.ctime | Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file. | date |
| file.device | Device that is the source of the file. | keyword |
| file.directory | Directory where the file is located. It should include the drive letter, when appropriate. | keyword |
| file.drive_letter | Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon. | keyword |
| file.extension | File extension, excluding the leading dot. Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz"). | keyword |
| file.gid | Primary group ID (GID) of the file. | keyword |
| file.group | Primary group name of the file. | keyword |
| file.hash.md5 | MD5 hash. | keyword |
| file.hash.sha1 | SHA1 hash. | keyword |
| file.hash.sha256 | SHA256 hash. | keyword |
| file.hash.sha512 | SHA512 hash. | keyword |
| file.inode | Inode representing the file in the filesystem. | keyword |
| file.mime_type | MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used. | keyword |
| file.mode | Mode of the file in octal representation. | keyword |
| file.mtime | Last time the file content was modified. | date |
| file.name | Name of the file including the extension, without the directory. | keyword |
| file.origin_referrer_url | The url of the webpage that linked to the file. | keyword |
| file.origin_url | The url where the file is hosted. | keyword |
| file.owner | File owner's username. | keyword |
| file.path | Full path to the file, including the file name. It should include the drive letter, when appropriate. | keyword |
| file.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| file.pe.description | Internal description of the file, provided at compile-time. | keyword |
| file.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| file.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| file.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| file.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| file.size | File size in bytes. Only relevant when `file.type` is "file". | long |
| file.target_path | Target path for symlinks. | keyword |
| file.type | File type (file, dir, or symlink). | keyword |
| file.uid | The user ID (UID) or security identifier (SID) of the file owner. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.pid | Process id. | long |
| process.pid | Process id. | long |
| process.ppid | Parent process' pid. | long |
| process.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.thread.Ext | Object for all custom defined fields to live in. | object |
| process.thread.Ext.call_stack | Fields describing a stack frame.  call_stack is expected to be an array where each array element represents a stack frame. | object |
| process.thread.Ext.call_stack.allocation_private_bytes | The number of bytes in this memory allocation/image that are both +X and non-shareable. Non-zero values can indicate code hooking, patching, or hollowing. | unsigned_long |
| process.thread.Ext.call_stack.callsite_leading_bytes | Hex opcode bytes preceding the callsite | keyword |
| process.thread.Ext.call_stack.callsite_trailing_bytes | Hex opcode bytes after the callsite (where control will return to) | keyword |
| process.thread.Ext.call_stack.protection | Protection of the page containing this instruction.  This is `R-X' by default if omitted. | keyword |
| process.thread.Ext.call_stack.symbol_info | The nearest symbol for `instruction_pointer`. | keyword |
| process.thread.Ext.call_stack_summary | Concatentation of the non-repeated modules in the call stack. | keyword |
| process.thread.Ext.hardware_breakpoint_set | Whether a hardware breakpoint was set for the thread. This field is omitted if false. | boolean |
| process.thread.id | Thread ID. | long |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |


### library

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Effective_process.entity_id | Unique identifier for the effective process. | keyword |
| Effective_process.executable | Executable name for the effective process. | keyword |
| Effective_process.name | Process name for the effective process. | keyword |
| Effective_process.pid | Process ID. | long |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| dll.Ext | Object for all custom defined fields to live in. | object |
| dll.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| dll.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| dll.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| dll.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| dll.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| dll.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| dll.Ext.defense_evasions | List of defense evasions found for this DLL. These defense evasions can make it harder to inspect a process and/or cause abnormal OS behavior. Examples tools that can cause defense evasions include KnownDlls hijacking and PPLDump. | keyword |
| dll.Ext.device.bus_type | Bus type of the device, such as Nvme, Usb, FileBackedVirtual,... etc. | keyword |
| dll.Ext.device.dos_name | DOS name of the device. DOS device name is in the format of driver letters such as C:, D:,... | keyword |
| dll.Ext.device.file_system_type | Volume device file system type. Following are examples of the most frequently seen volume device file system types: NTFS UDF | keyword |
| dll.Ext.device.nt_name | NT name of the device. NT device name is in the format such as: \Device\HarddiskVolume2 | keyword |
| dll.Ext.device.product_id | ProductID of the device. It is provided by the vendor of the device if any. | keyword |
| dll.Ext.device.serial_number | Serial Number of the device. It is provided by the vendor of the device if any. | keyword |
| dll.Ext.device.vendor_id | VendorID of the device. It is provided by the vendor of the device. | keyword |
| dll.Ext.device.volume_device_type | Volume device type. Following are examples of the most frequently seen volume device types: Disk File System CD-ROM File System | keyword |
| dll.Ext.load_index | A DLL can be loaded into a process multiple times. This field indicates the Nth time that this DLL has been loaded. The first load index is 1. | unsigned_long |
| dll.Ext.relative_file_creation_time | Number of seconds since the DLL's file was created. This number may be negative if the file's timestamp is in the future. | double |
| dll.Ext.relative_file_name_modify_time | Number of seconds since the DLL's name was modified. This information can come from the NTFS MFT. This number may be negative if the file's timestamp is in the future. | double |
| dll.Ext.size | Size of DLL | unsigned_long |
| dll.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| dll.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| dll.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| dll.code_signature.subject_name | Subject name of the code signer | keyword |
| dll.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| dll.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| dll.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| dll.hash.md5 | MD5 hash. | keyword |
| dll.hash.sha1 | SHA1 hash. | keyword |
| dll.hash.sha256 | SHA256 hash. | keyword |
| dll.hash.sha512 | SHA512 hash. | keyword |
| dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| dll.path | Full file path of the library. | keyword |
| dll.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| dll.pe.description | Internal description of the file, provided at compile-time. | keyword |
| dll.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| dll.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| dll.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| dll.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| file.Ext | Object for all custom defined fields to live in. | object |
| file.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| file.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| file.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| file.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| file.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| file.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| file.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| file.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| file.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| file.code_signature.subject_name | Subject name of the code signer | keyword |
| file.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| file.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| file.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| file.hash.md5 | MD5 hash. | keyword |
| file.hash.sha1 | SHA1 hash. | keyword |
| file.hash.sha256 | SHA256 hash. | keyword |
| file.hash.sha512 | SHA512 hash. | keyword |
| file.name | Name of the file including the extension, without the directory. | keyword |
| file.path | Full path to the file, including the file name. It should include the drive letter, when appropriate. | keyword |
| file.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| file.pe.description | Internal description of the file, provided at compile-time. | keyword |
| file.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| file.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| file.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| file.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.pid | Process id. | long |
| process.thread.Ext | Object for all custom defined fields to live in. | object |
| process.thread.Ext.call_stack | Fields describing a stack frame.  call_stack is expected to be an array where each array element represents a stack frame. | object |
| process.thread.Ext.call_stack.allocation_private_bytes | The number of bytes in this memory allocation/image that are both +X and non-shareable. Non-zero values can indicate code hooking, patching, or hollowing. | unsigned_long |
| process.thread.Ext.call_stack.callsite_leading_bytes | Hex opcode bytes preceding the callsite | keyword |
| process.thread.Ext.call_stack.callsite_trailing_bytes | Hex opcode bytes after the callsite (where control will return to) | keyword |
| process.thread.Ext.call_stack.protection | Protection of the page containing this instruction.  This is `R-X' by default if omitted. | keyword |
| process.thread.Ext.call_stack.symbol_info | The nearest symbol for `instruction_pointer`. | keyword |
| process.thread.Ext.call_stack_summary | Concatentation of the non-repeated modules in the call stack. | keyword |
| process.thread.Ext.hardware_breakpoint_set | Whether a hardware breakpoint was set for the thread. This field is omitted if false. | boolean |
| process.thread.id | Thread ID. | long |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |


### network

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.address | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is. | keyword |
| destination.as.number | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet. | long |
| destination.as.organization.name | Organization name. | keyword |
| destination.bytes | Bytes sent from the destination to the source. | long |
| destination.domain | The domain name of the destination system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| destination.ip | IP address of the destination (IPv4 or IPv6). | ip |
| destination.packets | Packets sent from the destination to the source. | long |
| destination.port | Port of the destination. | long |
| destination.registered_domain | The highest registered destination domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk". | keyword |
| destination.top_level_domain | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk". | keyword |
| dns.Ext | Object for all custom defined fields to live in. | object |
| dns.Ext.options | DNS options field, uint64, representing as a keyword to avoid overflows in ES | keyword |
| dns.Ext.status | DNS status field, uint32 | long |
| dns.question.name | The name being queried. If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively. | keyword |
| dns.question.registered_domain | The highest registered domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk". | keyword |
| dns.question.subdomain | The subdomain is all of the labels under the registered_domain. If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period. | keyword |
| dns.question.top_level_domain | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk". | keyword |
| dns.question.type | The type of record being queried. | keyword |
| dns.resolved_ip | Array containing all IPs seen in `answers.data`. The `answers` array can be difficult to use, because of the variety of data formats it can contain. Extracting all IP addresses seen in there to `dns.resolved_ip` makes it possible to index them as IP addresses, and makes them easier to visualize and query for. | ip |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| http.request.body.bytes | Size in bytes of the request body. | long |
| http.request.body.content | The full HTTP request body. | wildcard |
| http.request.bytes | Total size in bytes of the request (body and headers). | long |
| http.response.Ext | Object for all custom defined fields to live in. | object |
| http.response.Ext.version | HTTP version | keyword |
| http.response.body.bytes | Size in bytes of the response body. | long |
| http.response.body.content | The full HTTP response body. | wildcard |
| http.response.bytes | Total size in bytes of the response (body and headers). | long |
| http.response.status_code | HTTP response status code. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| network.bytes | Total bytes transferred in both directions. If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum. | long |
| network.community_id | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at https://github.com/corelight/community-id-spec. | keyword |
| network.direction | Direction of the network traffic. When mapping events from a host-based monitoring context, populate this field from the host's point of view, using the values "ingress" or "egress". When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external". Note that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers. | keyword |
| network.iana_number | IANA Protocol Number (https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number. | keyword |
| network.packets | Total packets transferred in both directions. If `source.packets` and `destination.packets` are known, `network.packets` is their sum. | long |
| network.protocol | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying. | keyword |
| network.transport | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying. | keyword |
| network.type | In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc The field value must be normalized to lowercase for querying. | keyword |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.pid | Process id. | long |
| process.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.thread.id | Thread ID. | long |
| source.address | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is. | keyword |
| source.as.number | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet. | long |
| source.as.organization.name | Organization name. | keyword |
| source.bytes | Bytes sent from the source to the destination. | long |
| source.domain | The domain name of the source system. This value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment. | keyword |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| source.ip | IP address of the source (IPv4 or IPv6). | ip |
| source.packets | Packets sent from the source to the destination. | long |
| source.port | Port of the source. | long |
| source.registered_domain | The highest registered source domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk". | keyword |
| source.top_level_domain | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk". | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |


### process

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| agent.ephemeral_id | Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not. | keyword |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| cloud.account.id | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword |
| cloud.instance.name | Instance name of the host machine. | keyword |
| cloud.project.id | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id. | keyword |
| cloud.provider | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean. | keyword |
| cloud.region | Region in which this host, resource, or service is located. | keyword |
| container.id | Unique container id. | keyword |
| container.image.hash.all | An array of digests of the image the container was built on. Each digest consists of the hash algorithm and value in this format: `algorithm:value`. Algorithm names should align with the field names in the ECS hash field set. | keyword |
| container.image.name | Name of the image the container was built on. | keyword |
| container.image.tag | Container image tags. | keyword |
| container.name | Container name. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.boot.id | Linux boot uuid taken from /proc/sys/kernel/random/boot_id. Note the boot_id value from /proc may or may not be the same in containers as on the host. Some container runtimes will bind mount a new boot_id value onto the proc file in each container. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.pid_ns_ino | This is the inode number of the namespace in the namespace file system (nsfs). Unsigned int inum in include/linux/ns_common.h. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| orchestrator.cluster.id | Unique ID of the cluster. | keyword |
| orchestrator.cluster.name | Name of the cluster. | keyword |
| orchestrator.namespace | Namespace in which the action is taking place. | keyword |
| orchestrator.resource.ip | IP address assigned to the resource associated with the event being observed. In the case of a Kubernetes Pod, this array would contain only one element: the IP of the Pod (as opposed to the Node on which the Pod is running). | ip |
| orchestrator.resource.name | Name of the resource being acted upon. | keyword |
| orchestrator.resource.parent.type | Type or kind of the parent resource associated with the event being observed. In Kubernetes, this will be the name of a built-in workload resource (e.g., Deployment, StatefulSet, DaemonSet). | keyword |
| orchestrator.resource.type | Type of resource being acted upon. | keyword |
| package.name | Package name | keyword |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.architecture | Process architecture.  It can differ from host architecture. | keyword |
| process.Ext.authentication_id | Process authentication ID | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.Ext.created_suspended | A heuristic indicating if the CREATE_SUSPENDED flag was passed to the Win32 CreateProcess API. Not valid for direct syscalls. | boolean |
| process.Ext.defense_evasions | List of defense evasions found in this process. These defense evasions can make it harder to inspect a process and/or cause abnormal OS behavior. Examples tools that can cause defense evasions include Process Doppelganging and Process Herpaderping. | keyword |
| process.Ext.device.bus_type | Bus type of the device, such as Nvme, Usb, FileBackedVirtual,... etc. | keyword |
| process.Ext.device.dos_name | DOS name of the device. DOS device name is in the format of driver letters such as C:, D:,... | keyword |
| process.Ext.device.file_system_type | Volume device file system type. Following are examples of the most frequently seen volume device file system types: NTFS UDF | keyword |
| process.Ext.device.nt_name | NT name of the device. NT device name is in the format such as: \Device\HarddiskVolume2 | keyword |
| process.Ext.device.product_id | ProductID of the device. It is provided by the vendor of the device if any. | keyword |
| process.Ext.device.serial_number | Serial Number of the device. It is provided by the vendor of the device if any. | keyword |
| process.Ext.device.vendor_id | VendorID of the device. It is provided by the vendor of the device. | keyword |
| process.Ext.device.volume_device_type | Volume device type. Following are examples of the most frequently seen volume device types: Disk File System CD-ROM File System | keyword |
| process.Ext.dll.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.dll.Ext.mapped_address | The base address where this module is loaded. | unsigned_long |
| process.Ext.dll.Ext.mapped_size | The size of this module's memory mapping, in bytes. | unsigned_long |
| process.Ext.dll.name | Name of the library. This generally maps to the name of the file on disk. | keyword |
| process.Ext.dll.path | Full file path of the library. | keyword |
| process.Ext.effective_parent.entity_id | Unique identifier for the effective process. | keyword |
| process.Ext.effective_parent.executable | Executable name for the effective process. | keyword |
| process.Ext.effective_parent.name | Process name for the effective process. | keyword |
| process.Ext.effective_parent.pid | Process ID. | long |
| process.Ext.mitigation_policies | Process mitigation policies include SignaturePolicy, DynamicCodePolicy, UserShadowStackPolicy, ControlFlowGuardPolicy, etc. Examples include Microsoft only, CF Guard, User Shadow Stack enabled | keyword |
| process.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| process.Ext.relative_file_creation_time | Number of seconds since the process's file was created. This number may be negative if the file's timestamp is in the future. | double |
| process.Ext.relative_file_name_modify_time | Number of seconds since the process's name was modified. This information can come from the NTFS MFT. This number may be negative if the file's timestamp is in the future. | double |
| process.Ext.session | Session information for the current process | keyword |
| process.Ext.session_info.authentication_package | Name of authentication package used to log on, such as NTLM, Kerberos, or CloudAP | keyword |
| process.Ext.session_info.client_address | Client's IPv4 or IPv6 address as a string, if available. | keyword |
| process.Ext.session_info.id | Session ID | unsigned_long |
| process.Ext.session_info.logon_type | Session logon type.  Examples include Interactive, Network, and Service. | keyword |
| process.Ext.session_info.relative_logon_time | Process creation time, relative to logon time, in seconds. | double |
| process.Ext.session_info.relative_password_age | Process creation time, relative to the last time the password was changed, in seconds. | double |
| process.Ext.session_info.user_flags | List of user flags associated with this logon session. Examples include LOGON_NTLMV2_ENABLED and LOGON_WINLOGON. | keyword |
| process.Ext.token.elevation | Whether the token is elevated or not | boolean |
| process.Ext.token.elevation_level | What level of elevation the token has | keyword |
| process.Ext.token.elevation_type | What level of elevation the token has | keyword |
| process.Ext.token.integrity_level_name | Human readable integrity level. | keyword |
| process.Ext.token.security_attributes | Array of security attributes of the token, retrieved via the  TokenSecurityAttributes class. | keyword |
| process.Ext.trusted | Whether or not the process is a trusted application | boolean |
| process.Ext.trusted_descendant | Whether or not the process is a descendent of a trusted application | boolean |
| process.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.end | The time the process ended. | date |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.entry_leader.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.entry_leader.attested_groups.name | Name of the group. | keyword |
| process.entry_leader.attested_user.id | Unique identifier of the user. | keyword |
| process.entry_leader.attested_user.name | Short name or login of the user. | keyword |
| process.entry_leader.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.entry_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.entry_meta.source.ip | IP address of the source (IPv4 or IPv6). | ip |
| process.entry_leader.entry_meta.type | The entry type for the entry session leader. Values include: init(e.g systemd), sshd, ssm, kubelet, teleport, terminal, console Note: This field is only set on process.session_leader. | keyword |
| process.entry_leader.executable | Absolute path to the process executable. | keyword |
| process.entry_leader.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.group.name | Name of the group. | keyword |
| process.entry_leader.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.entry_leader.name | Process name. Sometimes called program name or similar. | keyword |
| process.entry_leader.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.parent.pid | Process id. | long |
| process.entry_leader.parent.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.entry_leader.parent.session_leader.pid | Process id. | long |
| process.entry_leader.parent.session_leader.start | The time the process started. | date |
| process.entry_leader.parent.start | The time the process started. | date |
| process.entry_leader.pid | Process id. | long |
| process.entry_leader.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.real_group.name | Name of the group. | keyword |
| process.entry_leader.real_user.id | Unique identifier of the user. | keyword |
| process.entry_leader.real_user.name | Short name or login of the user. | keyword |
| process.entry_leader.same_as_process | This boolean is used to identify if a leader process is the same as the top level process. For example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`. This field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader) Instead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true` Note: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`. | boolean |
| process.entry_leader.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.saved_group.name | Name of the group. | keyword |
| process.entry_leader.saved_user.id | Unique identifier of the user. | keyword |
| process.entry_leader.saved_user.name | Short name or login of the user. | keyword |
| process.entry_leader.start | The time the process started. | date |
| process.entry_leader.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.entry_leader.supplemental_groups.name | Name of the group. | keyword |
| process.entry_leader.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.entry_leader.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.entry_leader.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.entry_leader.user.id | Unique identifier of the user. | keyword |
| process.entry_leader.user.name | Short name or login of the user. | keyword |
| process.entry_leader.working_directory | The working directory of the process. | keyword |
| process.env_vars | Array of environment variable bindings. Captured from a snapshot of the environment at the time of execution. May be filtered to protect sensitive information. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.exit_code | The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start). | long |
| process.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group.name | Name of the group. | keyword |
| process.group_leader.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.group_leader.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.group_leader.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.group_leader.executable | Absolute path to the process executable. | keyword |
| process.group_leader.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.group.name | Name of the group. | keyword |
| process.group_leader.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.group_leader.name | Process name. Sometimes called program name or similar. | keyword |
| process.group_leader.pid | Process id. | long |
| process.group_leader.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.real_group.name | Name of the group. | keyword |
| process.group_leader.real_user.id | Unique identifier of the user. | keyword |
| process.group_leader.real_user.name | Short name or login of the user. | keyword |
| process.group_leader.same_as_process | This boolean is used to identify if a leader process is the same as the top level process. For example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`. This field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader) Instead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true` Note: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`. | boolean |
| process.group_leader.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.saved_group.name | Name of the group. | keyword |
| process.group_leader.saved_user.id | Unique identifier of the user. | keyword |
| process.group_leader.saved_user.name | Short name or login of the user. | keyword |
| process.group_leader.start | The time the process started. | date |
| process.group_leader.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.group_leader.supplemental_groups.name | Name of the group. | keyword |
| process.group_leader.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.group_leader.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.group_leader.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.group_leader.user.id | Unique identifier of the user. | keyword |
| process.group_leader.user.name | Short name or login of the user. | keyword |
| process.group_leader.working_directory | The working directory of the process. | keyword |
| process.hash.md5 | MD5 hash. | keyword |
| process.hash.sha1 | SHA1 hash. | keyword |
| process.hash.sha256 | SHA256 hash. | keyword |
| process.hash.sha512 | SHA512 hash. | keyword |
| process.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.io | A chunk of input or output (IO) from a single process. This field only appears on the top level process object, which is the process that wrote the output or read the input. | object |
| process.io.max_bytes_per_process_exceeded | If true, the process producing the output has exceeded the max_kilobytes_per_process configuration setting. | boolean |
| process.io.text | A chunk of output or input sanitized to UTF-8. Best efforts are made to ensure complete lines are captured in these events. Assumptions should NOT be made that multiple lines will appear in the same event. TTY output may contain terminal control codes such as for cursor movement, so some string queries may not match due to terminal codes inserted between characters of a word. | wildcard |
| process.io.total_bytes_captured | The total number of bytes captured in this event. | long |
| process.io.total_bytes_skipped | The total number of bytes that were not captured due to implementation restrictions such as buffer size limits. Implementors should strive to ensure this value is always zero | long |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.parent.Ext | Object for all custom defined fields to live in. | object |
| process.parent.Ext.architecture | Process architecture.  It can differ from host architecture. | keyword |
| process.parent.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.parent.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.parent.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.parent.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.parent.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.parent.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.parent.Ext.protection | Indicates the protection level of this process.  Uses the same syntax as Process Explorer. Examples include PsProtectedSignerWinTcb, PsProtectedSignerWinTcb-Light, and PsProtectedSignerWindows-Light. | keyword |
| process.parent.Ext.real | The field set containing process info in case of any pid spoofing. This is mainly useful for process.parent. | object |
| process.parent.Ext.real.pid | For process.parent this will be the ppid of the process that actually spawned the current process. | long |
| process.parent.Ext.user | User associated with the running process. | keyword |
| process.parent.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.parent.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.parent.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.parent.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.parent.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.parent.code_signature.subject_name | Subject name of the code signer | keyword |
| process.parent.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.parent.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.parent.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.parent.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.executable | Absolute path to the process executable. | keyword |
| process.parent.exit_code | The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start). | long |
| process.parent.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.group.name | Name of the group. | keyword |
| process.parent.group_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.parent.group_leader.pid | Process id. | long |
| process.parent.group_leader.start | The time the process started. | date |
| process.parent.hash.md5 | MD5 hash. | keyword |
| process.parent.hash.sha1 | SHA1 hash. | keyword |
| process.parent.hash.sha256 | SHA256 hash. | keyword |
| process.parent.hash.sha512 | SHA512 hash. | keyword |
| process.parent.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.parent.name | Process name. Sometimes called program name or similar. | keyword |
| process.parent.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.parent.pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.parent.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.parent.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.parent.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.parent.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.parent.pgid | Deprecated for removal in next major version release. This field is superseded by `process.group_leader.pid`. Identifier of the group of processes the process belongs to. | long |
| process.parent.pid | Process id. | long |
| process.parent.ppid | Parent process' pid. | long |
| process.parent.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.real_group.name | Name of the group. | keyword |
| process.parent.real_user.id | Unique identifier of the user. | keyword |
| process.parent.real_user.name | Short name or login of the user. | keyword |
| process.parent.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.saved_group.name | Name of the group. | keyword |
| process.parent.saved_user.id | Unique identifier of the user. | keyword |
| process.parent.saved_user.name | Short name or login of the user. | keyword |
| process.parent.start | The time the process started. | date |
| process.parent.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.parent.supplemental_groups.name | Name of the group. | keyword |
| process.parent.thread.Ext | Object for all custom defined fields to live in. | object |
| process.parent.thread.Ext.call_stack | Fields describing a stack frame.  call_stack is expected to be an array where each array element represents a stack frame. | object |
| process.parent.thread.Ext.call_stack.allocation_private_bytes | The number of bytes in this memory allocation/image that are both +X and non-shareable. Non-zero values can indicate code hooking, patching, or hollowing. | unsigned_long |
| process.parent.thread.Ext.call_stack.callsite_leading_bytes | Hex opcode bytes preceding the callsite | keyword |
| process.parent.thread.Ext.call_stack.callsite_trailing_bytes | Hex opcode bytes after the callsite (where control will return to) | keyword |
| process.parent.thread.Ext.call_stack.protection | Protection of the page containing this instruction.  This is `R-X' by default if omitted. | keyword |
| process.parent.thread.Ext.call_stack.symbol_info | The nearest symbol for `instruction_pointer`. | keyword |
| process.parent.thread.Ext.call_stack_contains_unbacked | Indicates whether the creating thread's stack contains frames pointing outside any known executable image. | boolean |
| process.parent.thread.Ext.call_stack_summary | Concatentation of the non-repeated modules in the call stack. | keyword |
| process.parent.thread.Ext.hardware_breakpoint_set | Whether a hardware breakpoint was set for the thread. This field is omitted if false. | boolean |
| process.parent.thread.id | Thread ID. | long |
| process.parent.thread.name | Thread name. | keyword |
| process.parent.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| process.parent.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.parent.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.parent.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.parent.uptime | Seconds the process has been up. | long |
| process.parent.user.id | Unique identifier of the user. | keyword |
| process.parent.user.name | Short name or login of the user. | keyword |
| process.parent.working_directory | The working directory of the process. | keyword |
| process.pe.company | Internal company name of the file, provided at compile-time. | keyword |
| process.pe.description | Internal description of the file, provided at compile-time. | keyword |
| process.pe.file_version | Internal version of the file, provided at compile-time. | keyword |
| process.pe.imphash | A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values. Learn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html. | keyword |
| process.pe.original_file_name | Internal name of the file, provided at compile-time. | keyword |
| process.pe.product | Internal product name of the file, provided at compile-time. | keyword |
| process.pgid | Deprecated for removal in next major version release. This field is superseded by `process.group_leader.pid`. Identifier of the group of processes the process belongs to. | long |
| process.pid | Process id. | long |
| process.ppid | Parent process' pid. | long |
| process.previous.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.previous.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.previous.executable | Absolute path to the process executable. | keyword |
| process.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.real_group.name | Name of the group. | keyword |
| process.real_user.id | Unique identifier of the user. | keyword |
| process.real_user.name | Short name or login of the user. | keyword |
| process.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.saved_group.name | Name of the group. | keyword |
| process.saved_user.id | Unique identifier of the user. | keyword |
| process.saved_user.name | Short name or login of the user. | keyword |
| process.session_leader.args | Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information. | keyword |
| process.session_leader.args_count | Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity. | long |
| process.session_leader.command_line | Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information. | wildcard |
| process.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.session_leader.executable | Absolute path to the process executable. | keyword |
| process.session_leader.group.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.group.name | Name of the group. | keyword |
| process.session_leader.interactive | Whether the process is connected to an interactive shell. Process interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive. Note: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY. | boolean |
| process.session_leader.name | Process name. Sometimes called program name or similar. | keyword |
| process.session_leader.parent.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.session_leader.parent.pid | Process id. | long |
| process.session_leader.parent.session_leader.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.session_leader.parent.session_leader.pid | Process id. | long |
| process.session_leader.parent.session_leader.start | The time the process started. | date |
| process.session_leader.parent.start | The time the process started. | date |
| process.session_leader.pid | Process id. | long |
| process.session_leader.real_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.real_group.name | Name of the group. | keyword |
| process.session_leader.real_user.id | Unique identifier of the user. | keyword |
| process.session_leader.real_user.name | Short name or login of the user. | keyword |
| process.session_leader.same_as_process | This boolean is used to identify if a leader process is the same as the top level process. For example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`. This field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader) Instead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true` Note: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`. | boolean |
| process.session_leader.saved_group.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.saved_group.name | Name of the group. | keyword |
| process.session_leader.saved_user.id | Unique identifier of the user. | keyword |
| process.session_leader.saved_user.name | Short name or login of the user. | keyword |
| process.session_leader.start | The time the process started. | date |
| process.session_leader.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.session_leader.supplemental_groups.name | Name of the group. | keyword |
| process.session_leader.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.session_leader.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.session_leader.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.session_leader.user.id | Unique identifier of the user. | keyword |
| process.session_leader.user.name | Short name or login of the user. | keyword |
| process.session_leader.working_directory | The working directory of the process. | keyword |
| process.start | The time the process started. | date |
| process.supplemental_groups.id | Unique identifier for the group on the system/platform. | keyword |
| process.supplemental_groups.name | Name of the group. | keyword |
| process.thread.capabilities.effective | This is the set of capabilities used by the kernel to perform permission checks for the thread. | keyword |
| process.thread.capabilities.permitted | This is a limiting superset for the effective capabilities that the thread may assume. | keyword |
| process.thread.id | Thread ID. | long |
| process.thread.name | Thread name. | keyword |
| process.title | Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened. | keyword |
| process.tty | Information about the controlling TTY device. If set, the process belongs to an interactive session. | object |
| process.tty.char_device.major | The major number identifies the driver associated with the device. The character device's major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation. | long |
| process.tty.char_device.minor | The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them. | long |
| process.tty.columns | The number of character columns per line. e.g terminal width Terminal sizes can change, so this value reflects the maximum value for a given IO event. i.e. where event.action = 'text_output' | long |
| process.tty.rows | The number of character rows in the terminal. e.g terminal height Terminal sizes can change, so this value reflects the maximum value for a given IO event. i.e. where event.action = 'text_output' | long |
| process.uptime | Seconds the process has been up. | long |
| process.user.id | Unique identifier of the user. | keyword |
| process.user.name | Short name or login of the user. | keyword |
| process.working_directory | The working directory of the process. | keyword |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |


### registry

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Effective_process.entity_id | Unique identifier for the effective process. | keyword |
| Effective_process.executable | Executable name for the effective process. | keyword |
| Effective_process.name | Process name for the effective process. | keyword |
| Effective_process.pid | Process ID. | long |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.pid | Process id. | long |
| process.thread.Ext | Object for all custom defined fields to live in. | object |
| process.thread.Ext.call_stack | Fields describing a stack frame.  call_stack is expected to be an array where each array element represents a stack frame. | object |
| process.thread.Ext.call_stack.allocation_private_bytes | The number of bytes in this memory allocation/image that are both +X and non-shareable. Non-zero values can indicate code hooking, patching, or hollowing. | unsigned_long |
| process.thread.Ext.call_stack.callsite_leading_bytes | Hex opcode bytes preceding the callsite | keyword |
| process.thread.Ext.call_stack.callsite_trailing_bytes | Hex opcode bytes after the callsite (where control will return to) | keyword |
| process.thread.Ext.call_stack.protection | Protection of the page containing this instruction.  This is `R-X' by default if omitted. | keyword |
| process.thread.Ext.call_stack.symbol_info | The nearest symbol for `instruction_pointer`. | keyword |
| process.thread.Ext.call_stack_summary | Concatentation of the non-repeated modules in the call stack. | keyword |
| process.thread.Ext.hardware_breakpoint_set | Whether a hardware breakpoint was set for the thread. This field is omitted if false. | boolean |
| process.thread.id | Thread ID. | long |
| registry.data.bytes | Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values. | keyword |
| registry.data.strings | Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`). | wildcard |
| registry.data.type | Standard registry type for encoding contents | keyword |
| registry.hive | Abbreviated name for the hive. | keyword |
| registry.key | Hive-relative path of keys. | keyword |
| registry.path | Full path, including hive, key and value | keyword |
| registry.value | Name of the value written. | keyword |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |


### security

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Target.process.Ext | Object for all custom defined fields to live in. | object |
| Target.process.Ext.authentication_id | Process authentication ID | keyword |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| destination.geo.city_name | City name. | keyword |
| destination.geo.continent_code | Two-letter code representing continent's name. | keyword |
| destination.geo.continent_name | Name of the continent. | keyword |
| destination.geo.country_iso_code | Country ISO code. | keyword |
| destination.geo.country_name | Country name. | keyword |
| destination.geo.location | Longitude and latitude. | geo_point |
| destination.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| destination.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| destination.geo.region_iso_code | Region ISO code. | keyword |
| destination.geo.region_name | Region name. | keyword |
| destination.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| group.Ext | Object for all custom defined fields to live in. | object |
| group.Ext.real | Group info prior to any setgid operations. | object |
| group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| group.Ext.real.name | Name of the group. | keyword |
| group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| group.id | Unique identifier for the group on the system/platform. | keyword |
| group.name | Name of the group. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |
| process.Ext | Object for all custom defined fields to live in. | object |
| process.Ext.ancestry | An array of entity_ids indicating the ancestors for this event | keyword |
| process.Ext.authentication_id | Process authentication ID | keyword |
| process.Ext.code_signature | Nested version of ECS code_signature fieldset. | nested |
| process.Ext.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.Ext.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.Ext.code_signature.subject_name | Subject name of the code signer | keyword |
| process.Ext.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.Ext.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.code_signature.exists | Boolean to capture if a signature is present. | boolean |
| process.code_signature.signing_id | The identifier used to sign the process. This is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.status | Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked. | keyword |
| process.code_signature.subject_name | Subject name of the code signer | keyword |
| process.code_signature.team_id | The team identifier used to sign the process. This is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only. | keyword |
| process.code_signature.trusted | Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status. | boolean |
| process.code_signature.valid | Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked. | boolean |
| process.entity_id | Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts. | keyword |
| process.executable | Absolute path to the process executable. | keyword |
| process.name | Process name. Sometimes called program name or similar. | keyword |
| process.pid | Process id. | long |
| process.thread.id | Thread ID. | long |
| source.geo.city_name | City name. | keyword |
| source.geo.continent_code | Two-letter code representing continent's name. | keyword |
| source.geo.continent_name | Name of the continent. | keyword |
| source.geo.country_iso_code | Country ISO code. | keyword |
| source.geo.country_name | Country name. | keyword |
| source.geo.location | Longitude and latitude. | geo_point |
| source.geo.name | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation. | keyword |
| source.geo.postal_code | Postal code associated with the location. Values appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country. | keyword |
| source.geo.region_iso_code | Region ISO code. | keyword |
| source.geo.region_name | Region name. | keyword |
| source.geo.timezone | The time zone of the location, such as IANA time zone name. | keyword |
| user.Ext | Object for all custom defined fields to live in. | object |
| user.Ext.real | User info prior to any setuid operations. | object |
| user.Ext.real.id | One or multiple unique identifiers of the user. | keyword |
| user.Ext.real.name | Short name or login of the user. | keyword |
| user.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.effective.domain | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.effective.email | User email address. | keyword |
| user.effective.full_name | User's full name, if available. | keyword |
| user.effective.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.effective.id | Unique identifier of the user. | keyword |
| user.effective.name | Short name or login of the user. | keyword |
| user.email | User email address. | keyword |
| user.full_name | User's full name, if available. | keyword |
| user.group.Ext | Object for all custom defined fields to live in. | object |
| user.group.Ext.real | Group info prior to any setgid operations. | object |
| user.group.Ext.real.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.Ext.real.name | Name of the group. | keyword |
| user.group.domain | Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name. | keyword |
| user.group.id | Unique identifier for the group on the system/platform. | keyword |
| user.group.name | Name of the group. | keyword |
| user.hash | Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used. | keyword |
| user.id | Unique identifier of the user. | keyword |
| user.name | Short name or login of the user. | keyword |
| winlog.event_data | The event-specific data. This is a non-exhaustive list of parameters that are used in Windows events. | object |
| winlog.event_data.PrivilegeList | An array of sensitive privileges, assigned to the new logon. | keyword |


## Metrics

The metrics type of documents are stored in `metrics-endpoint.*` indices. The following sections define the mapped fields
sent by the endpoint.

### metadata

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Endpoint.capabilities | Enabled capabilities | keyword |
| Endpoint.configuration | Configuration fields represent the intended and applied setting for fields not part of a Policy setting This reflects what a given field is configured to do. The actual state of that same field is found in Endpoint.state | object |
| Endpoint.configuration.isolation | Configuration setting for Host Isolation from the network | boolean |
| Endpoint.policy | The policy fields are used to hold information about applied policy. | object |
| Endpoint.policy.applied | information about the policy that is applied | object |
| Endpoint.policy.applied.id | the id of the applied policy | keyword |
| Endpoint.policy.applied.name | the name of this applied policy | keyword |
| Endpoint.policy.applied.status | the status of the applied policy | keyword |
| Endpoint.state | Represents the current state of a non-policy setting These fields reflect the current status of a field, which may differ from what it is configured to be (see Endpoint.configuration) | object |
| Endpoint.state.isolation | Current network isolation state of the host | boolean |
| Endpoint.status | The current status of the endpoint e.g. enrolled, unenrolled. | keyword |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.name | Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| elastic.agent | The agent fields contain data about the Elastic Agent. The Elastic Agent is the management agent that manages other agents or process on the host. | object |
| elastic.agent.id | Unique identifier of this elastic agent (if one exists). | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |


### metrics

Metrics documents contain performance information about the endpoint executable and the host it is running on.

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Endpoint.metrics | Metrics fields hold the endpoint and system's performance metrics | object |
| Endpoint.metrics.cpu | CPU statistics | object |
| Endpoint.metrics.cpu.endpoint | CPU metrics for the endpoint | object |
| Endpoint.metrics.cpu.endpoint.histogram | This field defines an elasticsearch histogram field (https://www.elastic.co/guide/en/elasticsearch/reference/current/histogram.html#histogram) The values field includes 20 buckets (each bucket is 5%) representing the cpu usage The counts field includes 20 buckets of how many times the endpoint's cpu usage fell into each bucket | histogram |
| Endpoint.metrics.cpu.endpoint.latest | Average CPU over the last sample interval | half_float |
| Endpoint.metrics.cpu.endpoint.mean | Average CPU load used by the endpoint | half_float |
| Endpoint.metrics.documents_volume | Statistics about sent documents | object |
| Endpoint.metrics.documents_volume.alerts.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.alerts.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.alerts.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.alerts.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.api_events.sent_bytes | Total size of API Event sent documents | long |
| Endpoint.metrics.documents_volume.api_events.sent_count | Number of sent API Event documents | long |
| Endpoint.metrics.documents_volume.api_events.sources | An array of API Event document statistics per source | object |
| Endpoint.metrics.documents_volume.api_events.sources.sent_bytes | Total size of API Event sent documents from source | long |
| Endpoint.metrics.documents_volume.api_events.sources.sent_count | Number of sent API Event documents from source | long |
| Endpoint.metrics.documents_volume.api_events.sources.source | API Event document source name | keyword |
| Endpoint.metrics.documents_volume.api_events.sources.suppressed_bytes | Total size of suppressed API Event documents from source | long |
| Endpoint.metrics.documents_volume.api_events.sources.suppressed_count | Number of suppressed API Event documents from source | long |
| Endpoint.metrics.documents_volume.api_events.suppressed_bytes | Total size of suppressed API Event documents | long |
| Endpoint.metrics.documents_volume.api_events.suppressed_count | Number of suppressed API Event documents | long |
| Endpoint.metrics.documents_volume.diagnostic_alerts.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.diagnostic_alerts.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.diagnostic_alerts.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.diagnostic_alerts.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.dns_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.dns_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.dns_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.dns_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.file_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.file_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.file_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.file_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.library_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.library_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.library_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.library_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.network_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.network_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.network_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.network_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.overall.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.overall.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.overall.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.overall.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.process_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.process_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.process_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.process_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.registry_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.registry_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.registry_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.registry_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.documents_volume.security_events.sent_bytes | Total size of sent documents | long |
| Endpoint.metrics.documents_volume.security_events.sent_count | Number of sent documents | long |
| Endpoint.metrics.documents_volume.security_events.suppressed_bytes | Total size of suppressed documents | long |
| Endpoint.metrics.documents_volume.security_events.suppressed_count | Number of suppressed documents | long |
| Endpoint.metrics.event_filter.active_global_count | The number of active global event filters | long |
| Endpoint.metrics.event_filter.active_user_count | The number of active user event filters | long |
| Endpoint.metrics.memory | Memory statistics | object |
| Endpoint.metrics.memory.endpoint | Endpoint memory utilization | object |
| Endpoint.metrics.memory.endpoint.private | The memory private to the endpoint | object |
| Endpoint.metrics.memory.endpoint.private.latest | The memory usage by the endpoint for the last sample interval | long |
| Endpoint.metrics.memory.endpoint.private.mean | Average memory usage by the endpoint since its start | long |
| Endpoint.metrics.uptime | Number of seconds since boot | object |
| Endpoint.metrics.uptime.endpoint | Number of seconds since the endpoint was started | long |
| Endpoint.metrics.uptime.system | Number of seconds since the system was started | long |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.end | `event.end` contains the date when the event ended or when the activity was last observed. | date |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.start | `event.start` contains the date when the event started or when the activity was first observed. | date |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.domain | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| host.type | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment. | keyword |
| host.uptime | Seconds the host has been up. | long |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |


### policy response

#### Exported fields

| Field | Description | Type |
|---|---|---|
| @timestamp | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events. | date |
| Endpoint.configuration | Configuration fields represent the intended and applied setting for fields not part of a Policy setting This reflects what a given field is configured to do. The actual state of that same field is found in Endpoint.state | object |
| Endpoint.configuration.isolation | Configuration setting for Host Isolation from the network | boolean |
| Endpoint.policy | The policy fields are used to hold information about applied policy. | object |
| Endpoint.policy.applied | information about the policy that is applied | object |
| Endpoint.policy.applied.artifacts | information about protection artifacts applied. | object |
| Endpoint.policy.applied.artifacts.global | information about global protection artifacts applied. | object |
| Endpoint.policy.applied.artifacts.global.identifiers | the identifiers of global artifacts applied. | nested |
| Endpoint.policy.applied.artifacts.global.identifiers.name | the name of global artifact applied. | keyword |
| Endpoint.policy.applied.artifacts.global.identifiers.sha256 | the sha256 of global artifacts applied. | keyword |
| Endpoint.policy.applied.artifacts.global.snapshot | the snapshot date of applied global artifacts or 'latest' | keyword |
| Endpoint.policy.applied.artifacts.global.update_age | number of days since global artifacts were made up-to-date | unsigned_long |
| Endpoint.policy.applied.artifacts.global.version | the version of global artifacts applied. | keyword |
| Endpoint.policy.applied.artifacts.user | information about user protection artifacts applied. | object |
| Endpoint.policy.applied.artifacts.user.identifiers | the identifiers of user artifacts applied. | nested |
| Endpoint.policy.applied.artifacts.user.identifiers.name | the name of user artifact applied. | keyword |
| Endpoint.policy.applied.artifacts.user.identifiers.sha256 | the sha256 of user artifacts applied. | keyword |
| Endpoint.policy.applied.artifacts.user.version | the version of user artifacts applied. | keyword |
| Endpoint.policy.applied.endpoint_policy_version | the version of this applied policy | keyword |
| Endpoint.policy.applied.id | the id of the applied policy | keyword |
| Endpoint.policy.applied.name | the name of this applied policy | keyword |
| Endpoint.policy.applied.status | the status of the applied policy | keyword |
| Endpoint.policy.applied.version | the version of this applied policy | keyword |
| Endpoint.state | Represents the current state of a non-policy setting These fields reflect the current status of a field, which may differ from what it is configured to be (see Endpoint.configuration) | object |
| Endpoint.state.isolation | Current network isolation state of the host | boolean |
| agent.build.original | Extended build information for the agent. This field is intended to contain any build information that a data source may provide, no specific formatting is required. | keyword |
| agent.id | Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id. | keyword |
| agent.type | Type of the agent. The agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine. | keyword |
| agent.version | Version of the agent. | keyword |
| data_stream.dataset | Data stream dataset name. | constant_keyword |
| data_stream.namespace | Data stream namespace. | constant_keyword |
| data_stream.type | Data stream type. | constant_keyword |
| ecs.version | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events. | keyword |
| event.action | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer. | keyword |
| event.category | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories. | keyword |
| event.code | Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID. | keyword |
| event.created | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date |
| event.dataset | Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name. | keyword |
| event.hash | Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity. | keyword |
| event.id | Unique ID to describe the event. | keyword |
| event.ingested | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`. | date |
| event.kind | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not. | keyword |
| event.module | Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module. | keyword |
| event.outcome | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword |
| event.provider | Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing). | keyword |
| event.sequence | Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision. | long |
| event.severity | The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`. | long |
| event.type | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types. | keyword |
| host.architecture | Operating system architecture. | keyword |
| host.hostname | Hostname of the host. It normally contains what the `hostname` command returns on the host machine. | keyword |
| host.id | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`. | keyword |
| host.ip | Host ip addresses. | ip |
| host.mac | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen. | keyword |
| host.name | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host. | keyword |
| host.os.Ext | Object for all custom defined fields to live in. | object |
| host.os.Ext.variant | A string value or phrase that further aid to classify or qualify the operating system (OS).  For example the distribution for a Linux OS will be entered in this field. | keyword |
| host.os.family | OS family (such as redhat, debian, freebsd, windows). | keyword |
| host.os.full | Operating system name, including the version or code name. | keyword |
| host.os.kernel | Operating system kernel version as a raw string. | keyword |
| host.os.name | Operating system name, without the version. | keyword |
| host.os.platform | Operating system platform (such centos, ubuntu, windows). | keyword |
| host.os.type | Use the `os.type` field to categorize the operating system into one of the broad commercial families. If the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition. | keyword |
| host.os.version | Operating system version as a raw string. | keyword |
| message | For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message. | match_only_text |

