"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Ccr = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _status = require("../../../alerts/status");
require("./ccr.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toSeconds(ms) {
  return Math.floor(ms / 1000) + 's';
}
const Ccr = props => {
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const toggleShards = (index, shards) => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[index]) {
      delete itemIdToExpandedRowMapValues[index];
    } else {
      let pagination = {
        initialPageSize: 5,
        pageSizeOptions: [5, 10, 20]
      };
      if (shards.length <= pagination.initialPageSize) {
        pagination = false;
      }
      itemIdToExpandedRowMapValues[index] = /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        items: shards,
        columns: [{
          field: 'shardId',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.shardColumnTitle', {
            defaultMessage: 'Shard'
          }),
          render: shardId => {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/ccr/${index}/shard/${shardId}`)
            }, shardId);
          }
        }, {
          render: () => null
        }, {
          field: 'alerts',
          sortable: true,
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.alertsColumnTitle', {
            defaultMessage: 'Alerts'
          }),
          render: (_field, item) => {
            return /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
              showBadge: true,
              alerts: props.alerts,
              stateFilter: state => state.meta.shardId === item.shardId
            });
          }
        }, {
          field: 'syncLagOps',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.syncLagOpsColumnTitle', {
            defaultMessage: 'Sync Lag (ops)'
          }),
          render: (syncLagOps, data) => /*#__PURE__*/_react.default.createElement("span", null, syncLagOps, "\xA0\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            size: "m",
            type: "iInCircle",
            content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.monitoring.elasticsearch.ccr.shardsTable.syncLagOpsColumn.leaderLagTooltip",
              defaultMessage: "Leader lag: {syncLagOpsLeader}",
              values: {
                syncLagOpsLeader: data.syncLagOpsLeader
              }
            })), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.monitoring.elasticsearch.ccr.shardsTable.syncLagOpsColumn.followerLagTooltip",
              defaultMessage: "Follower lag: {syncLagOpsFollower}",
              values: {
                syncLagOpsFollower: data.syncLagOpsFollower
              }
            }))),
            position: "right"
          }))
        }, {
          field: 'syncLagTime',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.lastFetchTimeColumnTitle', {
            defaultMessage: 'Last fetch time'
          }),
          render: syncLagTime => /*#__PURE__*/_react.default.createElement("span", null, toSeconds(syncLagTime))
        }, {
          field: 'opsSynced',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.opsSyncedColumnTitle', {
            defaultMessage: 'Ops synced'
          })
        }, {
          field: 'error',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.errorColumnTitle', {
            defaultMessage: 'Error'
          }),
          render: error => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "danger"
          }, error)
        }],
        executeQueryOptions: {
          defaultFields: ['shardId']
        },
        sorting: true,
        pagination: pagination
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const renderTable = () => {
    const {
      data,
      alerts
    } = props;
    const items = data;
    let pagination = {
      initialPageSize: 5,
      pageSizeOptions: [5, 10, 20]
    };
    if (items.length <= pagination.initialPageSize) {
      pagination = false;
    }
    const sorting = {
      sort: {
        field: 'index',
        direction: 'asc'
      }
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      className: "monitoringElasticsearchCcrListingTable",
      columns: [{
        field: 'index',
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.indexColumnTitle', {
          defaultMessage: 'Index'
        }),
        sortable: true,
        render: (index, {
          shards
        }) => {
          const expanded = !!itemIdToExpandedRowMap[index];
          return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: () => toggleShards(index, shards)
          }, index, "\xA0", expanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "arrowUp"
          }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "arrowDown"
          }));
        }
      }, {
        field: 'follows',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.followsColumnTitle', {
          defaultMessage: 'Follows'
        })
      }, {
        field: 'alerts',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.alertsColumnTitle', {
          defaultMessage: 'Alerts'
        }),
        render: (_field, item) => {
          return /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
            showBadge: true,
            alerts: alerts,
            stateFilter: state => state.meta.followerIndex === item.index
          });
        }
      }, {
        field: 'syncLagOps',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.syncLagOpsColumnTitle', {
          defaultMessage: 'Sync Lag (ops)'
        })
      }, {
        field: 'syncLagTime',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.lastFetchTimeColumnTitle', {
          defaultMessage: 'Last fetch time'
        }),
        render: syncLagTime => /*#__PURE__*/_react.default.createElement("span", null, toSeconds(syncLagTime))
      }, {
        field: 'opsSynced',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.opsSyncedColumnTitle', {
          defaultMessage: 'Ops synced'
        })
      }, {
        field: 'error',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.errorColumnTitle', {
          defaultMessage: 'Error'
        }),
        render: error => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "danger"
        }, error)
      }],
      items: items,
      pagination: pagination,
      executeQueryOptions: {
        defaultFields: ['index', 'follows']
      },
      sorting: sorting,
      itemId: "id",
      itemIdToExpandedRowMap: itemIdToExpandedRowMap
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.ccr.heading",
    defaultMessage: "CCR"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, renderTable())));
};
exports.Ccr = Ccr;