"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTemplate = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_title = require("../hooks/use_title");
var _toolbar = require("../../components/shared/toolbar");
var _use_monitoring_time = require("../hooks/use_monitoring_time");
var _components = require("../../components");
var _setup_mode = require("../../lib/setup_mode");
var _enums = require("../../../common/enums");
var _alerts_dropdown = require("../../alerts/alerts_dropdown");
var _use_request_error_handler = require("../hooks/use_request_error_handler");
var _toggle_button = require("../../components/setup_mode/toggle_button");
var _header_action_menu_context = require("../contexts/header_action_menu_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageTemplate = ({
  title,
  pageTitle,
  tabs,
  getPageData,
  product,
  children
}) => {
  (0, _use_title.useTitle)('', title);
  const {
    currentTimerange
  } = (0, _use_monitoring_time.useMonitoringTimeContainerContext)();
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const [isRequestPending, setIsRequestPending] = (0, _react.useState)(false);
  const history = (0, _reactRouterDom.useHistory)();
  const [hasError, setHasError] = (0, _react.useState)(false);
  const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_context.HeaderActionMenuContext);
  const getPageDataResponseHandler = (0, _react.useCallback)(result => {
    setHasError(false);
    return result;
  }, [setHasError]);
  (0, _react.useEffect)(() => {
    setIsRequestPending(true);
    getPageData === null || getPageData === void 0 ? void 0 : getPageData().then(getPageDataResponseHandler).catch(err => {
      handleRequestError(err);
      setHasError(true);
    }).finally(() => {
      setLoaded(true);
      setIsRequestPending(false);
    });
  }, [getPageData, currentTimerange, getPageDataResponseHandler, handleRequestError]);
  const onRefresh = () => {
    // don't refresh when a request is pending
    if (isRequestPending) return;
    setIsRequestPending(true);
    getPageData === null || getPageData === void 0 ? void 0 : getPageData().then(getPageDataResponseHandler).catch(handleRequestError).finally(() => {
      setIsRequestPending(false);
    });
    if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
      (0, _setup_mode.updateSetupModeData)();
    }
  };
  const createHref = route => history.createHref({
    pathname: route
  });
  const isTabSelected = route => history.location.pathname === route;
  const renderContent = () => {
    if (hasError) return null;
    if (getPageData && !loaded) return /*#__PURE__*/_react.default.createElement(_components.PageLoading, null);
    return children;
  };
  const {
    supported,
    enabled
  } = (0, _setup_mode.getSetupModeState)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    grow: false,
    "data-test-subj": "monitoringAppContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, null, setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, supported && /*#__PURE__*/_react.default.createElement(_toggle_button.SetupModeToggleButton, {
    enabled: enabled,
    toggleSetupMode: _setup_mode.toggleSetupMode
  }), /*#__PURE__*/_react.default.createElement(_alerts_dropdown.AlertsDropdown, null)), /*#__PURE__*/_react.default.createElement(_toolbar.MonitoringToolbar, {
    pageTitle: pageTitle,
    onRefresh: onRefresh
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), tabs && /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l"
  }, tabs.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: idx,
      disabled: isDisabledTab(product),
      title: item.label,
      "data-test-subj": item.testSubj,
      href: item.route ? createHref(item.route) : undefined,
      isSelected: item.route ? isTabSelected(item.route) : undefined,
      onClick: item.onClick,
      prepend: item.prepend
    }, item.label);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, renderContent()))));
};
exports.PageTemplate = PageTemplate;
function isDisabledTab(product) {
  const setupMode = (0, _setup_mode.getSetupModeState)();
  if (!(0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    return false;
  }
  if (!setupMode.data) {
    return false;
  }
  if (!product) {
    return false;
  }
  const data = setupMode.data[product] || {};
  if (data.totalUniqueInstanceCount === 0) {
    return true;
  }
  if (data.totalUniqueInternallyCollectedCount === 0 && data.totalUniqueFullyMigratedCount === 0 && data.totalUniquePartiallyMigratedCount === 0) {
    return true;
  }
  return false;
}