"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildESQlTheme = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _theme = require("../../common/theme");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)(_constants.ESQL_TOKEN_POSTFIX);
const buildESQlTheme = () => ({
  base: _uiTheme.darkMode ? 'vs-dark' : 'vs',
  inherit: true,
  rules: [
  // base
  ...buildRuleGroup(['explain', 'ws', 'assign', 'comma', 'dot', 'opening_bracket', 'closing_bracket', 'quoted_identifier', 'unquoted_identifier', 'pipe'], _uiTheme.euiThemeVars.euiTextColor),
  // source commands
  ...buildRuleGroup(['from', 'row', 'show'], _uiTheme.euiThemeVars.euiColorPrimaryText, true // isBold
  ),
  // commands
  ...buildRuleGroup(['dev_metrics', 'metadata', 'mv_expand', 'stats', 'dev_inlinestats', 'dissect', 'grok', 'keep', 'rename', 'drop', 'eval', 'sort', 'by', 'where', 'not', 'is', 'like', 'rlike', 'in', 'as', 'limit', 'dev_lookup', 'null', 'enrich', 'on', 'with', 'asc', 'desc', 'nulls_order', 'match'], _uiTheme.euiThemeVars.euiColorAccentText, true // isBold
  ),
  // functions
  ...buildRuleGroup(['functions'], _uiTheme.euiThemeVars.euiColorPrimaryText),
  // operators
  ...buildRuleGroup(['or', 'and', 'rp',
  // ')'
  'lp',
  // '('
  'eq',
  // '=='
  'cieq',
  // '=~'
  'neq',
  // '!='
  'lt',
  //  '<'
  'lte',
  // '<='
  'gt',
  //  '>'
  'gte',
  // '>='
  'plus',
  // '+'
  'minus',
  // '-'
  'asterisk',
  // '*'
  'slash',
  // '/'
  'percent',
  // '%'
  'cast_op' // '::'
  ], _uiTheme.euiThemeVars.euiColorPrimaryText),
  // comments
  ...buildRuleGroup(['line_comment', 'multiline_comment', 'expr_line_comment', 'expr_multiline_comment', 'explain_line_comment', 'explain_multiline_comment', 'project_line_comment', 'project_multiline_comment', 'rename_line_comment', 'rename_multiline_comment', 'from_line_comment', 'from_multiline_comment', 'enrich_line_comment', 'enrich_multiline_comment', 'mvexpand_line_comment', 'mvexpand_multiline_comment', 'enrich_field_line_comment', 'enrich_field_multiline_comment', 'lookup_line_comment', 'lookup_multiline_comment', 'lookup_field_line_comment', 'lookup_field_multiline_comment', 'show_line_comment', 'show_multiline_comment', 'setting', 'setting_line_comment', 'settting_multiline_comment', 'metrics_line_comment', 'metrics_multiline_comment', 'closing_metrics_line_comment', 'closing_metrics_multiline_comment'], _uiTheme.euiThemeVars.euiColorDisabledText),
  // values
  ...buildRuleGroup(['quoted_string', 'integer_literal', 'decimal_literal', 'named_or_positional_param', 'param', 'timespan_literal'], _uiTheme.euiThemeVars.euiColorSuccessText)],
  colors: {
    'editor.foreground': _uiTheme.euiThemeVars.euiTextColor,
    'editor.background': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editor.lineHighlightBackground': _uiTheme.euiThemeVars.euiColorLightestShade,
    'editor.lineHighlightBorder': _uiTheme.euiThemeVars.euiColorLightestShade,
    'editor.selectionHighlightBackground': _uiTheme.euiThemeVars.euiColorLightestShade,
    'editor.selectionHighlightBorder': _uiTheme.euiThemeVars.euiColorLightShade,
    'editorSuggestWidget.background': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editorSuggestWidget.border': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editorSuggestWidget.focusHighlightForeground': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editorSuggestWidget.foreground': _uiTheme.euiThemeVars.euiTextColor,
    'editorSuggestWidget.highlightForeground': _uiTheme.euiThemeVars.euiColorPrimary,
    'editorSuggestWidget.selectedBackground': _uiTheme.euiThemeVars.euiColorPrimary,
    'editorSuggestWidget.selectedForeground': _uiTheme.euiThemeVars.euiColorEmptyShade
  }
});
exports.buildESQlTheme = buildESQlTheme;