"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConsoleTheme = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _code_editor = require("../code_editor");
var _theme = require("../common/theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)();
const background = _uiTheme.euiThemeVars.euiFormBackgroundColor;
const booleanTextColor = '#585CF6';
const methodTextColor = '#DD0A73';
const urlTextColor = '#00A69B';
const buildConsoleTheme = () => {
  const euiTheme = _uiTheme.darkMode ? (0, _code_editor.buildDarkTheme)() : (0, _code_editor.buildLightTheme)();
  return {
    ...euiTheme,
    rules: [...euiTheme.rules, ...buildRuleGroup(['string-literal', 'multi-string', 'punctuation.end-triple-quote'], (0, _eui.makeHighContrastColor)(_uiTheme.euiThemeVars.euiColorDangerText)(background)), ...buildRuleGroup(['constant.language.boolean'], (0, _eui.makeHighContrastColor)(booleanTextColor)(background)), ...buildRuleGroup(['constant.numeric'], (0, _eui.makeHighContrastColor)(_uiTheme.euiThemeVars.euiColorAccentText)(background)), ...buildRuleGroup(['status.info'], (0, _eui.makeHighContrastColor)(_uiTheme.euiThemeVars.euiTextColor)(background)), ...buildRuleGroup(['status.success'], (0, _eui.makeHighContrastColor)(_uiTheme.euiThemeVars.euiTextColor)(_uiTheme.euiThemeVars.euiColorSuccess)), ...buildRuleGroup(['status.redirect'], (0, _eui.makeHighContrastColor)(_uiTheme.euiThemeVars.euiTextColor)(background)), ...buildRuleGroup(['status.warning'], (0, _eui.makeHighContrastColor)(_uiTheme.euiThemeVars.euiTextColor)(_uiTheme.euiThemeVars.euiColorWarning)), ...buildRuleGroup(['status.error'], (0, _eui.makeHighContrastColor)('#FFFFFF')(_uiTheme.euiThemeVars.euiColorDanger)), ...buildRuleGroup(['method'], (0, _eui.makeHighContrastColor)(methodTextColor)(background)), ...buildRuleGroup(['url'], (0, _eui.makeHighContrastColor)(urlTextColor)(background))]
  };
};
exports.buildConsoleTheme = buildConsoleTheme;