"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REALTIME_ISSUE_DETECTED = exports.ANOMALY_DETECTION_JOB_REALTIME_ISSUE = exports.ANOMALY_DETECTION_HEALTH_AAD_INDEX_NAME = exports.ANOMALY_DETECTION_HEALTH_AAD_CONFIG = void 0;
exports.registerJobsMonitoringRuleType = registerJobsMonitoringRuleType;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/alerting-plugin/server");
var _fieldTypes = require("@kbn/field-types");
var _alerts = require("../../../common/constants/alerts");
var _app = require("../../../common/constants/app");
var _license = require("../../../common/license");
var _alerting_schema = require("../../routes/schemas/alerting_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANOMALY_DETECTION_JOB_REALTIME_ISSUE = exports.ANOMALY_DETECTION_JOB_REALTIME_ISSUE = 'anomaly_detection_realtime_issue';
const REALTIME_ISSUE_DETECTED = exports.REALTIME_ISSUE_DETECTED = {
  id: ANOMALY_DETECTION_JOB_REALTIME_ISSUE,
  name: _i18n.i18n.translate('xpack.ml.jobsHealthAlertingRule.actionGroupName', {
    defaultMessage: 'Issue detected'
  })
};
const ANOMALY_DETECTION_HEALTH_AAD_INDEX_NAME = exports.ANOMALY_DETECTION_HEALTH_AAD_INDEX_NAME = 'ml.anomaly-detection-health';
const ANOMALY_DETECTION_HEALTH_AAD_CONFIG = exports.ANOMALY_DETECTION_HEALTH_AAD_CONFIG = {
  context: ANOMALY_DETECTION_HEALTH_AAD_INDEX_NAME,
  mappings: {
    fieldMap: {
      [_alerts.ALERT_MML_RESULTS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          job_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          memory_status: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          log_time: {
            type: _fieldTypes.ES_FIELD_TYPES.DATE
          },
          model_bytes: {
            type: _fieldTypes.ES_FIELD_TYPES.LONG
          },
          model_bytes_memory_limit: {
            type: _fieldTypes.ES_FIELD_TYPES.LONG
          },
          peak_model_bytes: {
            type: _fieldTypes.ES_FIELD_TYPES.LONG
          },
          model_bytes_exceeded: {
            type: _fieldTypes.ES_FIELD_TYPES.LONG
          }
        }
      },
      [_alerts.ALERT_DATAFEED_RESULTS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          job_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          job_state: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          datafeed_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          datafeed_state: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          }
        }
      },
      [_alerts.ALERT_DELAYED_DATA_RESULTS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          job_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          annotation: {
            type: _fieldTypes.ES_FIELD_TYPES.TEXT
          },
          missed_docs_count: {
            type: _fieldTypes.ES_FIELD_TYPES.LONG
          },
          end_timestamp: {
            type: _fieldTypes.ES_FIELD_TYPES.DATE
          }
        }
      },
      [_alerts.ALERT_JOB_ERRORS_RESULTS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          job_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          errors: {
            type: _fieldTypes.ES_FIELD_TYPES.OBJECT
          }
        }
      }
    }
  },
  shouldWrite: true
};
function registerJobsMonitoringRuleType({
  alerting,
  mlServicesProviders,
  logger
}) {
  alerting.registerType({
    id: _alerts.ML_ALERT_TYPES.AD_JOBS_HEALTH,
    name: _i18n.i18n.translate('xpack.ml.jobsHealthAlertingRule.name', {
      defaultMessage: 'Anomaly detection jobs health'
    }),
    actionGroups: [REALTIME_ISSUE_DETECTED],
    defaultActionGroupId: ANOMALY_DETECTION_JOB_REALTIME_ISSUE,
    validate: {
      params: _alerting_schema.anomalyDetectionJobsHealthRuleParams
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: _alerting_schema.anomalyDetectionJobsHealthRuleParams
      }
    },
    actionVariables: {
      context: [{
        name: 'results',
        description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.alertContext.resultsDescription', {
          defaultMessage: 'Results of the rule execution'
        })
      }, {
        name: 'message',
        description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.alertContext.messageDescription', {
          defaultMessage: 'Alert info message'
        })
      }]
    },
    category: _server.DEFAULT_APP_CATEGORIES.management.id,
    producer: _app.PLUGIN_ID,
    minimumLicenseRequired: _license.MINIMUM_FULL_LICENSE,
    isExportable: true,
    doesSetRecoveryContext: true,
    alerts: ANOMALY_DETECTION_HEALTH_AAD_CONFIG,
    async executor(options) {
      const {
        services,
        rule: {
          name
        }
      } = options;
      const {
        alertsClient
      } = services;
      if (!alertsClient) {
        throw new _server2.AlertsClientError();
      }
      const fakeRequest = Object.create(null);
      const {
        getTestsResults
      } = mlServicesProviders.jobsHealthServiceProvider(services.savedObjectsClient, fakeRequest, logger);
      const executionResult = await getTestsResults(options);
      const unhealthyTests = executionResult.filter(({
        isHealthy
      }) => !isHealthy);
      if (unhealthyTests.length > 0) {
        logger.debug(`"${name}" rule is scheduling actions for tests: ${unhealthyTests.map(v => v.name).join(', ')}`);
        unhealthyTests.forEach(({
          name: alertName,
          context,
          payload
        }) => {
          alertsClient.report({
            id: alertName,
            actionGroup: ANOMALY_DETECTION_JOB_REALTIME_ISSUE,
            context,
            // @ts-expect-error type mismatch
            payload
          });
        });
      }

      // Set context for recovered alerts
      for (const recoveredAlert of alertsClient.getRecoveredAlerts()) {
        const recoveredAlertId = recoveredAlert.alert.getId();
        const testResult = executionResult.find(v => v.name === recoveredAlertId);
        if (testResult) {
          alertsClient.setAlertData({
            id: recoveredAlertId,
            context: testResult.context,
            // @ts-expect-error type mismatch
            payload: testResult.payload
          });
        }
      }
      return {
        state: {}
      };
    }
  });
}