"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableSingleMetricViewerUserInput = resolveEmbeddableSingleMetricViewerUserInput;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _single_metric_viewer_initializer = require("./single_metric_viewer_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableSingleMetricViewerUserInput(coreStart, parentApi, focusedPanelId, services, mlApi, input) {
  const {
    http,
    overlays,
    ...startServices
  } = coreStart;
  const {
    data,
    share
  } = services;
  const timefilter = data.query.timefilter.timefilter;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  return new Promise(async (resolve, reject) => {
    try {
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          mlServices: {
            mlApi
          },
          data,
          share,
          ...coreStart
        }
      }, /*#__PURE__*/_react.default.createElement(_single_metric_viewer_initializer.SingleMetricViewerInitializer, {
        "data-test-subj": "mlSingleMetricViewerEmbeddableInitializer",
        mlApi: mlApi,
        bounds: timefilter.getBounds(),
        initialInput: input,
        onCreate: explicitInput => {
          resolve(explicitInput);
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        },
        onCancel: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      })), startServices), {
        type: 'push',
        ownFocus: true,
        size: 's',
        onClose: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      });
      // Close the flyout when user navigates out of the current plugin
      if ((0, _presentationContainers.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}