"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSingleMetricViewerDataFetcher = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeSingleMetricViewerDataFetcher = (api, dataLoading, blockingError, timefilter) => {
  const singleMetricViewerData$ = new _rxjs.BehaviorSubject({
    singleMetricViewerData: undefined,
    bounds: undefined,
    lastRefresh: undefined
  });
  const singleMetricViewerInput$ = (0, _rxjs.combineLatest)({
    jobIds: api.jobIds,
    selectedDetectorIndex: api.selectedDetectorIndex,
    selectedEntities: api.selectedEntities,
    forecastId: api.forecastId,
    functionDescription: api.functionDescription
  });
  const subscription = (0, _rxjs.combineLatest)([singleMetricViewerInput$, (0, _presentationPublishing.fetch$)(api)]).subscribe(([singleMetricViewerData, fetchContext]) => {
    let bounds;
    let lastRefresh;
    if (timefilter !== undefined) {
      var _api$timeRange$$value, _api$timeRange$;
      bounds = timefilter.calculateBounds(fetchContext !== null && fetchContext !== void 0 && fetchContext.timeRange ? fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeRange : (_api$timeRange$$value = (_api$timeRange$ = api.timeRange$) === null || _api$timeRange$ === void 0 ? void 0 : _api$timeRange$.value) !== null && _api$timeRange$$value !== void 0 ? _api$timeRange$$value : timefilter.getTime());
      lastRefresh = Date.now();
    }
    singleMetricViewerData$.next({
      singleMetricViewerData,
      bounds,
      lastRefresh
    });
  });
  return {
    singleMetricViewerData$,
    onDestroy: () => {
      subscription.unsubscribe();
    }
  };
};
exports.initializeSingleMetricViewerDataFetcher = initializeSingleMetricViewerDataFetcher;