"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSingleMetricViewerControls = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeSingleMetricViewerControls = (rawState, titlesApi) => {
  var _rawState$selectedDet;
  const functionDescription = new _rxjs.BehaviorSubject(rawState.functionDescription);
  const jobIds = new _rxjs.BehaviorSubject(rawState.jobIds);
  const selectedDetectorIndex = new _rxjs.BehaviorSubject((_rawState$selectedDet = rawState.selectedDetectorIndex) !== null && _rawState$selectedDet !== void 0 ? _rawState$selectedDet : 0);
  const selectedEntities = new _rxjs.BehaviorSubject(rawState.selectedEntities);
  const forecastId = new _rxjs.BehaviorSubject(rawState.forecastId);
  const updateUserInput = update => {
    jobIds.next(update.jobIds);
    functionDescription.next(update.functionDescription);
    selectedDetectorIndex.next(update.selectedDetectorIndex);
    selectedEntities.next(update.selectedEntities);
    titlesApi.setPanelTitle(update.panelTitle);
  };
  const updateForecastId = id => {
    forecastId.next(id);
  };
  const serializeSingleMetricViewerState = () => {
    return {
      jobIds: jobIds.getValue(),
      forecastId: forecastId.getValue(),
      selectedDetectorIndex: selectedDetectorIndex.getValue(),
      selectedEntities: selectedEntities.getValue(),
      functionDescription: functionDescription === null || functionDescription === void 0 ? void 0 : functionDescription.getValue()
    };
  };
  const singleMetricViewerComparators = {
    jobIds: [jobIds, ids => jobIds.next(ids), _fastDeepEqual.default],
    forecastId: [forecastId, id => forecastId.next(id)],
    selectedDetectorIndex: [selectedDetectorIndex, index => selectedDetectorIndex.next(index)],
    selectedEntities: [selectedEntities, items => selectedEntities.next(items), _fastDeepEqual.default],
    functionDescription: [functionDescription, description => functionDescription.next(description)]
  };
  return {
    singleMetricViewerControlsApi: {
      jobIds,
      forecastId,
      selectedDetectorIndex,
      selectedEntities,
      functionDescription,
      updateForecastId,
      updateUserInput
    },
    serializeSingleMetricViewerState,
    singleMetricViewerComparators,
    onSingleMetricViewerDestroy: () => {
      forecastId.complete();
      jobIds.complete();
      selectedDetectorIndex.complete();
      selectedEntities.complete();
      functionDescription.complete();
    }
  };
};
exports.initializeSingleMetricViewerControls = initializeSingleMetricViewerControls;