"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServices = exports.getAnomalySwimLaneEmbeddableFactory = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react2 = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _ = require("..");
var _constants = require("../../application/explorer/constants");
var _swimlane_container = require("../../application/explorer/swimlane_container");
var _http_service = require("../../application/services/http_service");
var _ui_actions = require("../../ui_actions");
var _anomaly_detection_embeddable = require("../common/anomaly_detection_embeddable");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _initialize_swim_lane_controls = require("./initialize_swim_lane_controls");
var _initialize_swim_lane_data_fetcher = require("./initialize_swim_lane_data_fetcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Provides the services required by the Anomaly Swimlane Embeddable.
 */
const getServices = async getStartServices => {
  const [[coreStart, pluginsStart], {
    AnomalyDetectorService
  }, {
    AnomalyTimelineService
  }, {
    mlApiProvider
  }, {
    mlResultsServiceProvider
  }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_detector_service'))), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_timeline_service'))), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/ml_api_service'))), Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/results_service')))]);
  const httpService = new _http_service.HttpService(coreStart.http);
  const anomalyDetectorService = new AnomalyDetectorService(httpService);
  const anomalyTimelineService = new AnomalyTimelineService(pluginsStart.data.query.timefilter.timefilter, coreStart.uiSettings, mlResultsServiceProvider(mlApiProvider(httpService)));
  return [coreStart, pluginsStart, {
    anomalyDetectorService,
    anomalyTimelineService
  }];
};
exports.getServices = getServices;
const getAnomalySwimLaneEmbeddableFactory = getStartServices => {
  const factory = {
    type: _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE,
    deserializeState: state => state.rawState,
    buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
      var _ref, _ref2;
      if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
        throw new Error('Parent API does not have execution context');
      }
      const services = await getServices(getStartServices);
      const [coreStartServices, pluginsStartServices, anomalySwimLaneServices] = services;
      const subscriptions = new _rxjs.Subscription();
      const interval = new _rxjs.BehaviorSubject(undefined);
      const dataLoading = new _rxjs.BehaviorSubject(true);
      const blockingError = new _rxjs.BehaviorSubject(undefined);
      const query$ = // @ts-ignore
      (_ref = state.query ? new _rxjs.BehaviorSubject(state.query) : parentApi === null || parentApi === void 0 ? void 0 : parentApi.query$) !== null && _ref !== void 0 ? _ref : new _rxjs.BehaviorSubject(undefined);
      const filters$ = // @ts-ignore
      (_ref2 = state.query ? new _rxjs.BehaviorSubject(state.filters) : parentApi === null || parentApi === void 0 ? void 0 : parentApi.filters$) !== null && _ref2 !== void 0 ? _ref2 : new _rxjs.BehaviorSubject(undefined);
      const refresh$ = new _rxjs.BehaviorSubject(undefined);
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(state);
      const {
        api: timeRangeApi,
        comparators: timeRangeComparators,
        serialize: serializeTimeRange
      } = (0, _presentationPublishing.initializeTimeRange)(state);
      const {
        swimLaneControlsApi,
        serializeSwimLaneState,
        swimLaneComparators,
        onSwimLaneDestroy
      } = (0, _initialize_swim_lane_controls.initializeSwimLaneControls)(state, titlesApi);

      // Helpers for swim lane data fetching
      const chartWidth$ = new _rxjs.BehaviorSubject(undefined);
      const api = buildApi({
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.ml.swimlaneEmbeddable.typeDisplayName', {
          defaultMessage: 'swim lane'
        }),
        onEdit: async () => {
          try {
            const {
              resolveAnomalySwimlaneUserInput
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_swimlane_setup_flyout')));
            const result = await resolveAnomalySwimlaneUserInput({
              ...coreStartServices,
              ...pluginsStartServices
            }, parentApi, uuid, {
              ...serializeTitles(),
              ...serializeSwimLaneState()
            });
            swimLaneControlsApi.updateUserInput(result);
          } catch (e) {
            return Promise.reject();
          }
        },
        ...titlesApi,
        ...timeRangeApi,
        ...swimLaneControlsApi,
        query$,
        filters$,
        interval,
        setInterval: v => interval.next(v),
        dataViews: (0, _anomaly_detection_embeddable.buildDataViewPublishingApi)({
          anomalyDetectorService: services[2].anomalyDetectorService,
          dataViewsService: services[1].data.dataViews
        }, {
          jobIds: swimLaneControlsApi.jobIds
        }, subscriptions),
        dataLoading,
        serializeState: () => {
          return {
            rawState: {
              timeRange: undefined,
              ...serializeTitles(),
              ...serializeTimeRange(),
              ...serializeSwimLaneState()
            },
            references: []
          };
        }
      }, {
        ...timeRangeComparators,
        ...titleComparators,
        ...swimLaneComparators
      });
      const appliedTimeRange$ = (0, _rxjs.combineLatest)([api.timeRange$, (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesTimeRange)(api.parentApi) ? api.parentApi.timeRange$ : (0, _rxjs.of)(null), (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesTimeRange)(api.parentApi) ? api.parentApi.timeslice$ : (0, _rxjs.of)(null)]).pipe(
      // @ts-ignore
      (0, _rxjs.map)(([timeRange, parentTimeRange, parentTimeslice]) => {
        if (timeRange) {
          return timeRange;
        }
        if (parentTimeRange) {
          return parentTimeRange;
        }
        if (parentTimeslice) {
          return parentTimeRange;
        }
        return undefined;
      }));
      const {
        swimLaneData$,
        onDestroy
      } = (0, _initialize_swim_lane_data_fetcher.initializeSwimLaneDataFetcher)(api, chartWidth$.asObservable(), dataLoading, blockingError, appliedTimeRange$, query$, filters$, refresh$, anomalySwimLaneServices);
      subscriptions.add((0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => ({
        query: fetchContext.query,
        filters: fetchContext.filters,
        timeRange: fetchContext.timeRange
      })), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)).subscribe(() => {
        api.updatePagination({
          fromPage: 1
        });
      }));
      const onRenderComplete = () => {};
      return {
        api,
        Component: () => {
          const {
            uiSettings
          } = coreStartServices;
          const {
            uiActions
          } = pluginsStartServices;
          const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          (0, _use_embeddable_execution_context.useReactEmbeddableExecutionContext)(services[0].executionContext, parentApi.executionContext, _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE, uuid);
          (0, _useUnmount.default)(() => {
            onSwimLaneDestroy();
            onDestroy();
            subscriptions.unsubscribe();
          });
          const [fromPage, perPage, swimlaneType, swimlaneData, error] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.fromPage, api.perPage, api.swimlaneType, swimLaneData$, blockingError);
          const [selectedCells, setSelectedCells] = (0, _react2.useState)();
          const onCellsSelection = (0, _react2.useCallback)(update => {
            setSelectedCells(update);
            if (update) {
              uiActions.getTrigger(_ui_actions.SWIM_LANE_SELECTION_TRIGGER).exec({
                embeddable: api,
                data: update,
                updateCallback: setSelectedCells.bind(null, undefined)
              });
            }
          },
          // eslint-disable-next-line react-hooks/exhaustive-deps
          [swimlaneData, perPage, setSelectedCells]);
          if (error) {
            return /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
              title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.swimlaneEmbeddable.errorMessage",
                defaultMessage: "Unable to load the data for the swim lane"
              }),
              color: "danger",
              iconType: "warning",
              css: {
                width: '100%'
              }
            }, /*#__PURE__*/_react2.default.createElement("p", null, error.message));
          }
          return /*#__PURE__*/_react2.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStartServices, /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, {
            services: {
              ...coreStartServices
            }
          }, /*#__PURE__*/_react2.default.createElement("div", {
            css: (0, _react.css)`
                    width: 100%;
                    padding: 8px;
                  `,
            "data-test-subj": "mlAnomalySwimlaneEmbeddableWrapper",
            "data-shared-item": "" // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376
          }, /*#__PURE__*/_react2.default.createElement(_swimlane_container.SwimlaneContainer, {
            id: uuid,
            "data-test-subj": `mlSwimLaneEmbeddable_${uuid}`,
            timeBuckets: timeBuckets,
            swimlaneData: swimlaneData,
            swimlaneType: swimlaneType,
            fromPage: fromPage,
            perPage: perPage,
            swimlaneLimit: (0, _swimlane_container.isViewBySwimLaneData)(swimlaneData) ? swimlaneData.cardinality : undefined,
            onResize: size => chartWidth$.next(size),
            selection: selectedCells,
            onCellsSelection: onCellsSelection,
            onPaginationChange: update => {
              if (update.fromPage) {
                api.updatePagination({
                  fromPage: update.fromPage
                });
              }
              if (update.perPage) {
                api.updatePagination({
                  perPage: update.perPage,
                  fromPage: 1
                });
              }
            },
            isLoading: dataLoading.value,
            yAxisWidth: {
              max: _constants.Y_AXIS_LABEL_WIDTH
            },
            noDataWarning: /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
              titleSize: "xxs",
              css: {
                padding: 0
              },
              title: /*#__PURE__*/_react2.default.createElement("h2", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.swimlaneEmbeddable.noDataFound",
                defaultMessage: "No anomalies found"
              }))
            }),
            chartsService: pluginsStartServices.charts,
            onRenderComplete: onRenderComplete
          }))));
        }
      };
    }
  };
  return factory;
};
exports.getAnomalySwimLaneEmbeddableFactory = getAnomalySwimLaneEmbeddableFactory;