"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMlGlobalServices = getMlGlobalServices;
var _license = require("../../../common/license");
var _check_capabilities = require("../capabilities/check_capabilities");
var _field_format_service_factory = require("../services/field_format_service_factory");
var _http_service = require("../services/http_service");
var _ml_api_service = require("../services/ml_api_service");
var _usage_collection = require("../services/usage_collection");
var _job_service = require("../services/job_service");
var _index_service = require("./index_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides global services available across the entire ML app.
 */
function getMlGlobalServices(coreStart, dataViews, usageCollection) {
  const httpService = new _http_service.HttpService(coreStart.http);
  const mlApi = (0, _ml_api_service.mlApiProvider)(httpService);
  const mlJobService = (0, _job_service.mlJobServiceFactory)(mlApi);
  // Note on the following services:
  // - `mlIndexUtils` is just instantiated here to be passed on to `mlFieldFormatService`,
  //   but it's not being made available as part of global services. Since it's just
  //   some stateless utils `useMlIndexUtils()` should be used from within components.
  // - `mlFieldFormatService` is a stateful legacy service that relied on "dependency cache",
  //   so because of its own state it needs to be made available as a global service.
  //   In the long run we should again try to get rid of it here and make it available via
  //   its own context or possibly without having a singleton like state at all, since the
  //   way this manages its own state right now doesn't consider React component lifecycles.
  const mlIndexUtils = (0, _index_service.indexServiceFactory)(dataViews);
  const mlFieldFormatService = (0, _field_format_service_factory.fieldFormatServiceFactory)(mlApi, mlIndexUtils, mlJobService);
  return {
    httpService,
    mlApi,
    mlFieldFormatService,
    mlUsageCollection: (0, _usage_collection.mlUsageCollectionProvider)(usageCollection),
    mlCapabilities: new _check_capabilities.MlCapabilitiesService(mlApi),
    mlLicense: new _license.MlLicense()
  };
}