"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewEventModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _moment = _interopRequireDefault(require("moment"));
var _mlDateUtils = require("@kbn/ml-date-utils");
var _utils = require("../utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VALID_DATE_STRING_LENGTH = 19;
const INLINE_DATE_PICKER_RANGE_WIDTH = 553;
class NewEventModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onDescriptionChange", e => {
      this.setState({
        description: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "handleAddEvent", () => {
      const {
        description,
        startDate,
        endDate
      } = this.state;
      // Temp reference to unsaved events to allow removal from table
      const tempId = (0, _utils.generateTempId)();
      const event = {
        description,
        start_time: startDate.valueOf(),
        end_time: endDate.valueOf(),
        event_id: tempId
      };
      this.props.addEvent(event);
    });
    (0, _defineProperty2.default)(this, "handleChangeStart", date => {
      let start = null;
      let end = this.state.endDate;
      const startMoment = (0, _moment.default)(date);
      const endMoment = (0, _moment.default)(date);
      start = startMoment.startOf('day');
      if (start > end) {
        end = endMoment.startOf('day').add(1, 'days');
      }
      this.setState({
        startDate: start,
        endDate: end,
        startDateString: start.format(_mlDateUtils.TIME_FORMAT),
        endDateString: end.format(_mlDateUtils.TIME_FORMAT)
      });
    });
    (0, _defineProperty2.default)(this, "handleChangeEnd", date => {
      let start = this.state.startDate;
      let end = null;
      const startMoment = (0, _moment.default)(date);
      const endMoment = (0, _moment.default)(date);
      end = endMoment.startOf('day');
      if (start > end) {
        start = startMoment.startOf('day').subtract(1, 'days');
      }
      this.setState({
        startDate: start,
        endDate: end,
        startDateString: start.format(_mlDateUtils.TIME_FORMAT),
        endDateString: end.format(_mlDateUtils.TIME_FORMAT)
      });
    });
    (0, _defineProperty2.default)(this, "handleTimeStartChange", event => {
      const dateString = event.target.value;
      let isValidDate = false;
      if (dateString.length === VALID_DATE_STRING_LENGTH) {
        isValidDate = (0, _moment.default)(dateString).isValid(_mlDateUtils.TIME_FORMAT, true);
      } else {
        this.setState({
          startDateString: dateString
        });
      }
      if (isValidDate) {
        this.setState({
          startDateString: dateString,
          startDate: (0, _moment.default)(dateString)
        });
      }
    });
    (0, _defineProperty2.default)(this, "handleTimeEndChange", event => {
      const dateString = event.target.value;
      let isValidDate = false;
      if (dateString.length === VALID_DATE_STRING_LENGTH) {
        isValidDate = (0, _moment.default)(dateString).isValid(_mlDateUtils.TIME_FORMAT, true);
      } else {
        this.setState({
          endDateString: dateString
        });
      }
      if (isValidDate) {
        this.setState({
          endDateString: dateString,
          endDate: (0, _moment.default)(dateString)
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderRangedDatePicker", () => {
      const {
        startDate,
        endDate,
        startDateString,
        endDateString
      } = this.state;
      const timeInputs = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.calendarsEdit.newEventModal.fromLabel",
          defaultMessage: "From:"
        }),
        helpText: _mlDateUtils.TIME_FORMAT
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        name: "startTime",
        onChange: this.handleTimeStartChange,
        placeholder: _mlDateUtils.TIME_FORMAT,
        value: startDateString
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.calendarsEdit.newEventModal.toLabel",
          defaultMessage: "To:"
        }),
        helpText: _mlDateUtils.TIME_FORMAT
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        name: "endTime",
        onChange: this.handleTimeEndChange,
        placeholder: _mlDateUtils.TIME_FORMAT,
        value: endDateString
      })))));
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), timeInputs, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
        inline: true,
        css: (0, _react2.css)`
              @media (min-width: ${INLINE_DATE_PICKER_RANGE_WIDTH}px) {
                inline-size: ${INLINE_DATE_PICKER_RANGE_WIDTH}px;
                max-inline-size: 100%;
              }
            `,
        startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
          selected: startDate,
          onChange: this.handleChangeStart,
          startDate: startDate,
          endDate: endDate,
          isInvalid: startDate > endDate,
          "aria-label": _i18n.i18n.translate('xpack.ml.calendarsEdit.newEventModal.startDateAriaLabel', {
            defaultMessage: 'Start date'
          }),
          timeFormat: _mlDateUtils.TIME_FORMAT,
          dateFormat: _mlDateUtils.TIME_FORMAT
        }),
        endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
          selected: endDate,
          onChange: this.handleChangeEnd,
          startDate: startDate,
          endDate: endDate,
          isInvalid: startDate > endDate,
          "aria-label": _i18n.i18n.translate('xpack.ml.calendarsEdit.newEventModal.endDateAriaLabel', {
            defaultMessage: 'End date'
          }),
          timeFormat: _mlDateUtils.TIME_FORMAT,
          dateFormat: _mlDateUtils.TIME_FORMAT
        })
      })));
    });
    const _startDate = (0, _moment.default)().startOf('day');
    const _endDate = (0, _moment.default)().startOf('day').add(1, 'days');
    this.state = {
      startDate: _startDate,
      endDate: _endDate,
      description: '',
      startDateString: _startDate.format(_mlDateUtils.TIME_FORMAT),
      endDateString: _endDate.format(_mlDateUtils.TIME_FORMAT)
    };
  }
  render() {
    const {
      closeModal
    } = this.props;
    const {
      description
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeModal,
      initialFocus: "[name=eventDescription]",
      maxWidth: false,
      "data-test-subj": 'mlCalendarEventForm'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.newEventModal.createNewEventTitle",
      defaultMessage: "Create new event"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.calendarsEdit.newEventModal.descriptionLabel",
        defaultMessage: "Description"
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "eventDescription",
      onChange: this.onDescriptionChange,
      isInvalid: !description,
      fullWidth: true,
      "data-test-subj": 'mlCalendarEventDescriptionInput'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderRangedDatePicker())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      "data-test-subj": 'mlCalendarCancelEventButton'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.newEventModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.handleAddEvent,
      fill: true,
      disabled: !description,
      "data-test-subj": 'mlCalendarAddEventButton'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.newEventModal.addButtonLabel",
      defaultMessage: "Add"
    })))));
  }
}
exports.NewEventModal = NewEventModal;
(0, _defineProperty2.default)(NewEventModal, "propTypes", {
  closeModal: _propTypes.PropTypes.func.isRequired,
  addEvent: _propTypes.PropTypes.func.isRequired
});