"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteButton = ({
  onClick,
  testSubj,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "danger",
    onClick: onClick,
    isDisabled: disabled,
    "data-test-subj": testSubj
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.eventsTable.deleteButtonLabel",
    defaultMessage: "Delete"
  })));
};
const EventsTable = ({
  eventsList,
  onDeleteClick,
  showSearchBar,
  showImportModal,
  showNewEventModal,
  loading,
  saving,
  timezone,
  isDst
}) => {
  const [canCreateCalendar, canDeleteCalendar] = (0, _check_capabilities.usePermissionCheck)(['canCreateCalendar', 'canDeleteCalendar']);
  const pagination = {
    initialPageSize: 5,
    pageSizeOptions: [5, 10]
  };
  const formatEventDate = (0, _react.useCallback)(timeMs => {
    if (timezone === undefined) {
      const time = (0, _momentTimezone.default)(timeMs);
      return time.format(_mlDateUtils.TIME_FORMAT);
    }
    const time = _momentTimezone.default.tz(timeMs, timezone);
    return time.toLocaleString();
  }, [timezone]);
  const columns = [{
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.descriptionColumnName', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    truncateText: true,
    scope: 'row'
  }, {
    field: 'start_time',
    name: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.startColumnName', {
      defaultMessage: 'Start'
    }), isDst ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop",
      content: _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.startColumnTooltip', {
        defaultMessage: 'The start time of the daylight savings change event.'
      })
    })) : null),
    sortable: true,
    render: formatEventDate
  }, {
    field: 'end_time',
    name: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.endColumnName', {
      defaultMessage: 'End'
    }), isDst ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop",
      content: _i18n.i18n.translate('xpack.ml.calendarsEdit.eventsTable.endColumnTooltip', {
        defaultMessage: 'The end time of the daylight savings change event. 2 days after the start time.'
      })
    })) : null),
    sortable: true,
    render: formatEventDate
  }, {
    field: '',
    name: '',
    render: event => /*#__PURE__*/_react.default.createElement(DeleteButton, {
      testSubj: "mlCalendarEventDeleteButton",
      disabled: canDeleteCalendar === false || saving === true || loading === true,
      onClick: () => {
        onDeleteClick(event.event_id);
      }
    })
  }];
  const search = {
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: canCreateCalendar === false || saving === true || loading === true,
      key: "ml_new_event",
      "data-test-subj": "mlCalendarNewEventButton",
      size: "s",
      iconType: "plusInCircle",
      onClick: showNewEventModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.newEventButtonLabel",
      defaultMessage: "New event"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: canCreateCalendar === false || saving === true || loading === true,
      key: "ml_import_event",
      "data-test-subj": "mlCalendarImportEventsButton",
      size: "s",
      iconType: "importAction",
      onClick: showImportModal
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.eventsTable.importEventsButtonLabel",
      defaultMessage: "Import events"
    }))],
    box: {
      incremental: true
    },
    filters: []
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: eventsList,
    itemId: "event_id",
    columns: columns,
    pagination: pagination,
    sorting: {
      sort: {
        field: 'start_time',
        direction: 'asc'
      }
    },
    search: showSearchBar ? search : undefined,
    "data-test-subj": "mlCalendarEventsTable",
    rowProps: item => ({
      'data-test-subj': `mlCalendarEventListRow row-${item.description}`
    })
  }));
};
exports.EventsTable = EventsTable;