"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DstEventGenerator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _dst_utils = require("../../dst_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DstEventGenerator = ({
  addEvents,
  setTimezone,
  isDisabled
}) => {
  const [selectedTimeZones, setSelectedTimeZones] = (0, _react.useState)([]);
  const [eventsCount, setEventsCount] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (selectedTimeZones.length > 0) {
      setTimezone(selectedTimeZones[0].value);
      const events = (0, _dst_utils.createDstEvents)(selectedTimeZones[0].value);
      addEvents(events);
      setEventsCount(events.length);
    } else {
      addEvents([]);
      setEventsCount(null);
    }
  }, [addEvents, selectedTimeZones, setTimezone]);
  const timeZoneOptions = (0, _react.useMemo)(() => {
    return (0, _dst_utils.generateTimeZones)().map(tz => {
      return {
        label: tz,
        value: tz
      };
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.dstEventsHelpText",
      defaultMessage: "The selected time zone should match the time zone of the data."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      width: '400px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: "Select time zone",
    singleSelection: {
      asPlainText: true
    },
    options: timeZoneOptions,
    selectedOptions: selectedTimeZones,
    onChange: setSelectedTimeZones,
    isDisabled: isDisabled === true
  })))), eventsCount === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "iInCircle",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.dstEventGenerator.noTimeZonesAvailableTitle",
      defaultMessage: "No DST events available"
    })
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.dstEventGenerator.noTimeZonesAvailableDescription",
    defaultMessage: "Some time zones do not observe daylight saving time."
  })))) : null);
};
exports.DstEventGenerator = DstEventGenerator;