"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferenceModelsApiProvider = inferenceModelsApiProvider;
var _app = require("../../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function inferenceModelsApiProvider(httpService) {
  return {
    /**
     * creates inference endpoint id
     * @param inferenceId - Inference Endpoint Id
     * @param taskType - Inference Task type. Either sparse_embedding or text_embedding
     * @param modelConfig - Model configuration based on service type
     */
    async createInferenceEndpoint(inferenceId, taskType, modelConfig) {
      const result = await httpService.http({
        path: `${_app.ML_INTERNAL_BASE_PATH}/_inference/${taskType}/${inferenceId}`,
        method: 'PUT',
        body: JSON.stringify(modelConfig),
        version: '1'
      });
      return result;
    },
    /**
     * Gets all inference endpoints
     */
    async getAllInferenceEndpoints() {
      const result = await httpService.http({
        path: `${_app.ML_INTERNAL_BASE_PATH}/_inference/all`,
        method: 'GET',
        version: '1'
      });
      return result;
    }
  };
}