"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardServiceProvider = dashboardServiceProvider;
exports.useDashboardService = useDashboardService;
var _react = require("react");
var _public = require("@kbn/embeddable-plugin/public");
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function dashboardServiceProvider(dashboardService) {
  return {
    /**
     * Fetches dashboards
     */
    async fetchDashboards(query) {
      const findDashboardsService = await dashboardService.findDashboardsService();
      const responses = await findDashboardsService.search({
        search: query ? `${query}*` : '',
        size: 1000
      });
      return responses.hits;
    },
    /**
     * Fetch dashboards by id
     */
    async fetchDashboardsById(ids) {
      const findDashboardsService = await dashboardService.findDashboardsService();
      const responses = await findDashboardsService.findByIds(ids);
      const existingDashboards = responses.filter(({
        status
      }) => status === 'success');
      return existingDashboards;
    },
    /**
     * Generates dashboard url
     */
    async getDashboardUrl(dashboardId, viewMode = _public.ViewMode.EDIT) {
      var _dashboardService$loc;
      return await ((_dashboardService$loc = dashboardService.locator) === null || _dashboardService$loc === void 0 ? void 0 : _dashboardService$loc.getUrl({
        dashboardId,
        viewMode: _public.ViewMode.EDIT,
        useHash: false
      }));
    }
  };
}

/**
 * Hook to use {@link DashboardService} in react components
 */
function useDashboardService() {
  const {
    services: {
      dashboard
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => dashboardServiceProvider(dashboard), [dashboard]);
}