"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewRouteFactory = exports.appRootRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _locator = require("../../../locator");
var _serverless_context = require("../../contexts/ml/serverless_context");
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_server_info = require("../../services/ml_server_info");
var _breadcrumbs = require("../breadcrumbs");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverviewPage = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../overview/overview_page'))));
const overviewRouteFactory = (navigateToPath, basePath) => ({
  id: 'overview',
  path: (0, _router.createPath)(_locator.ML_PAGES.OVERVIEW),
  title: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
    defaultMessage: 'Overview'
  }),
  enableDatePicker: true,
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
      defaultMessage: 'Overview'
    })
  }],
  'data-test-subj': 'mlPageOverview'
});
exports.overviewRouteFactory = overviewRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetMlInfo'], {
    getMlNodeCount: _ml_nodes_check.getMlNodeCount,
    loadMlServerInfo: _ml_server_info.loadMlServerInfo
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(OverviewPage, null)));
};
const appRootRouteFactory = (navigateToPath, basePath) => ({
  id: '',
  path: '/',
  render: () => /*#__PURE__*/_react.default.createElement(Page, null),
  breadcrumbs: []
});
exports.appRootRouteFactory = appRootRouteFactory;
const Page = () => {
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _serverless_context.useEnabledFeatures)();
  if (isADEnabled === false && isDFAEnabled === false && isNLPEnabled === true) {
    // if only NLP is enabled, redirect to the trained models page.
    // in the search serverless project, the overview page is blank, so we
    // need to redirect to the trained models page instead
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: (0, _router.createPath)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _router.createPath)(_locator.ML_PAGES.OVERVIEW)
  });
};