"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LangIdentInference = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _inference_base = require("../inference_base");
var _common = require("./common");
var _text_input = require("../text_input");
var _lang_ident_output = require("./lang_ident_output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LangIdentInference extends _inference_base.InferenceBase {
  constructor(trainedModelsApi, model, inputType, deploymentId) {
    super(trainedModelsApi, model, inputType, deploymentId);
    (0, _defineProperty2.default)(this, "inferenceType", 'classification');
    (0, _defineProperty2.default)(this, "inferenceTypeLabel", _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.langIdent.label', {
      defaultMessage: 'Language identification'
    }));
    (0, _defineProperty2.default)(this, "info", [_i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.langIdent.info1', {
      defaultMessage: 'Test how well the model identifies the language of your text. The model is more accurate with longer text.'
    })]);
    this.initialize();
  }
  async inferText() {
    try {
      return await this.runInfer(() => {
        return this.getInferenceConfig(this.getNumTopClassesConfig());
      }, (resp, inputText) => {
        return (0, _common.processResponse)(resp, this.model, inputText);
      });
    } catch (error) {
      this.setFinishedWithErrors(error);
      throw error;
    }
  }
  async inferIndex() {
    try {
      return await this.runPipelineSimulate(doc => {
        return {
          response: (0, _common.processInferenceResult)(doc._source[this.inferenceType], this.model),
          rawResponse: doc._source[this.inferenceType],
          inputText: doc._source[this.getInputField()]
        };
      });
    } catch (error) {
      this.setFinishedWithErrors(error);
      throw error;
    }
  }
  getProcessors() {
    return this.getBasicProcessors(this.getNumTopClassesConfig());
  }
  getInputComponent() {
    if (this.inputType === _inference_base.INPUT_TYPE.TEXT) {
      const placeholder = _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.langIdent.inputText', {
        defaultMessage: 'Enter a phrase to test'
      });
      return (0, _text_input.getGeneralInputComponent)(this, placeholder);
    } else {
      return null;
    }
  }
  getOutputComponent() {
    return (0, _lang_ident_output.getLangIdentOutputComponent)(this);
  }
}
exports.LangIdentInference = LangIdentInference;