"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelStateColor = exports.getModelDeploymentState = void 0;
var _react = _interopRequireDefault(require("react"));
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolves result model state based on the state of each deployment.
 *
 * If at least one deployment is in the STARTED state, the model state is STARTED.
 * Then if none of the deployments are in the STARTED state, but at least one is in the STARTING state, the model state is STARTING.
 * If all deployments are in the STOPPING state, the model state is STOPPING.
 */
const getModelDeploymentState = model => {
  var _model$stats, _model$stats$deployme, _model$stats2, _model$stats2$deploym, _model$stats3, _model$stats3$deploym, _model$stats4, _model$stats4$deploym;
  if (!((_model$stats = model.stats) !== null && _model$stats !== void 0 && (_model$stats$deployme = _model$stats.deployment_stats) !== null && _model$stats$deployme !== void 0 && _model$stats$deployme.length)) return;
  if ((_model$stats2 = model.stats) !== null && _model$stats2 !== void 0 && (_model$stats2$deploym = _model$stats2.deployment_stats) !== null && _model$stats2$deploym !== void 0 && _model$stats2$deploym.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED)) {
    return _mlTrainedModelsUtils.MODEL_STATE.STARTED;
  }
  if ((_model$stats3 = model.stats) !== null && _model$stats3 !== void 0 && (_model$stats3$deploym = _model$stats3.deployment_stats) !== null && _model$stats3$deploym !== void 0 && _model$stats3$deploym.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTING)) {
    return _mlTrainedModelsUtils.MODEL_STATE.STARTING;
  }
  if ((_model$stats4 = model.stats) !== null && _model$stats4 !== void 0 && (_model$stats4$deploym = _model$stats4.deployment_stats) !== null && _model$stats4$deploym !== void 0 && _model$stats4$deploym.every(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STOPPING)) {
    return _mlTrainedModelsUtils.MODEL_STATE.STOPPING;
  }
};
exports.getModelDeploymentState = getModelDeploymentState;
const getModelStateColor = state => {
  switch (state) {
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED:
      return {
        color: 'success',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadedName', {
          defaultMessage: 'Ready to deploy'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING:
      return {
        color: 'primary',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadingName', {
          defaultMessage: 'Downloading'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STARTED:
      return {
        color: '#E6F9F7',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.startedName', {
          defaultMessage: 'Deployed'
        }),
        get component() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: this.color
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
            color: 'success',
            textSize: "xs",
            css: {
              display: 'inline'
            }
          }, this.name));
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STARTING:
      return {
        color: 'success',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.startingName', {
          defaultMessage: 'Deploying'
        }),
        get component() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            alignItems: "center"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "s"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs"
          }, this.name)));
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STOPPING:
      return {
        color: 'accent',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.stoppingName', {
          defaultMessage: 'Stopping'
        }),
        get component() {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            alignItems: "center"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "s"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs"
          }, this.name)));
        }
      };
    case _mlTrainedModelsUtils.MODEL_STATE.NOT_DOWNLOADED:
    default:
      return null;
  }
};
exports.getModelStateColor = getModelStateColor;