"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
exports.useListItemsFormatter = useListItemsFormatter;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _inference_api_tab = require("./inference_api_tab");
var _pipelines = require("./pipelines");
var _allocated_models = require("../memory_usage/nodes_overview/allocated_models");
var _use_field_formatter = require("../contexts/kibana/use_field_formatter");
var _ml = require("../contexts/ml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JobMap = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../data_frame_analytics/pages/job_map')))).JobMap
}));
const useBadgeFormatter = () => {
  const xs = (0, _eui.useEuiPaddingSize)('xs');
  function badgeFormatter(items) {
    if (items.length === 0) return;
    return /*#__PURE__*/_react.default.createElement("div", null, items.map(item => /*#__PURE__*/_react.default.createElement("span", {
      css: {
        marginRight: xs
      },
      key: item
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      css: {
        marginRight: xs
      }
    }, item))));
  }
  return {
    badgeFormatter
  };
};
function useListItemsFormatter() {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  const {
    badgeFormatter
  } = useBadgeFormatter();
  const formatterDictionary = (0, _react.useMemo)(() => ({
    tags: badgeFormatter,
    roles: badgeFormatter,
    create_time: dateFormatter,
    timestamp: dateFormatter,
    model_size_bytes: bytesFormatter,
    required_native_memory_bytes: bytesFormatter
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return (0, _react.useCallback)(items => {
    return Object.entries(items).filter(([, value]) => (0, _mlIsDefined.isDefined)(value)).map(([title, value]) => {
      if (title in formatterDictionary) {
        return {
          title,
          description: formatterDictionary[title](value)
        };
      }
      return {
        title,
        description: typeof value === 'object' ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          fontSize: "s",
          paddingSize: "s",
          overflowHeight: 300,
          isCopyable: false
        }, JSON.stringify(value, null, 2)) : value.toString()
      };
    });
  }, [formatterDictionary]);
}
const ExpandedRow = ({
  item
}) => {
  const formatToListItems = useListItemsFormatter();
  const {
    showLicenseInfo,
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const {
    inference_config: inferenceConfig,
    stats,
    metadata,
    tags,
    version,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    estimated_operations,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    estimated_heap_memory_usage_bytes,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    default_field_map,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    license_level,
    pipelines,
    description
  } = item;
  const inferenceStats = (0, _react.useMemo)(() => {
    if (!(0, _mlIsPopulatedObject.isPopulatedObject)(stats.inference_stats) || item.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH) return;
    return stats.inference_stats;
  }, [stats.inference_stats, item.model_type]);
  const {
    analytics_config: analyticsConfig,
    ...restMetaData
  } = metadata !== null && metadata !== void 0 ? metadata : {};
  const details = (0, _react.useMemo)(() => {
    return {
      description,
      tags,
      version,
      estimated_operations,
      estimated_heap_memory_usage_bytes,
      default_field_map,
      ...(showLicenseInfo ? {
        license_level
      } : {})
    };
  }, [description, tags, version, estimated_operations, estimated_heap_memory_usage_bytes, default_field_map, showLicenseInfo, license_level]);
  const deploymentStatItems = (0, _react.useMemo)(() => {
    const deploymentStats = stats.deployment_stats;
    const modelSizeStats = stats.model_size_stats;
    if (!deploymentStats || !modelSizeStats) return [];
    return deploymentStats.flatMap(perDeploymentStat => {
      // A deployment can be in a starting state and not allocated to any node yet.
      if (perDeploymentStat.nodes.length < 1) {
        return [{
          key: `${perDeploymentStat.deployment_id}_no_node`,
          ...perDeploymentStat,
          ...modelSizeStats,
          node: {
            name: '-',
            average_inference_time_ms: 0,
            inference_count: 0,
            routing_state: {
              routing_state: perDeploymentStat.state,
              reason: perDeploymentStat.reason
            },
            last_access: 0,
            number_of_pending_requests: 0,
            start_time: 0,
            throughput_last_minute: 0,
            number_of_allocations: 0,
            threads_per_allocation: 0,
            error_count: 0
          }
        }];
      }
      return perDeploymentStat.nodes.map(n => {
        const nodeName = Object.values(n.node)[0].name;
        return {
          key: `${perDeploymentStat.deployment_id}_${nodeName}`,
          ...perDeploymentStat,
          ...modelSizeStats,
          node: {
            ...(0, _lodash.pick)(n, ['average_inference_time_ms', 'inference_count', 'routing_state', 'last_access', 'number_of_pending_requests', 'start_time', 'throughput_last_minute', 'number_of_allocations', 'threads_per_allocation', 'error_count']),
            name: nodeName
          }
        };
      });
    });
  }, [stats]);
  const hideColumns = (0, _react.useMemo)(() => {
    return showNodeInfo ? ['model_id'] : ['model_id', 'node_name'];
  }, [showNodeInfo]);
  const tabs = (0, _react.useMemo)(() => {
    return [{
      id: 'details',
      'data-test-subj': 'mlTrainedModelDetails',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.detailsTabLabel",
        defaultMessage: "Details"
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelDetailsContent'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 2,
        gutterSize: 'm'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.detailsTitle",
        defaultMessage: "Details"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(details)
      }))), (0, _mlIsPopulatedObject.isPopulatedObject)(restMetaData) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.metadataTitle",
        defaultMessage: "Metadata"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(restMetaData)
      }))) : null))
    }, ...(inferenceConfig ? [{
      id: 'config',
      'data-test-subj': 'mlTrainedModelInferenceConfig',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.configTabLabel",
        defaultMessage: "Config"
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelInferenceConfigContent'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 2,
        gutterSize: 'm'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceConfigTitle",
        defaultMessage: "Inference configuration"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(inferenceConfig[Object.keys(inferenceConfig)[0]])
      }))), analyticsConfig && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.analyticsConfigTitle",
        defaultMessage: "Analytics configuration"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(analyticsConfig)
      })))))
    }] : []), ...((0, _mlIsPopulatedObject.isPopulatedObject)((0, _lodash.omit)(stats, ['pipeline_count', 'ingest'])) ? [{
      id: 'stats',
      'data-test-subj': 'mlTrainedModelStats',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.statsTabLabel",
        defaultMessage: "Stats"
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelStatsContent'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), !!(deploymentStatItems !== null && deploymentStatItems !== void 0 && deploymentStatItems.length) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.deploymentStatsTitle",
        defaultMessage: "Deployment stats"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_allocated_models.AllocatedModels, {
        models: deploymentStatItems,
        hideColumns: hideColumns
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 2,
        gutterSize: 'm'
      }, inferenceStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceStatsTitle",
        defaultMessage: "Inference stats"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(inferenceStats)
      }))) : null, (0, _mlIsPopulatedObject.isPopulatedObject)(stats.model_size_stats) && !(0, _mlIsPopulatedObject.isPopulatedObject)(inferenceStats) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs'
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.modelSizeStatsTitle",
        defaultMessage: "Model size stats"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(stats.model_size_stats)
      }))) : null))
    }] : []), ...((0, _mlIsPopulatedObject.isPopulatedObject)(pipelines) && Object.keys(pipelines).length > 0 || stats.ingest ? [{
      id: 'pipelines',
      'data-test-subj': 'mlTrainedModelPipelines',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'center',
        gutterSize: 'xs'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.pipelinesTabLabel",
        defaultMessage: "Pipelines"
      })), (0, _mlIsPopulatedObject.isPopulatedObject)(pipelines) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, null, Object.keys(pipelines).length)) : null),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelPipelinesContent'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), /*#__PURE__*/_react.default.createElement(_pipelines.ModelPipelines, {
        pipelines: pipelines,
        ingestStats: stats.ingest
      }))
    }] : []), ...(Array.isArray(item.inference_apis) && item.inference_apis.length > 0 ? [{
      id: 'inferenceApi',
      'data-test-subj': 'inferenceAPIs',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'center',
        gutterSize: 'xs'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceAPIsTabLabel",
        defaultMessage: "Inference services"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, null, item.inference_apis.length))),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelInferenceAPIContent'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), /*#__PURE__*/_react.default.createElement(_inference_api_tab.InferenceApi, {
        inferenceApis: item.inference_apis
      }))
    }] : []), {
      id: 'models_map',
      'data-test-subj': 'mlTrainedModelMap',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.modelsMapLabel",
        defaultMessage: "Models map"
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelMapContent'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: {
          height: 300
        }
      }, /*#__PURE__*/_react.default.createElement(JobMap, {
        analyticsId: undefined,
        modelId: item.model_id,
        forceRefresh: false,
        defaultHeight: 200
      })))
    }];
  }, [analyticsConfig, deploymentStatItems, details, formatToListItems, inferenceConfig, inferenceStats, pipelines, restMetaData, stats, item.model_id, item.inference_apis, hideColumns]);
  const initialSelectedTab = item.state === 'started' ? tabs.find(t => t.id === 'stats') : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    css: {
      width: '100%'
    },
    tabs: tabs,
    initialSelectedTab: initialSelectedTab,
    autoFocus: "selected",
    "data-test-subj": 'mlTrainedModelRowDetails'
  });
};
exports.ExpandedRow = ExpandedRow;