"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocsLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocsLink = ({
  currentTabId
}) => {
  const {
    services: {
      docLinks: {
        links: {
          ml
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  let href = ml.anomalyDetectionJobs;
  let linkLabel = _i18n.i18n.translate('xpack.ml.management.jobsList.anomalyDetectionDocsLabel', {
    defaultMessage: 'Anomaly detection jobs docs'
  });
  if (currentTabId === 'data-frame-analytics') {
    href = ml.dataFrameAnalytics;
    linkLabel = _i18n.i18n.translate('xpack.ml.management.jobsList.analyticsDocsLabel', {
      defaultMessage: 'Analytics jobs docs'
    });
  } else if (currentTabId === 'trained-model') {
    href = ml.trainedModels;
    linkLabel = _i18n.i18n.translate('xpack.ml.management.jobsList.trainedModelsDocsLabel', {
      defaultMessage: 'Trained models docs'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: href,
    target: "_blank",
    iconType: "help",
    "data-test-subj": "mlDocumentationLink"
  }, linkLabel);
};
exports.DocsLink = DocsLink;