"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobListDatafeedChartFlyout = exports.DatafeedChartFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _states = require("../../../../../../common/constants/states");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _kibana = require("../../../../contexts/kibana");
var _revert_model_snapshot_flyout = require("../../../../components/model_snapshots/revert_model_snapshot_flyout");
var _job_messages_pane = require("../job_details/job_messages_pane");
var _edit_query_delay = require("./edit_query_delay");
var _constants = require("./constants");
var _utils = require("../utils");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _fill_missing_chart_data = require("./fill_missing_chart_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dateFormatter = (0, _charts.timeFormatter)('MM-DD HH:mm:ss');
const MAX_CHART_POINTS = 480;
const revertSnapshotMessage = _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.revertSnapshotMessage', {
  defaultMessage: 'Click to revert to this model snapshot.'
});
const notAvailableMessage = _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.notAvailableMessage', {
  defaultMessage: 'N/A'
});
function setLineAnnotationHeader(lineDatum) {
  lineDatum.header = dateFormatter(lineDatum.dataValue);
  return lineDatum;
}
const customTooltip = ({
  details,
  datum
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "echAnnotation__tooltip"
}, /*#__PURE__*/_react.default.createElement("p", {
  className: "echAnnotation__header"
}, dateFormatter(datum.header)), /*#__PURE__*/_react.default.createElement("div", {
  className: "echAnnotation__details"
}, details));
const DatafeedChartFlyout = ({
  jobId,
  end,
  onClose,
  onModelSnapshotAnnotationClick
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const [data, setData] = (0, _react.useState)({
    datafeedConfig: undefined,
    bucketSpan: undefined,
    isInitialized: false,
    modelSnapshotData: []
  });
  const [endDate, setEndDate] = (0, _react.useState)((0, _moment.default)(end));
  const [isLoadingChartData, setIsLoadingChartData] = (0, _react.useState)(false);
  const [bucketData, setBucketData] = (0, _react.useState)([]);
  const [annotationData, setAnnotationData] = (0, _react.useState)({
    rect: [],
    line: []
  });
  const [modelSnapshotDataForTimeRange, setModelSnapshotDataForTimeRange] = (0, _react.useState)([]);
  const [messageData, setMessageData] = (0, _react.useState)([]);
  const [sourceData, setSourceData] = (0, _react.useState)([]);
  const [showAnnotations, setShowAnnotations] = (0, _react.useState)(true);
  const [showModelSnapshots, setShowModelSnapshots] = (0, _react.useState)(false);
  const [range, setRange] = (0, _react.useState)();
  const canUpdateDatafeed = (0, _react.useMemo)(() => (0, _check_capabilities.checkPermission)('canUpdateDatafeed'), []);
  const canCreateJob = (0, _react.useMemo)(() => (0, _check_capabilities.checkPermission)('canCreateJob'), []);
  const canStartStopDatafeed = (0, _react.useMemo)(() => (0, _check_capabilities.checkPermission)('canStartStopDatafeed'), []);
  const {
    getModelSnapshots,
    results: {
      getDatafeedResultChartData
    }
  } = (0, _kibana.useMlApi)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  const handleChange = date => setEndDate(date);
  const handleEndDateChange = direction => {
    if (data.bucketSpan === undefined) return;
    const newEndDate = endDate.clone();
    const unitMatch = data.bucketSpan.match(/[d | h| m | s]/g);
    const unit = unitMatch[0];
    const count = Number(data.bucketSpan.replace(/[^0-9]/g, ''));
    if (direction === _constants.CHART_DIRECTION.FORWARD) {
      newEndDate.add(MAX_CHART_POINTS * count, unit);
    } else {
      newEndDate.subtract(MAX_CHART_POINTS * count, unit);
    }
    setEndDate(newEndDate);
  };
  const getChartData = (0, _react.useCallback)(async () => {
    if (data.bucketSpan === undefined) return;
    const endTimestamp = (0, _moment.default)(endDate).valueOf();
    const unitMatch = data.bucketSpan.match(/[d | h| m | s]/g);
    const unit = unitMatch[0];
    const count = Number(data.bucketSpan.replace(/[^0-9]/g, ''));
    // STARTTIME = ENDTIME - (BucketSpan * MAX_CHART_POINTS)
    const startMoment = endDate.clone().subtract(MAX_CHART_POINTS * count, unit);
    const startTimestamp = (0, _moment.default)(startMoment).valueOf();
    setRange({
      start: String(startTimestamp),
      end: String(endTimestamp)
    });
    try {
      const chartData = await getDatafeedResultChartData(jobId, startTimestamp, endTimestamp);
      let chartSourceData = chartData.datafeedResults;
      let chartBucketData = chartData.bucketResults;
      if (chartSourceData.length !== chartBucketData.length) {
        if (chartSourceData.length > chartBucketData.length) {
          chartBucketData = (0, _fill_missing_chart_data.fillMissingChartData)(chartBucketData, chartSourceData);
        } else {
          chartSourceData = (0, _fill_missing_chart_data.fillMissingChartData)(chartSourceData, chartBucketData);
        }
      }
      setSourceData(chartSourceData);
      setBucketData(chartBucketData);
      setAnnotationData({
        rect: chartData.annotationResultsRect,
        line: chartData.annotationResultsLine.map(setLineAnnotationHeader)
      });
      setModelSnapshotDataForTimeRange(data.modelSnapshotData.filter(datum => datum.dataValue >= startTimestamp && datum.dataValue <= endTimestamp));
    } catch (error) {
      const title = _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.errorToastTitle', {
        defaultMessage: 'Error fetching data'
      });
      displayErrorToast(error, title);
    }
    setIsLoadingChartData(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [endDate, data.bucketSpan]);
  const getJobAndSnapshotData = (0, _react.useCallback)(async () => {
    try {
      var _modelSnapshotsResp$m;
      const job = await (0, _utils.loadFullJob)(mlApi, jobId);
      const modelSnapshotResultsLine = [];
      const modelSnapshotsResp = await getModelSnapshots(jobId);
      const modelSnapshots = (_modelSnapshotsResp$m = modelSnapshotsResp.model_snapshots) !== null && _modelSnapshotsResp$m !== void 0 ? _modelSnapshotsResp$m : [];
      modelSnapshots.forEach(modelSnapshot => {
        const timestamp = Number(modelSnapshot.latest_record_time_stamp);
        modelSnapshotResultsLine.push({
          dataValue: timestamp,
          details: `${modelSnapshot.description}. ${canCreateJob && canStartStopDatafeed ? revertSnapshotMessage : ''}`,
          modelSnapshot
        });
      });
      setData({
        datafeedConfig: job.datafeed_config,
        // @ts-expect-error bucket_span is of type estypes.Duration
        bucketSpan: job.analysis_config.bucket_span,
        isInitialized: true,
        modelSnapshotData: modelSnapshotResultsLine.map(setLineAnnotationHeader)
      });
    } catch (error) {
      displayErrorToast(error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  (0, _react.useEffect)(function loadInitialData() {
    getJobAndSnapshotData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function loadChartData() {
    if (data.bucketSpan !== undefined) {
      setIsLoadingChartData(true);
      getChartData();
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [endDate, data.bucketSpan]);
  const {
    datafeedConfig,
    bucketSpan,
    isInitialized
  } = data;
  const checkboxIdAnnotation = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const checkboxIdModelSnapshot = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const hasOnlyEmptyValues = (0, _react.useMemo)(() => !bucketData.some(datum => datum[1] !== null && datum[1] !== 0) && !sourceData.some(datum => datum[1] !== null && datum[1] !== 0), [bucketData, sourceData]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    ownFocus: true,
    onClose: onClose,
    "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.datafeedChartFlyoutAriaLabel', {
      defaultMessage: 'Datafeed chart flyout'
    }),
    "data-test-subj": "mlAnnotationsViewDatafeedFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "mlAnnotationsViewDatafeedFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "primary",
    type: "help",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.headerTooltipContent",
      defaultMessage: "Charts the event counts of the job and the source data to identify where missing data has occurred."
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.header",
    defaultMessage: "Datafeed chart for {jobId}",
    values: {
      jobId
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      padding: '10px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.chartIntervalEndTime', {
      defaultMessage: 'Chart interval end time'
    }),
    showTimeSelect: true,
    selected: endDate,
    onChange: handleChange,
    popoverPlacement: "leftUp"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isLoadingChartData || isInitialized === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l"
  }) : null, !isLoadingChartData && isInitialized && datafeedConfig !== undefined && bucketSpan ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_edit_query_delay.EditQueryDelay, {
    datafeedId: datafeedConfig.datafeed_id,
    queryDelay: datafeedConfig.query_delay,
    isEnabled: datafeedConfig.state === _states.DATAFEED_STATE.STOPPED && canUpdateDatafeed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkboxIdAnnotation,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.showAnnotationsCheckboxLabel",
      defaultMessage: "Show annotations"
    })),
    checked: showAnnotations,
    onChange: () => setShowAnnotations(!showAnnotations)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkboxIdModelSnapshot,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.showModelSnapshotsCheckboxLabel",
      defaultMessage: "Show model snapshots"
    })),
    checked: showModelSnapshots,
    onChange: () => setShowModelSnapshots(!showModelSnapshots)
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.chartLeftArrowTooltip",
      defaultMessage: "Previous time window"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.chartIntervalLeftArrow', {
      defaultMessage: 'Previous time window'
    }),
    color: "primary",
    onClick: () => {
      handleEndDateChange(_constants.CHART_DIRECTION.BACK);
    },
    iconType: "arrowLeft"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnnotationsViewDatafeedFlyoutChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: _constants.CHART_SIZE
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.VerticalCursor,
    showNullValues: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: _charts.Position.Bottom,
    onAnnotationClick: annotations => {
      var _annotations$lines;
      // If it's not a line annotation or if it's not a model snapshot annotation then do nothing
      if (!(canCreateJob && canStartStopDatafeed) || ((_annotations$lines = annotations.lines) === null || _annotations$lines === void 0 ? void 0 : _annotations$lines.length) === 0 || annotations.lines && !annotations.lines[0].id.includes('Model snapshots')) return;
      onModelSnapshotAnnotationClick(
      // @ts-expect-error property 'modelSnapshot' does not exist on type
      annotations.lines[0].datum.modelSnapshot);
    },
    theme: {
      lineSeriesStyle: {
        point: {
          visible: 'never'
        }
      }
    }
    // TODO connect to charts.theme service see src/plugins/charts/public/services/theme/README.md
    ,
    baseTheme: _charts.LEGACY_LIGHT_THEME,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    title: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.xAxisTitle', {
      defaultMessage: 'Bucket span ({bucketSpan})',
      values: {
        bucketSpan
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    title: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.yAxisTitle', {
      defaultMessage: 'Count'
    }),
    position: _charts.Position.Left,
    domain: hasOnlyEmptyValues ? {
      min: 0,
      max: 10
    } : undefined,
    tickFormat: d => d === null ? notAvailableMessage : String(d)
  }), showAnnotations ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.annotationLineSeriesId', {
      defaultMessage: 'Annotations line result'
    }),
    key: "annotation-results-line",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: annotationData.line,
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "annotation"
    }),
    markerPosition: _charts.Position.Top,
    style: {
      line: {
        strokeWidth: 3,
        stroke: euiTheme.euiColorDangerText,
        opacity: 0.5
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    key: "annotation-results-rect",
    customTooltip: customTooltip,
    dataValues: annotationData.rect,
    id: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.annotationRectSeriesId', {
      defaultMessage: 'Annotations rectangle result'
    }),
    style: {
      fill: euiTheme.euiColorDangerText
    }
  })) : null, showModelSnapshots ? /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.modelSnapshotsLineSeriesId', {
      defaultMessage: 'Model snapshots'
    }),
    key: "model-snapshots-results-line",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: modelSnapshotDataForTimeRange,
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "asterisk"
    }),
    markerPosition: _charts.Position.Top,
    style: {
      line: {
        strokeWidth: 3,
        stroke: euiTheme.euiColorVis1,
        opacity: 0.5
      }
    }
  }) : null, messageData.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.messageLineAnnotationId', {
      defaultMessage: 'Job messages line result'
    }),
    key: "messages-results-line",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: messageData,
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "tableDensityNormal"
    }),
    markerPosition: _charts.Position.Top,
    style: {
      line: {
        strokeWidth: 3,
        stroke: euiTheme.euiColorAccent,
        opacity: 0.5
      }
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    key: 'source-results',
    color: euiTheme.euiColorPrimary,
    id: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.sourceSeriesId', {
      defaultMessage: 'Source indices document count'
    }),
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 0,
    yAccessors: [1],
    data: sourceData,
    curve: _charts.CurveType.LINEAR
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    key: 'job-results',
    color: euiTheme.euiColorAccentText,
    id: _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.bucketSeriesId', {
      defaultMessage: 'Datafeed document count'
    }),
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 0,
    yAccessors: [1],
    data: bucketData,
    curve: _charts.CurveType.LINEAR
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.chartRightArrowTooltip",
      defaultMessage: "Next time window"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.chartIntervalRightArrow', {
      defaultMessage: 'Next time window'
    }),
    color: "primary",
    onClick: () => {
      handleEndDateChange(_constants.CHART_DIRECTION.FORWARD);
    },
    iconType: "arrowRight"
  }))))), range !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.messagesTableTitle",
    defaultMessage: "Job messages"
  }))), /*#__PURE__*/_react.default.createElement(_job_messages_pane.JobMessagesPane, (0, _extends2.default)({
    jobId: jobId
  }, range, {
    actionHandler: function toggleChartMessage(message) {
      if (messageData.length > 0 && messageData[0].dataValue === message.timestamp) {
        setMessageData([]);
      } else {
        const datum = setLineAnnotationHeader({
          dataValue: message.timestamp,
          details: message.message
        });
        setMessageData([datum]);
      }
    }
  })))) : null) : null)));
};
exports.DatafeedChartFlyout = DatafeedChartFlyout;
/**
 * Component to wire the datafeed chart flyout with the Job list view.
 * @param setShowFunction function to show the flyout
 * @param unsetShowFunction function called when flyout is closed
 * @param refreshJobs function to refresh the jobs list
 * @constructor
 */
const JobListDatafeedChartFlyout = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const [job, setJob] = (0, _react.useState)();
  const [jobWithStats, setJobWithStats] = (0, _react.useState)();
  const [isRevertModelSnapshotFlyoutVisible, setIsRevertModelSnapshotFlyoutVisible] = (0, _react.useState)(false);
  const [snapshot, setSnapshot] = (0, _react.useState)(null);
  const showFlyoutCallback = (0, _react.useCallback)(jobUpdate => {
    setJob(jobUpdate);
    setIsVisible(true);
  }, []);
  const showRevertModelSnapshot = (0, _react.useCallback)(async () => {
    // Need to load the full job with stats, as the model snapshot
    // flyout needs the timestamp of the last result.
    const fullJob = await (0, _utils.loadFullJob)(mlApi, job.id);
    setJobWithStats(fullJob);
    setIsRevertModelSnapshotFlyoutVisible(true);
    // exclude mlApi from deps
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [job]);
  (0, _react.useEffect)(() => {
    setShowFunction(showFlyoutCallback);
    return () => {
      unsetShowFunction();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (isVisible === true && job !== undefined) {
    return /*#__PURE__*/_react.default.createElement(DatafeedChartFlyout, {
      onClose: () => setIsVisible(false),
      onModelSnapshotAnnotationClick: modelSnapshot => {
        setIsVisible(false);
        setSnapshot(modelSnapshot);
        showRevertModelSnapshot();
      },
      end: job.latestResultsTimestampMs || Date.now(),
      jobId: job.id
    });
  }
  if (isRevertModelSnapshotFlyoutVisible === true && jobWithStats !== undefined && snapshot !== null) {
    return /*#__PURE__*/_react.default.createElement(_revert_model_snapshot_flyout.RevertModelSnapshotFlyout, {
      snapshot: snapshot,
      snapshots: [snapshot],
      job: jobWithStats,
      closeFlyout: () => {
        setIsRevertModelSnapshotFlyoutVisible(false);
      },
      refresh: refreshJobs
    });
  }
  return null;
};
exports.JobListDatafeedChartFlyout = JobListDatafeedChartFlyout;