"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobSelectionChange = void 0;
var _get_index_pattern = require("./get_index_pattern");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobSelectionChange = (state, payload) => {
  const {
    selectedJobs,
    noInfluencersConfigured
  } = payload;
  const stateUpdate = {
    ...state,
    noInfluencersConfigured,
    selectedJobs
  };

  // clear filter if selected jobs have no influencers
  if (stateUpdate.noInfluencersConfigured === true) {
    const noFilterState = {
      filterActive: false,
      filteredFields: [],
      influencersFilterQuery: undefined,
      maskAll: false,
      queryString: '',
      tableQueryString: ''
    };
    Object.assign(stateUpdate, noFilterState);
  } else {
    // indexPattern will not be used if there are no influencers so set up can be skipped
    // indexPattern is passed to KqlFilterBar which is only shown if (noInfluencersConfigured === false)
    stateUpdate.indexPattern = (0, _get_index_pattern.getIndexPattern)(selectedJobs);
  }
  stateUpdate.loading = true;
  return stateUpdate;
};
exports.jobSelectionChange = jobSelectionChange;