"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartLabelBadge = ExplorerChartLabelBadge;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExplorerChartLabelBadge({
  entity
}) {
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "ml-explorer-chart-label-badge"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    className: "ml-reset-font-weight"
  }, entity.fieldName, " ", /*#__PURE__*/_react.default.createElement("strong", null, entity.fieldValue)));
}
ExplorerChartLabelBadge.propTypes = {
  entity: _propTypes.default.shape({
    fieldName: _propTypes.default.string.isRequired,
    fieldValue: _propTypes.default.string.isRequired
  })
};