"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyChartsStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _state_service = require("../services/state_service");
var _explorer_charts_container_service = require("./explorer_charts/explorer_charts_container_service");
var _explorer_utils = require("./explorer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnomalyChartsStateService extends _state_service.StateService {
  constructor(_anomalyExplorerCommonStateService, _anomalyTimelineStateServices, _anomalyExplorerChartsService, _anomalyExplorerUrlStateService, _tableSeverityState) {
    super();
    (0, _defineProperty2.default)(this, "_isChartsDataLoading$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "_chartsData$", new _rxjs.BehaviorSubject((0, _explorer_charts_container_service.getDefaultChartsData)()));
    (0, _defineProperty2.default)(this, "_showCharts$", new _rxjs.BehaviorSubject(true));
    this._anomalyExplorerCommonStateService = _anomalyExplorerCommonStateService;
    this._anomalyTimelineStateServices = _anomalyTimelineStateServices;
    this._anomalyExplorerChartsService = _anomalyExplorerChartsService;
    this._anomalyExplorerUrlStateService = _anomalyExplorerUrlStateService;
    this._tableSeverityState = _tableSeverityState;
    this._init();
  }
  _initSubscriptions() {
    const subscription = new _rxjs.Subscription();
    subscription.add(this._anomalyExplorerUrlStateService.getPageUrlState$().pipe((0, _rxjs.map)(urlState => {
      var _urlState$mlShowChart;
      return (_urlState$mlShowChart = urlState === null || urlState === void 0 ? void 0 : urlState.mlShowCharts) !== null && _urlState$mlShowChart !== void 0 ? _urlState$mlShowChart : true;
    }), (0, _rxjs.distinctUntilChanged)()).subscribe(this._showCharts$));
    subscription.add(this.initChartDataSubscription());
    return subscription;
  }
  initChartDataSubscription() {
    return (0, _rxjs.combineLatest)([this._anomalyExplorerCommonStateService.getSelectedJobs$(), this._anomalyExplorerCommonStateService.getInfluencerFilterQuery$(), this._anomalyTimelineStateServices.getContainerWidth$().pipe((0, _rxjs.skipWhile)(v => v === 0)), this._anomalyTimelineStateServices.getSelectedCells$(), this._anomalyTimelineStateServices.getViewBySwimlaneFieldName$(), this._tableSeverityState.getPageUrlState$()]).pipe((0, _rxjs.switchMap)(([selectedJobs, influencerFilterQuery, containerWidth, selectedCells, viewBySwimlaneFieldName, severityState]) => {
      if (!selectedCells) return (0, _rxjs.of)((0, _explorer_charts_container_service.getDefaultChartsData)());
      const jobIds = (0, _explorer_utils.getSelectionJobIds)(selectedCells, selectedJobs);
      this._isChartsDataLoading$.next(true);
      const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, viewBySwimlaneFieldName);
      return this._anomalyExplorerChartsService.getAnomalyData$(jobIds, containerWidth, (selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.times[0]) * 1000, (selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.times[1]) * 1000, influencerFilterQuery, selectionInfluencers, severityState.val, 6);
    })).subscribe(v => {
      this._chartsData$.next(v);
      this._isChartsDataLoading$.next(false);
    });
  }
  getChartsData$() {
    return this._chartsData$.asObservable();
  }
  getChartsData() {
    return this._chartsData$.getValue();
  }
  getShowCharts$() {
    return this._showCharts$.asObservable();
  }
  getShowCharts() {
    return this._showCharts$.getValue();
  }
  setShowCharts(update) {
    this._anomalyExplorerUrlStateService.updateUrlState({
      mlShowCharts: update
    });
  }
}
exports.AnomalyChartsStateService = AnomalyChartsStateService;