"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobSelectionActionCreator = jobSelectionActionCreator;
var _rxjs = require("rxjs");
var _explorer_constants = require("../explorer_constants");
var _explorer_utils = require("../explorer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function jobSelectionActionCreator(mlJobService, mlFieldFormatService, selectedJobIds) {
  return (0, _rxjs.from)(mlFieldFormatService.populateFormats(selectedJobIds)).pipe((0, _rxjs.map)(resp => {
    if (resp.error) {
      return null;
    }
    const jobs = (0, _explorer_utils.createJobs)(mlJobService.jobs).map(job => {
      job.selected = selectedJobIds.some(id => job.id === id);
      return job;
    });
    const selectedJobs = jobs.filter(job => job.selected);
    const noInfluencersConfigured = (0, _explorer_utils.getInfluencers)(mlJobService, selectedJobs).length === 0;
    return {
      type: _explorer_constants.EXPLORER_ACTION.JOB_SELECTION_CHANGE,
      payload: {
        loading: false,
        selectedJobs,
        noInfluencersConfigured
      }
    };
  }));
}