"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneActionNameText = exports.CloneActionName = void 0;
exports.extractCloningConfig = extractCloningConfig;
exports.isAdvancedConfig = isAdvancedConfig;
exports.useNavigateToWizardWithClonedJob = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana = require("../../../../../contexts/kibana");
var _use_create_analytics_form = require("../../hooks/use_create_analytics_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isPropDefinition(a) {
  return Object.hasOwn(a, 'optional');
}
/**
 * Provides a config definition.
 */
const getAnalyticsJobMeta = config => ({
  allow_lazy_start: {
    optional: true,
    defaultValue: false
  },
  description: {
    optional: true,
    formKey: 'description'
  },
  _meta: {
    optional: true,
    defaultValue: config._meta
  },
  analysis: {
    ...((0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(config.analysis) ? {
      classification: {
        dependent_variable: {
          optional: false,
          formKey: 'dependentVariable'
        },
        training_percent: {
          optional: true,
          formKey: 'trainingPercent'
        },
        eta: {
          optional: true,
          formKey: 'eta'
        },
        feature_bag_fraction: {
          optional: true,
          formKey: 'featureBagFraction'
        },
        max_trees: {
          optional: true,
          formKey: 'maxTrees'
        },
        gamma: {
          optional: true,
          formKey: 'gamma'
        },
        lambda: {
          optional: true,
          formKey: 'lambda'
        },
        num_top_classes: {
          optional: true,
          defaultValue: 2,
          formKey: 'numTopClasses'
        },
        prediction_field_name: {
          optional: true,
          defaultValue: `${config.analysis.classification.dependent_variable}_prediction`,
          formKey: 'predictionFieldName'
        },
        randomize_seed: {
          optional: true,
          // By default it is randomly generated
          ignore: true,
          formKey: 'randomizeSeed'
        },
        num_top_feature_importance_values: {
          optional: true,
          defaultValue: _use_create_analytics_form.DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES,
          formKey: 'numTopFeatureImportanceValues'
        },
        class_assignment_objective: {
          optional: true,
          defaultValue: 'maximize_minimum_recall'
        },
        early_stopping_enabled: {
          optional: true,
          ignore: true
        },
        alpha: {
          optional: true,
          formKey: 'alpha'
        },
        downsample_factor: {
          optional: true,
          formKey: 'downsampleFactor'
        },
        eta_growth_rate_per_tree: {
          optional: true,
          formKey: 'etaGrowthRatePerTree'
        },
        feature_processors: {
          optional: true
        },
        max_optimization_rounds_per_hyperparameter: {
          optional: true,
          formKey: 'maxOptimizationRoundsPerHyperparameter'
        },
        soft_tree_depth_limit: {
          optional: true,
          formKey: 'softTreeDepthLimit'
        },
        soft_tree_depth_tolerance: {
          optional: true,
          formKey: 'softTreeDepthTolerance'
        }
      }
    } : {}),
    ...((0, _mlDataFrameAnalyticsUtils.isOutlierAnalysis)(config.analysis) ? {
      outlier_detection: {
        standardization_enabled: {
          defaultValue: true,
          optional: true,
          formKey: 'standardizationEnabled'
        },
        compute_feature_influence: {
          defaultValue: true,
          optional: true,
          formKey: 'computeFeatureInfluence'
        },
        outlier_fraction: {
          defaultValue: 0.05,
          optional: true,
          formKey: 'outlierFraction'
        },
        feature_influence_threshold: {
          optional: true,
          formKey: 'featureInfluenceThreshold'
        },
        method: {
          optional: true,
          formKey: 'method'
        },
        n_neighbors: {
          optional: true,
          formKey: 'nNeighbors'
        }
      }
    } : {}),
    ...((0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(config.analysis) ? {
      regression: {
        dependent_variable: {
          optional: false,
          formKey: 'dependentVariable'
        },
        training_percent: {
          optional: true,
          formKey: 'trainingPercent'
        },
        eta: {
          optional: true,
          formKey: 'eta'
        },
        feature_bag_fraction: {
          optional: true,
          formKey: 'featureBagFraction'
        },
        max_trees: {
          optional: true,
          formKey: 'maxTrees'
        },
        gamma: {
          optional: true,
          formKey: 'gamma'
        },
        lambda: {
          optional: true,
          formKey: 'lambda'
        },
        prediction_field_name: {
          optional: true,
          defaultValue: `${config.analysis.regression.dependent_variable}_prediction`,
          formKey: 'predictionFieldName'
        },
        num_top_feature_importance_values: {
          optional: true,
          defaultValue: _use_create_analytics_form.DEFAULT_NUM_TOP_FEATURE_IMPORTANCE_VALUES,
          formKey: 'numTopFeatureImportanceValues'
        },
        randomize_seed: {
          optional: true,
          // By default it is randomly generated
          ignore: true,
          formKey: 'randomizeSeed'
        },
        loss_function: {
          optional: true,
          defaultValue: 'mse'
        },
        loss_function_parameter: {
          optional: true
        },
        feature_processors: {
          optional: true
        },
        early_stopping_enabled: {
          optional: true,
          ignore: true
        },
        alpha: {
          optional: true,
          formKey: 'alpha'
        },
        downsample_factor: {
          optional: true,
          formKey: 'downsampleFactor'
        },
        eta_growth_rate_per_tree: {
          optional: true,
          formKey: 'etaGrowthRatePerTree'
        },
        max_optimization_rounds_per_hyperparameter: {
          optional: true,
          formKey: 'maxOptimizationRoundsPerHyperparameter'
        },
        soft_tree_depth_limit: {
          optional: true,
          formKey: 'softTreeDepthLimit'
        },
        soft_tree_depth_tolerance: {
          optional: true,
          formKey: 'softTreeDepthTolerance'
        }
      }
    } : {})
  },
  analyzed_fields: {
    excludes: {
      optional: true,
      defaultValue: []
    },
    includes: {
      optional: true,
      formKey: 'includes',
      defaultValue: []
    }
  },
  source: {
    index: {
      formKey: 'sourceIndex',
      optional: false
    },
    query: {
      optional: true,
      defaultValue: {
        match_all: {}
      }
    },
    runtime_mappings: {
      optional: true,
      formKey: 'runtimeMappings',
      defaultValue: undefined
    },
    _source: {
      optional: true
    }
  },
  dest: {
    index: {
      optional: false,
      formKey: 'destinationIndex'
    },
    results_field: {
      optional: true,
      formKey: 'resultsField',
      defaultValue: _mlDataFrameAnalyticsUtils.DEFAULT_RESULTS_FIELD
    }
  },
  model_memory_limit: {
    optional: true,
    formKey: 'modelMemoryLimit'
  },
  max_num_threads: {
    optional: true,
    formKey: 'maxNumThreads'
  }
});

/**
 * Detects if analytics job configuration were created with
 * the advanced editor and not supported by the regular form.
 */

function isAdvancedConfig(config, meta = getAnalyticsJobMeta(config)) {
  for (const configKey in config) {
    if (Object.hasOwn(config, configKey)) {
      const fieldConfig = config[configKey];
      const fieldMeta = meta[configKey];
      if (!fieldMeta) {
        // eslint-disable-next-line no-console
        console.info(`Property "${configKey}" is unknown.`);
        return true;
      }
      if (isPropDefinition(fieldMeta)) {
        const isAdvancedSetting = fieldMeta.formKey === undefined && fieldMeta.ignore !== true && !(0, _lodash.isEqual)(fieldMeta.defaultValue, fieldConfig);
        if (isAdvancedSetting) {
          // eslint-disable-next-line no-console
          console.info(`Property "${configKey}" is not supported by the form or has a different value to the default.`);
          return true;
        }
      } else if (isAdvancedConfig(fieldConfig, fieldMeta)) {
        return true;
      }
    }
  }
  return false;
}
/**
 * Gets complete original configuration as an input
 * and returns the config for cloning omitting
 * non-relevant parameters and resetting the destination index.
 */
function extractCloningConfig({
  id,
  ...configToClone
}) {
  return (0, _lodash.cloneDeep)({
    ...configToClone,
    dest: {
      ...configToClone.dest,
      // Reset the destination index
      index: ''
    }
  });
}
const cloneActionNameText = exports.cloneActionNameText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.cloneActionNameText', {
  defaultMessage: 'Clone'
});
const useNavigateToWizardWithClonedJob = () => {
  const {
    services: {
      notifications: {
        toasts
      },
      data: {
        dataViews
      },
      http: {
        basePath
      },
      application: {
        capabilities
      },
      ...startServices
    }
  } = (0, _kibana.useMlKibana)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const canCreateDataView = capabilities.savedObjectsManagement.edit === true || capabilities.indexPatterns.save === true;
  return async item => {
    const sourceIndex = Array.isArray(item.config.source.index) ? item.config.source.index.join(',') : item.config.source.index;
    let sourceIndexId;
    try {
      const dv = (await dataViews.find(sourceIndex)).find(({
        title
      }) => title === sourceIndex);
      if (dv !== undefined) {
        sourceIndexId = dv.id;
      } else {
        toasts.addDanger({
          title: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.dataframe.analyticsList.noSourceDataViewForClone",
            defaultMessage: "Unable to clone the analytics job. No data view exists for index {sourceIndex}.",
            values: {
              sourceIndex
            }
          }), canCreateDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs",
            color: "text"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.dataframe.analytics.cloneAction.dataViewPromptLink",
            defaultMessage: "{linkToDataViewManagement}",
            values: {
              linkToDataViewManagement: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                href: `${basePath.get()}/app/management/kibana/dataViews/create`,
                target: "_blank"
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.dataframe.analytics.cloneAction.dataViewPromptLinkText",
                defaultMessage: "Create a data view for {sourceIndex}",
                values: {
                  sourceIndex
                }
              }))
            }
          })) : null), startServices)
        });
      }
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorMessage)(e);
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.fetchSourceDataViewForCloneErrorMessage', {
        defaultMessage: 'An error occurred checking if data view {dataView} exists: {error}',
        values: {
          dataView: sourceIndex,
          error
        }
      }));
    }
    if (sourceIndexId) {
      await navigateToPath(`/data_frame_analytics/new_job?index=${encodeURIComponent(sourceIndexId)}&jobId=${item.config.id}`);
    }
  };
};
exports.useNavigateToWizardWithClonedJob = useNavigateToWizardWithClonedJob;
const CloneActionName = ({
  isDisabled
}) => {
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.cloneActionPermissionTooltip', {
        defaultMessage: 'You do not have permission to clone analytics jobs.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloneActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloneActionNameText);
};
exports.CloneActionName = CloneActionName;