"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchPipelines = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchPipelines = () => {
  const [pipelineNames, setPipelineNames] = (0, _react.useState)([]);
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useMlKibana)();
  const {
    trainedModels: {
      getAllIngestPipelines
    }
  } = (0, _kibana.useMlApi)();
  (0, _react.useEffect)(() => {
    async function fetchPipelines() {
      let names = [];
      try {
        const results = await getAllIngestPipelines();
        names = Object.keys(results);
        setPipelineNames(names);
      } catch (e) {
        toasts.danger({
          title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.fetchIngestPipelinesError', {
            defaultMessage: 'Unable to fetch ingest pipelines.'
          }),
          body: e.message,
          toastLifeTimeMs: 5000
        });
      }
    }
    fetchPipelines();
  }, [getAllIngestPipelines, toasts]);
  return pipelineNames;
};
exports.useFetchPipelines = useFetchPipelines;