"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMessages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _component_utils = require("../../util/component_utils");
var _job_message_icon = require("../job_message_icon");
var _ml = require("../../contexts/ml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component for rendering job messages for anomaly detection
 * and data frame analytics jobs.
 */
const JobMessages = ({
  messages,
  loading,
  error,
  refreshMessage,
  actionHandler
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      name: refreshMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.ml.jobMessages.refreshLabel', {
          defaultMessage: 'Refresh'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: (0, _component_utils.blurButtonOnClick)(() => {
          refreshMessage();
        }),
        iconType: "refresh",
        "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.refreshAriaLabel', {
          defaultMessage: 'Refresh'
        })
      })) : '',
      render: message => /*#__PURE__*/_react.default.createElement(_job_message_icon.JobIcon, {
        message: message
      }),
      width: `${euiTheme.size.l}`
    }, {
      field: 'timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobMessages.timeLabel', {
        defaultMessage: 'Time'
      }),
      render: _mlDateUtils.timeFormatter,
      width: '120px',
      sortable: true
    }, {
      field: 'message',
      name: _i18n.i18n.translate('xpack.ml.jobMessages.messageLabel', {
        defaultMessage: 'Message'
      }),
      width: '50%'
    }];
    if (showNodeInfo) {
      cols.splice(2, 0, {
        field: 'node_name',
        name: _i18n.i18n.translate('xpack.ml.jobMessages.nodeLabel', {
          defaultMessage: 'Node'
        }),
        width: '150px'
      });
    }
    if (typeof actionHandler === 'function') {
      cols.push({
        name: _i18n.i18n.translate('xpack.ml.jobMessages.actionsLabel', {
          defaultMessage: 'Actions'
        }),
        width: '10%',
        actions: [{
          render: message => {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
              content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.jobMessages.toggleInChartTooltipText",
                defaultMessage: "Toggle in chart"
              })
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
              size: "xs",
              "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.toggleInChartAriaLabel', {
                defaultMessage: 'Toggle in chart'
              }),
              iconType: "visAreaStacked",
              onClick: () => actionHandler(message)
            }));
          }
        }]
      });
    }
    return cols;
  }, [showNodeInfo, refreshMessage, actionHandler, euiTheme]);
  const defaultSorting = {
    sort: {
      field: 'timestamp',
      direction: 'desc'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: messages,
    columns: columns,
    sorting: defaultSorting,
    compressed: true,
    loading: loading,
    error: error,
    pagination: true,
    "data-test-subj": 'mlAnalyticsDetailsJobMessagesTable'
  }));
};
exports.JobMessages = JobMessages;