"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrlEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
var _custom_url_utils = require("../../../util/custom_url_utils");
var _constants = require("./constants");
var _custom_time_range_picker = require("./custom_time_range_picker");
var _kibana = require("../../../contexts/kibana");
var _get_dropdown_options = require("./get_dropdown_options");
var _interval_time_range_selector = require("./interval_time_range_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLinkToOptions() {
  return [{
    id: _constants.URL_TYPE.KIBANA_DASHBOARD,
    label: _i18n.i18n.translate('xpack.ml.customUrlEditor.kibanaDashboardLabel', {
      defaultMessage: 'Kibana dashboard'
    })
  }, {
    id: _constants.URL_TYPE.KIBANA_DISCOVER,
    label: _i18n.i18n.translate('xpack.ml.customUrlEditor.discoverLabel', {
      defaultMessage: 'Discover'
    })
  }, {
    id: _constants.URL_TYPE.OTHER,
    label: _i18n.i18n.translate('xpack.ml.customUrlEditor.otherLabel', {
      defaultMessage: 'Other'
    })
  }];
}
/*
 * React component for the form for editing a custom URL.
 */
const CustomUrlEditor = ({
  customUrl,
  setEditCustomUrl,
  savedCustomUrls,
  dashboards,
  dataViewListItems,
  showCustomTimeRangeSelector,
  job,
  isPartialDFAJob
}) => {
  var _customUrl$kibanaSett2;
  const [queryEntityFieldNames, setQueryEntityFieldNames] = (0, _react.useState)([]);
  const [hasTimefield, setHasTimefield] = (0, _react.useState)(false);
  const [addIntervalTimerange, setAddIntervalTimerange] = (0, _react.useState)(false);
  const {
    services: {
      data: {
        dataViews
      }
    }
  } = (0, _kibana.useMlKibana)();
  const isFirst = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    async function getQueryEntityDropdownOptions() {
      var _customUrl$kibanaSett;
      let dataViewToUse;
      const dataViewId = customUrl === null || customUrl === void 0 ? void 0 : (_customUrl$kibanaSett = customUrl.kibanaSettings) === null || _customUrl$kibanaSett === void 0 ? void 0 : _customUrl$kibanaSett.discoverIndexPatternId;
      try {
        dataViewToUse = await dataViews.get(dataViewId !== null && dataViewId !== void 0 ? dataViewId : '');
      } catch (e) {
        dataViewToUse = undefined;
      }
      if (dataViewToUse && dataViewToUse.timeFieldName) {
        setHasTimefield(true);
      }
      const dropDownOptions = await (0, _get_dropdown_options.getDropDownOptions)(isFirst.current, job, dataViewToUse, isPartialDFAJob);
      setQueryEntityFieldNames(dropDownOptions);
      if (isFirst.current) {
        isFirst.current = false;
      }
    }
    if (job !== undefined) {
      getQueryEntityDropdownOptions();
    }
  }, [dataViews, job, customUrl === null || customUrl === void 0 ? void 0 : (_customUrl$kibanaSett2 = customUrl.kibanaSettings) === null || _customUrl$kibanaSett2 === void 0 ? void 0 : _customUrl$kibanaSett2.discoverIndexPatternId, isPartialDFAJob]);
  (0, _react.useEffect)(() => {
    if (addIntervalTimerange === false) {
      // Reset timeRange when not using interval time range
      setEditCustomUrl({
        ...customUrl,
        timeRange: {
          type: _constants.TIME_RANGE_TYPE.AUTO,
          interval: ''
        }
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [addIntervalTimerange, setEditCustomUrl]);
  if (customUrl === undefined) {
    return null;
  }
  const onLabelChange = e => {
    setEditCustomUrl({
      ...customUrl,
      label: e.target.value
    });
  };
  const onTypeChange = linkType => {
    setEditCustomUrl({
      ...customUrl,
      type: linkType
    });
  };
  const onCustomTimeRangeChange = customTimeRange => {
    setEditCustomUrl({
      ...customUrl,
      customTimeRange,
      // Reset timeRange when using customTimeRange
      timeRange: {
        type: _constants.TIME_RANGE_TYPE.AUTO,
        interval: ''
      }
    });
  };
  const onDashboardChange = e => {
    const kibanaSettings = customUrl.kibanaSettings;
    setEditCustomUrl({
      ...customUrl,
      kibanaSettings: {
        ...kibanaSettings,
        dashboardId: e.target.value
      }
    });
  };
  const onDiscoverIndexPatternChange = e => {
    const kibanaSettings = customUrl.kibanaSettings;
    setEditCustomUrl({
      ...customUrl,
      kibanaSettings: {
        ...kibanaSettings,
        discoverIndexPatternId: e.target.value,
        queryFieldNames: []
      }
    });
  };
  const onQueryEntitiesChange = selectedOptions => {
    const selectedFieldNames = selectedOptions.map(option => option.label);
    const kibanaSettings = customUrl.kibanaSettings;
    setEditCustomUrl({
      ...customUrl,
      kibanaSettings: {
        ...kibanaSettings,
        queryFieldNames: selectedFieldNames
      }
    });
  };
  const onOtherUrlValueChange = e => {
    setEditCustomUrl({
      ...customUrl,
      otherUrlSettings: {
        urlValue: e.target.value
      }
    });
  };
  const onTimeRangeTypeChange = e => {
    const timeRange = customUrl.timeRange;
    setEditCustomUrl({
      ...customUrl,
      timeRange: {
        ...timeRange,
        type: e.target.value
      }
    });
  };
  const onTimeRangeIntervalChange = e => {
    setEditCustomUrl({
      ...customUrl,
      timeRange: {
        type: _constants.TIME_RANGE_TYPE.INTERVAL,
        interval: e.target.value
      },
      // Reset customTimeRange to undefined when using interval timeRange
      customTimeRange: undefined
    });
  };
  const {
    label,
    type,
    timeRange,
    kibanaSettings,
    otherUrlSettings
  } = customUrl;
  const dashboardOptions = dashboards.map(dashboard => {
    return {
      value: dashboard.id,
      text: dashboard.attributes.title
    };
  });
  const dataViewOptions = dataViewListItems.map(({
    id,
    title
  }) => {
    return {
      value: id,
      text: title
    };
  });
  const entityOptions = queryEntityFieldNames.map(fieldName => ({
    label: fieldName
  }));
  let selectedEntityOptions = [];
  if (kibanaSettings !== undefined && kibanaSettings.queryFieldNames !== undefined) {
    const queryFieldNames = kibanaSettings.queryFieldNames;
    selectedEntityOptions = queryFieldNames.map(fieldName => ({
      label: fieldName
    }));
  }
  const timeRangeOptions = Object.values(_constants.TIME_RANGE_TYPE).map(timeRangeType => ({
    value: timeRangeType,
    text: timeRangeType
  }));
  const isInvalidLabel = !(0, _custom_url_utils.isValidLabel)(label, savedCustomUrls);
  const invalidLabelError = isInvalidLabel ? [_i18n.i18n.translate('xpack.ml.customUrlsEditor.invalidLabelErrorMessage', {
    defaultMessage: 'A unique label must be supplied'
  })] : [];
  const isInvalidTimeRange = !(0, _utils.isValidCustomUrlSettingsTimeRange)(timeRange);
  const invalidIntervalError = isInvalidTimeRange ? [_i18n.i18n.translate('xpack.ml.customUrlsList.invalidIntervalFormatErrorMessage', {
    defaultMessage: 'Invalid interval format'
  })] : [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.customUrlsEditor.createNewCustomUrlTitle",
    defaultMessage: "Create new custom URL"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "ml-edit-url-form",
    "data-test-subj": "mlJobCustomUrlForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.labelLabel",
      defaultMessage: "Label"
    }),
    error: invalidLabelError,
    isInvalid: isInvalidLabel,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "label",
    value: label,
    onChange: onLabelChange,
    isInvalid: isInvalidLabel,
    compressed: true,
    "data-test-subj": "mlJobCustomUrlLabelInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.linkToLabel",
      defaultMessage: "Link to"
    }),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: getLinkToOptions(),
    idSelected: type,
    onChange: onTypeChange,
    className: "url-link-to-radio",
    "data-test-subj": "mlJobCustomUrlLinkToTypeInput"
  })), type === _constants.URL_TYPE.KIBANA_DASHBOARD && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.dashboardNameLabel",
      defaultMessage: "Dashboard name"
    }),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: dashboardOptions,
    value: kibanaSettings === null || kibanaSettings === void 0 ? void 0 : kibanaSettings.dashboardId,
    onChange: onDashboardChange,
    "data-test-subj": "mlJobCustomUrlDashboardNameInput",
    compressed: true
  })), type === _constants.URL_TYPE.KIBANA_DISCOVER && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.dataViewLabel",
      defaultMessage: "Data view"
    }),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: dataViewOptions,
    value: kibanaSettings === null || kibanaSettings === void 0 ? void 0 : kibanaSettings.discoverIndexPatternId,
    onChange: onDiscoverIndexPatternChange,
    "data-test-subj": "mlJobCustomUrlDiscoverIndexPatternInput",
    compressed: true
  })), (type === _constants.URL_TYPE.KIBANA_DASHBOARD || type === _constants.URL_TYPE.KIBANA_DISCOVER) && entityOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.queryEntitiesLabel",
      defaultMessage: "Query entities"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.ml.customUrlsEditor.selectEntitiesPlaceholder', {
      defaultMessage: 'Select entities'
    }),
    options: entityOptions,
    selectedOptions: selectedEntityOptions,
    onChange: onQueryEntitiesChange,
    isClearable: true,
    "data-test-subj": "mlJobCustomUrlQueryEntitiesInput"
  })), (type === _constants.URL_TYPE.KIBANA_DASHBOARD || type === _constants.URL_TYPE.KIBANA_DISCOVER) && hasTimefield && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'none',
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.timeRangeLabel",
      defaultMessage: "Time range"
    })), showCustomTimeRangeSelector ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.ml.customUrlsEditor.timeRangeTooltip', {
        defaultMessage: 'If not set, time range defaults to global settings.'
      }),
      position: "top",
      type: "iInCircle"
    })) : null),
    className: "url-time-range",
    display: "rowCompressed"
  }, showCustomTimeRangeSelector ? /*#__PURE__*/_react.default.createElement(_interval_time_range_selector.IntervalTimerangeSelector, {
    disabled: (customUrl === null || customUrl === void 0 ? void 0 : customUrl.customTimeRange) !== undefined,
    setAddIntervalTimerange: setAddIntervalTimerange,
    addIntervalTimerange: addIntervalTimerange
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeRangeOptions,
    value: timeRange.type,
    onChange: onTimeRangeTypeChange,
    "data-test-subj": "mlJobCustomUrlTimeRangeInput",
    compressed: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, showCustomTimeRangeSelector && addIntervalTimerange || !showCustomTimeRangeSelector && timeRange.type === _constants.TIME_RANGE_TYPE.INTERVAL ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.intervalLabel",
      defaultMessage: "Interval"
    }),
    className: "url-time-range",
    error: invalidIntervalError,
    isInvalid: isInvalidTimeRange,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: timeRange.interval,
    onChange: onTimeRangeIntervalChange,
    isInvalid: isInvalidTimeRange,
    "data-test-subj": "mlJobCustomUrlTimeRangeIntervalInput",
    compressed: true
  })) : null)), (type === _constants.URL_TYPE.KIBANA_DASHBOARD || type === _constants.URL_TYPE.KIBANA_DISCOVER) && showCustomTimeRangeSelector && hasTimefield ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_custom_time_range_picker.CustomTimeRangePicker, {
    disabled: addIntervalTimerange,
    onCustomTimeRangeChange: onCustomTimeRangeChange,
    customTimeRange: customUrl === null || customUrl === void 0 ? void 0 : customUrl.customTimeRange
  })) : null), type === _constants.URL_TYPE.OTHER && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlsEditor.urlLabel",
      defaultMessage: "URL"
    }),
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    rows: 2,
    value: otherUrlSettings === null || otherUrlSettings === void 0 ? void 0 : otherUrlSettings.urlValue,
    onChange: onOtherUrlValueChange,
    "data-test-subj": "mlJobCustomUrlOtherTypeUrlInput",
    compressed: true
  }))));
};
exports.CustomUrlEditor = CustomUrlEditor;