"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlTooltipComponent = exports.FormattedTooltip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactPopperTooltip = require("react-popper-tooltip");
var _eui = require("@elastic/eui");
require("./_index.scss");
var _chart_tooltip_service = require("./chart_tooltip_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderHeader = (headerData, formatter) => {
  if (!headerData) {
    return null;
  }
  return formatter ? formatter(headerData) : headerData.label;
};

/**
 * Pure component for rendering the tooltip content with a custom layout across the ML plugin.
 */
const FormattedTooltip = ({
  tooltipData
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mlChartTooltip"
  }, tooltipData.length > 0 && tooltipData[0].skipHeader === undefined && /*#__PURE__*/_react.default.createElement("div", {
    className: "mlChartTooltip__header"
  }, renderHeader(tooltipData[0])), tooltipData.length > 1 && /*#__PURE__*/_react.default.createElement("div", {
    className: "mlChartTooltip__list"
  }, tooltipData.slice(1).map(({
    label,
    value,
    color,
    isHighlighted,
    seriesIdentifier,
    valueAccessor
  }) => {
    const classes = (0, _classnames.default)('mlChartTooltip__item', {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      echTooltip__rowHighlighted: isHighlighted
    });
    const renderValue = Array.isArray(value) ? value.map(v => /*#__PURE__*/_react.default.createElement("div", {
      key: v
    }, v)) : value;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: `${seriesIdentifier.key}__${valueAccessor}`,
      className: classes,
      style: {
        borderLeftColor: color
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textBreakWord mlChartTooltip__label",
      grow: false
    }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textBreakAll mlChartTooltip__value"
    }, renderValue)));
  })));
};

/**
 * Tooltip component bundled with the {@link ChartTooltipService}
 */
exports.FormattedTooltip = FormattedTooltip;
const Tooltip = /*#__PURE__*/_react.default.memo(({
  service
}) => {
  const [tooltipData, setData] = (0, _react.useState)([]);
  const {
    getTooltipProps,
    setTooltipRef,
    setTriggerRef
  } = (0, _reactPopperTooltip.usePopperTooltip)({
    placement: 'top-start',
    trigger: null,
    delayHide: 1000
  }, {
    modifiers: [{
      name: 'preventOverflow',
      options: {
        rootBoundary: 'viewport'
      }
    }]
  });
  (0, _react.useEffect)(() => {
    const subscription = service.tooltipState$.subscribe(tooltipState => {
      if (setTriggerRef && typeof setTriggerRef === 'function') {
        // update trigger
        setTriggerRef(tooltipState.target);
      }
      setData(tooltipState.tooltipData);
    });
    return () => {
      subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const isTooltipShown = tooltipData.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isTooltipShown && /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: setTooltipRef
  }, getTooltipProps({
    className: 'tooltip-container'
  })), /*#__PURE__*/_react.default.createElement(FormattedTooltip, {
    tooltipData: tooltipData
  })));
});
const MlTooltipComponent = ({
  children
}) => {
  const service = (0, _react.useMemo)(() => new _chart_tooltip_service.ChartTooltipService(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Tooltip, {
    service: service
  }), children(service));
};
exports.MlTooltipComponent = MlTooltipComponent;