"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsItems = exports.AnomalyExplanationDetails = void 0;
exports.getInfluencersItems = getInfluencersItems;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _entity_cell = require("../entity_cell");
var _format_value = require("../../formatters/format_value");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIME_FIELD_NAME = 'timestamp';
function getFilterEntity(entityName, entityValue, filter) {
  return /*#__PURE__*/_react.default.createElement(_entity_cell.EntityCell, {
    entityName: entityName,
    entityValue: entityValue,
    filter: filter
  });
}
function getInfluencersItems(anomalyInfluencers, influencerFilter, numToDisplay) {
  const items = [];
  for (let i = 0; i < numToDisplay; i++) {
    Object.keys(anomalyInfluencers[i]).forEach(influencerFieldName => {
      const value = anomalyInfluencers[i][influencerFieldName];
      items.push({
        title: influencerFieldName,
        description: getFilterEntity(influencerFieldName, value, influencerFilter)
      });
    });
  }
  return items;
}
const DetailsItems = ({
  anomaly,
  filter,
  modelPlotEnabled
}) => {
  const source = anomaly.source;

  // TODO - when multivariate analyses are more common,
  // look in each cause for a 'correlatedByFieldValue' field,
  let causes = [];
  const sourceCauses = source.causes || [];
  let singleCauseByFieldName;
  let singleCauseByFieldValue;
  if (sourceCauses.length === 1) {
    // Metrics and probability will already have been placed at the top level.
    // If cause has byFieldValue, move it to a top level fields for display.
    if (sourceCauses[0].by_field_name !== undefined) {
      singleCauseByFieldName = sourceCauses[0].by_field_name;
      singleCauseByFieldValue = sourceCauses[0].by_field_value;
    }
  } else {
    causes = sourceCauses.map(cause => {
      return {
        typical: cause.typical,
        actual: cause.actual,
        probability: cause.probability,
        // // Get the 'entity field name/value' to display in the cause -
        // // For by and over, use by_field_name/value (over_field_name/value are in the top level fields)
        // // For just an 'over' field - the over_field_name/value appear in both top level and cause.
        entityName: cause.by_field_name ? cause.by_field_name : cause.over_field_name,
        entityValue: cause.by_field_value ? cause.by_field_value : cause.over_field_value
      };
    });
  }
  const items = [];
  if (source.partition_field_value !== undefined && source.partition_field_name !== undefined) {
    items.push({
      title: source.partition_field_name,
      description: getFilterEntity(source.partition_field_name, String(source.partition_field_value), filter)
    });
  }
  if (source.by_field_value !== undefined && source.by_field_name !== undefined) {
    items.push({
      title: source.by_field_name,
      description: getFilterEntity(source.by_field_name, source.by_field_value, filter)
    });
  }
  if (singleCauseByFieldName !== undefined && singleCauseByFieldValue !== undefined) {
    // Display byField of single cause.
    items.push({
      title: singleCauseByFieldName,
      description: getFilterEntity(singleCauseByFieldName, singleCauseByFieldValue, filter)
    });
  }
  if (source.over_field_value !== undefined && source.over_field_name !== undefined) {
    items.push({
      title: source.over_field_name,
      description: getFilterEntity(source.over_field_name, source.over_field_value, filter)
    });
  }
  const anomalyTime = source[TIME_FIELD_NAME];
  let timeDesc = `${(0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(anomalyTime)}`;
  if (source.bucket_span !== undefined) {
    const anomalyEndTime = anomalyTime + source.bucket_span * 1000;
    timeDesc = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyTimeRangeLabel', {
      defaultMessage: '{anomalyTime} to {anomalyEndTime}',
      values: {
        anomalyTime: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(anomalyTime),
        anomalyEndTime: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(anomalyEndTime)
      }
    });
  }
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.timeTitle', {
      defaultMessage: 'Time'
    }),
    description: timeDesc
  });
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.functionTitle', {
      defaultMessage: 'Function'
    }),
    description: source.function !== _mlAnomalyUtils.ML_JOB_AGGREGATION.METRIC ? source.function : source.function_description
  });
  if (source.field_name !== undefined) {
    items.push({
      title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.fieldNameTitle', {
        defaultMessage: 'Field name'
      }),
      description: source.field_name
    });
  }
  const functionDescription = source.function_description || '';
  if (anomaly.actual !== undefined && (0, _mlAnomalyUtils.showActualForFunction)(functionDescription) === true) {
    items.push({
      title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.actualTitle', {
        defaultMessage: 'Actual'
      }),
      description: (0, _format_value.formatValue)(anomaly.actual, source.function, undefined, source)
    });
  }
  if (anomaly.typical !== undefined && (0, _mlAnomalyUtils.showTypicalForFunction)(functionDescription) === true) {
    var _anomaly$source$anoma, _anomaly$source$anoma2;
    items.push({
      title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.typicalTitle', {
        defaultMessage: 'Typical'
      }),
      description: (0, _format_value.formatValue)(anomaly.typical, source.function, undefined, source)
    });
    if (modelPlotEnabled === false && ((_anomaly$source$anoma = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma === void 0 ? void 0 : _anomaly$source$anoma.lower_confidence_bound) !== undefined && ((_anomaly$source$anoma2 = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma2 === void 0 ? void 0 : _anomaly$source$anoma2.upper_confidence_bound) !== undefined) {
      var _anomaly$source$anoma3, _anomaly$source$anoma4;
      items.push({
        title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.upperBoundsTitle', {
          defaultMessage: 'Upper bound'
        }),
        description: (0, _format_value.formatValue)((_anomaly$source$anoma3 = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma3 === void 0 ? void 0 : _anomaly$source$anoma3.upper_confidence_bound, source.function, undefined, source)
      });
      items.push({
        title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.lowerBoundsTitle', {
          defaultMessage: 'Lower bound'
        }),
        description: (0, _format_value.formatValue)((_anomaly$source$anoma4 = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma4 === void 0 ? void 0 : _anomaly$source$anoma4.lower_confidence_bound, source.function, undefined, source)
      });
    }
  }
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.jobIdTitle', {
      defaultMessage: 'Job ID'
    }),
    description: anomaly.jobId
  });
  items.push({
    title: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.recordScoreTitle', {
      defaultMessage: 'Record score'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop",
      position: "left",
      content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.recordScoreTooltip', {
        defaultMessage: 'A normalized score between 0-100, which indicates the relative significance of the anomaly record result. This value might change as new data is analyzed.'
      })
    })),
    description: Math.floor(1000 * source.record_score) / 1000
  });
  items.push({
    title: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.initialRecordScoreTitle', {
      defaultMessage: 'Initial record score'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop",
      position: "left",
      content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.initialRecordScoreTooltip', {
        defaultMessage: 'A normalized score between 0-100, which indicates the relative significance of the anomaly record when the bucket was initially processed.'
      })
    })),
    description: Math.floor(1000 * source.initial_record_score) / 1000
  });
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.probabilityTitle', {
      defaultMessage: 'Probability'
    }),
    description:
    // @ts-expect-error parseFloat accepts a number
    source.probability !== undefined ? Number.parseFloat(source.probability).toPrecision(3) : ''
  });

  // If there was only one cause, the actual, typical and by_field
  // will already have been added for display.
  if (causes.length > 1) {
    causes.forEach((cause, index) => {
      const title = index === 0 ? _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.causeValuesTitle', {
        defaultMessage: '{causeEntityName} values',
        values: {
          causeEntityName: cause.entityName
        }
      }) : '';
      const description = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.causeValuesDescription', {
        defaultMessage: '{causeEntityValue} (actual {actualValue}, ' + 'typical {typicalValue}, probability {probabilityValue})',
        values: {
          causeEntityValue: cause.entityValue,
          actualValue: (0, _format_value.formatValue)(cause.actual, source.function),
          typicalValue: (0, _format_value.formatValue)(cause.typical, source.function),
          probabilityValue: cause.probability
        }
      });
      items.push({
        title,
        description
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '180px'
    },
    grow: false
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))));
};
exports.DetailsItems = DetailsItems;
const AnomalyExplanationDetails = ({
  anomaly
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docsUrl = docLinks.links.ml.anomalyDetectionScoreExplanation;
  const explanation = anomaly.source.anomaly_score_explanation;
  if (explanation === undefined) {
    return null;
  }
  const initialScore = Math.floor(1000 * anomaly.source.initial_record_score) / 1000;
  const finalScore = Math.floor(1000 * anomaly.source.record_score) / 1000;
  const scoreDifference = initialScore - finalScore;
  const ACCEPTABLE_NORMALIZATION = 10;
  const yes = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.yes', {
    defaultMessage: 'Yes'
  });
  const no = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.no', {
    defaultMessage: 'No'
  });
  const explanationDetails = [];
  const anomalyType = getAnomalyType(explanation);
  if (anomalyType !== null) {
    explanationDetails.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyType",
        defaultMessage: "Anomaly type"
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, anomalyType)
    });
  }
  if (scoreDifference > ACCEPTABLE_NORMALIZATION) {
    explanationDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.recordScore",
        defaultMessage: "Record score reduction"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.recordScoreTooltip', {
          defaultMessage: 'The initial record score has been reduced based on the analysis of subsequent data.'
        })
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(RecordScore, {
        score: initialScore
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, ` -> `), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(RecordScore, {
        score: finalScore
      })))
    });
  }
  const impactDetails = [];
  if (explanation.anomaly_characteristics_impact !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristics",
        defaultMessage: "Anomaly characteristics impact"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: getImpactTooltip(explanation.anomaly_characteristics_impact, 'anomaly_characteristics')
      })),
      description: /*#__PURE__*/_react.default.createElement(ImpactVisual, {
        score: explanation.anomaly_characteristics_impact
      })
    });
  }
  if (explanation.single_bucket_impact !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucket",
        defaultMessage: "Single bucket impact"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: getImpactTooltip(explanation.single_bucket_impact, 'single_bucket')
      })),
      description: /*#__PURE__*/_react.default.createElement(ImpactVisual, {
        score: explanation.single_bucket_impact
      })
    });
  }
  if (explanation.multi_bucket_impact !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucket",
        defaultMessage: "Multi bucket impact"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: getImpactTooltip(explanation.multi_bucket_impact, 'multi_bucket')
      })),
      description: /*#__PURE__*/_react.default.createElement(ImpactVisual, {
        score: explanation.multi_bucket_impact
      })
    });
  }
  if (explanation.high_variance_penalty !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.highVariance",
        defaultMessage: "High variance interval"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.highVarianceTooltip', {
          defaultMessage: 'Indicates reduction of anomaly score for the bucket with large confidence intervals. If a bucket has large confidence intervals, the score is reduced.'
        })
      })),
      description: explanation.high_variance_penalty ? yes : no
    });
  }
  if (explanation.multimodal_distribution !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multimodal",
        defaultMessage: "Multi-modal distribution"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multimodalTooltip', {
          defaultMessage: 'Indicates whether the prior distribution of the time series is multi-modal or has a single mode.'
        })
      })),
      description: explanation.multimodal_distribution ? yes : no
    });
  }
  if (explanation.incomplete_bucket_penalty !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.incompleteBucket",
        defaultMessage: "Incomplete bucket"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "questionInCircle",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.incompleteBucketTooltip', {
          defaultMessage: 'If the bucket contains fewer samples than expected, the score is reduced.'
        })
      })),
      description: explanation.incomplete_bucket_penalty ? yes : no
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationTitle",
    defaultMessage: "Anomaly explanation {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsUrl,
        target: "_blank",
        css: {
          marginLeft: '8px'
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanation.learnMoreLinkText",
        defaultMessage: "Learn more"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), explanationDetails.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '220px'
    },
    grow: false
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), impactDetails.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.impactOnScoreTitle",
    defaultMessage: "Impact on initial score"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), impactDetails.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '220px'
    },
    grow: false
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })))) : null);
};
exports.AnomalyExplanationDetails = AnomalyExplanationDetails;
const RecordScore = ({
  score
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      borderBottom: '2px solid'
    },
    style: {
      borderBottomColor: (0, _mlAnomalyUtils.getSeverityColor)(score)
    }
  }, score);
};
function getAnomalyType(explanation) {
  if (explanation === undefined || explanation.anomaly_length === undefined || explanation.anomaly_type === undefined) {
    return null;
  }
  const dip = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.anomalyType.dip', {
    defaultMessage: 'Dip over {anomalyLength, plural, one {# bucket} other {# buckets}}',
    values: {
      anomalyLength: explanation.anomaly_length
    }
  });
  const spike = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.anomalyType.spike', {
    defaultMessage: 'Spike over {anomalyLength, plural, one {# bucket} other {# buckets}}',
    values: {
      anomalyLength: explanation.anomaly_length
    }
  });
  return explanation.anomaly_type === 'dip' ? dip : spike;
}
const impactTooltips = {
  anomaly_characteristics: {
    low: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristicsTooltip.low', {
      defaultMessage: 'Moderate impact from the duration and magnitude of the detected anomaly relative to the historical average.'
    }),
    medium: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristicsTooltip.medium', {
      defaultMessage: 'Medium impact from the duration and magnitude of the detected anomaly relative to the historical average.'
    }),
    high: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristicsTooltip.high', {
      defaultMessage: 'High impact from the duration and magnitude of the detected anomaly relative to the historical average.'
    })
  },
  single_bucket: {
    low: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucketTooltip.low', {
      defaultMessage: 'The difference between actual and typical values in this bucket has a moderate impact.'
    }),
    medium: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucketTooltip.medium', {
      defaultMessage: 'The difference between actual and typical values in this bucket has a significant impact.'
    }),
    high: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucketTooltip.high', {
      defaultMessage: 'The difference between actual and typical values in this bucket has a high impact.'
    })
  },
  multi_bucket: {
    low: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucketTooltip.low', {
      defaultMessage: 'The differences between actual and typical values in the past 12 buckets have a moderate impact.'
    }),
    medium: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucketTooltip.medium', {
      defaultMessage: 'The differences between actual and typical values in the past 12 buckets have a significant impact.'
    }),
    high: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucketTooltip.high', {
      defaultMessage: 'The differences between actual and typical values in the past 12 buckets have a high impact.'
    })
  }
};
function getImpactTooltip(score, type) {
  const value = (0, _mlAnomalyUtils.getAnomalyScoreExplanationImpactValue)(score);
  if (value < 3) {
    return impactTooltips[type].low;
  }
  if (value > 3) {
    return impactTooltips[type].high;
  }
  return impactTooltips[type].medium;
}
const ImpactVisual = ({
  score
}) => {
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const impact = (0, _mlAnomalyUtils.getAnomalyScoreExplanationImpactValue)(score);
  const boxPx = '10px';
  const emptyBox = colors.lightShade;
  const fullBox = colors.primary;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, Array(5).fill(null).map((v, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        height: boxPx,
        width: boxPx,
        borderRadius: '2px'
      },
      style: {
        backgroundColor: impact > i ? fullBox : emptyBox
      }
    }));
  }));
};