"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/aiops-plugin/public");
var _constants = require("@kbn/aiops-common/constants");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _data_source_context = require("../contexts/ml/data_source_context");
var _kibana = require("../contexts/kibana");
var _help_menu = require("../components/help_menu");
var _technical_preview_badge = require("../components/technical_preview_badge");
var _page_header = require("../components/page_header");
var _serverless_context = require("../contexts/ml/serverless_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangePointDetectionPage = () => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const {
    selectedDataView: dataView,
    selectedSavedSearch: savedSearch
  } = (0, _data_source_context.useDataSource)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.changePointDetection.pageHeader",
    defaultMessage: "Change point detection"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, null)))), dataView ? /*#__PURE__*/_react.default.createElement(_public.ChangePointDetection, {
    dataView: dataView,
    savedSearch: savedSearch,
    showFrozenDataTierChoice: showNodeInfo,
    appContextValue: {
      embeddingOrigin: _constants.AIOPS_EMBEDDABLE_ORIGIN.ML_AIOPS_LABS,
      ...(0, _lodash.pick)(services, ['analytics', 'application', 'cases', 'charts', 'data', 'embeddable', 'executionContext', 'fieldFormats', 'http', 'i18n', 'lens', 'notifications', 'share', 'storage', 'theme', 'uiActions', 'uiSettings', 'unifiedSearch', 'usageCollection']),
      fieldStats: {
        useFieldStatsTrigger: _mlFieldStatsFlyout.useFieldStatsTrigger,
        FieldStatsFlyoutProvider: _mlFieldStatsFlyout.FieldStatsFlyoutProvider
      }
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: services.docLinks.links.aggs.change_point,
    appName: _i18n.i18n.translate('xpack.ml.changePointDetection.pageHeader', {
      defaultMessage: 'Change point detection'
    })
  }));
};
exports.ChangePointDetectionPage = ChangePointDetectionPage;