"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMlAlerts = registerMlAlerts;
exports.registerNavigation = registerNavigation;
var _alerts = require("../../common/constants/alerts");
var _app = require("../../common/constants/app");
var _anomaly_detection = require("../locator/formatters/anomaly_detection");
var _jobs_health_rule = require("./jobs_health_rule");
var _anomaly_detection_rule = require("./anomaly_detection_rule");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerMlAlerts(triggersActionsUi, getStartServices, mlCapabilities, alerting) {
  (0, _anomaly_detection_rule.registerAnomalyDetectionRule)(triggersActionsUi, getStartServices, mlCapabilities);
  (0, _jobs_health_rule.registerJobsHealthAlertingRule)(triggersActionsUi, alerting);
  if (alerting) {
    registerNavigation(alerting);
  }

  // Async import to prevent a bundle size increase
  Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_detection_alerts_table')))]).then(([[_, mlStartDependencies], {
    registerAlertsTableConfiguration
  }]) => {
    registerAlertsTableConfiguration(triggersActionsUi, mlStartDependencies.fieldFormats);
  });
}
function registerNavigation(alerting) {
  alerting.registerNavigation(_app.PLUGIN_ID, _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION, alert => {
    var _alertParams$jobSelec, _alertParams$jobSelec2;
    const alertParams = alert.params;
    const jobIds = [...new Set([...((_alertParams$jobSelec = alertParams.jobSelection.jobIds) !== null && _alertParams$jobSelec !== void 0 ? _alertParams$jobSelec : []), ...((_alertParams$jobSelec2 = alertParams.jobSelection.groupIds) !== null && _alertParams$jobSelec2 !== void 0 ? _alertParams$jobSelec2 : [])])];
    return (0, _anomaly_detection.formatExplorerUrl)(_app.ML_APP_ROUTE, {
      jobIds
    });
  });
}