"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActions = AlertActions;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/cases-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _app = require("../../../common/constants/app");
var _kibana = require("../../application/contexts/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertActions(props) {
  var _alert$ALERT_RULE_UUI, _alert$ALERT_RULE_UUI2, _alert$ALERT_UUID$, _alert$ALERT_UUID, _cases$hooks, _cases$hooks2;
  const {
    alert,
    refresh
  } = props;
  const {
    cases,
    triggersActionsUi
  } = (0, _kibana.useMlKibana)().services;
  const casesPrivileges = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases([_common.APP_ID]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const ruleId = (_alert$ALERT_RULE_UUI = (_alert$ALERT_RULE_UUI2 = alert[_ruleDataUtils.ALERT_RULE_UUID]) === null || _alert$ALERT_RULE_UUI2 === void 0 ? void 0 : _alert$ALERT_RULE_UUI2[0]) !== null && _alert$ALERT_RULE_UUI !== void 0 ? _alert$ALERT_RULE_UUI : null;
  const alertId = (_alert$ALERT_UUID$ = (_alert$ALERT_UUID = alert[_ruleDataUtils.ALERT_UUID]) === null || _alert$ALERT_UUID === void 0 ? void 0 : _alert$ALERT_UUID[0]) !== null && _alert$ALERT_UUID$ !== void 0 ? _alert$ALERT_UUID$ : '';
  const ecsData = (0, _react.useMemo)(() => ({
    _id: alert._id,
    _index: alert._index
  }), [alert._id, alert._index]);
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: alertId !== null && alertId !== void 0 ? alertId : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      type: _common.AttachmentType.alert,
      rule: {
        id: ruleId,
        name: alert[_ruleDataUtils.ALERT_RULE_NAME][0]
      },
      owner: _app.PLUGIN_ID
    }] : [];
  }, [alert, alertId, ecsData === null || ecsData === void 0 ? void 0 : ecsData._id, ecsData === null || ecsData === void 0 ? void 0 : ecsData._index, ruleId]);
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
  }, [refresh]);
  const createCaseFlyout = cases === null || cases === void 0 ? void 0 : (_cases$hooks = cases.hooks) === null || _cases$hooks === void 0 ? void 0 : _cases$hooks.useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = cases === null || cases === void 0 ? void 0 : (_cases$hooks2 = cases.hooks) === null || _cases$hooks2 === void 0 ? void 0 : _cases$hooks2.useCasesAddToExistingCaseModal({
    onSuccess
  });
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const toggleActionsPopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const handleAddToNewCaseClick = () => {
    createCaseFlyout === null || createCaseFlyout === void 0 ? void 0 : createCaseFlyout.open({
      attachments: caseAttachments
    });
    closeActionsPopover();
  };
  const handleAddToExistingCaseClick = () => {
    selectCaseModal === null || selectCaseModal === void 0 ? void 0 : selectCaseModal.open({
      getAttachments: () => caseAttachments
    });
    closeActionsPopover();
  };
  const DefaultAlertActions = (0, _react.useMemo)(() => triggersActionsUi === null || triggersActionsUi === void 0 ? void 0 : triggersActionsUi.getAlertsTableDefaultAlertActions({
    key: 'defaultRowActions',
    onActionExecuted: closeActionsPopover,
    isAlertDetailsEnabled: false,
    resolveRulePagePath: alertRuleId => alertRuleId ? `/app/management/insightsAndAlerting/triggersActions/rule/${alertRuleId}` : null,
    ...props
  }), [props, triggersActionsUi]);
  const actionsMenuItems = [...(casesPrivileges && casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.create && casesPrivileges.read ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-existing-case-action",
    key: "addToExistingCase",
    onClick: handleAddToExistingCaseClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.ml.alerts.actions.addToCase', {
    defaultMessage: 'Add to existing case'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-new-case-action",
    key: "addToNewCase",
    onClick: handleAddToNewCaseClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.ml.alerts.actions.addToNewCase', {
    defaultMessage: 'Add to new case'
  }))] : [])];
  if (DefaultAlertActions) {
    actionsMenuItems.push(DefaultAlertActions);
  }
  const actionsToolTip = actionsMenuItems.length <= 0 ? _i18n.i18n.translate('xpack.ml.alertsTable.notEnoughPermissions', {
    defaultMessage: 'Additional privileges required'
  }) : _i18n.i18n.translate('xpack.ml.alertsTable.moreActionsTextLabel', {
    defaultMessage: 'More actions'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: actionsToolTip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": actionsToolTip,
      color: "text",
      "data-test-subj": "alertsTableRowActionMore",
      display: "empty",
      iconType: "boxesHorizontal",
      onClick: toggleActionsPopover,
      size: "s"
    })),
    closePopover: closeActionsPopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsMenuItems,
    "data-test-subj": "alertsTableActionsMenu"
  })));
}