"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeActionHandlers = initializeActionHandlers;
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
var _kibana_services = require("../kibana_services");
var _trigger_utils = require("../trigger_actions/trigger_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializeActionHandlers(getApi) {
  function getActionContext() {
    const trigger = (0, _kibana_services.getUiActions)().getTrigger(_public.APPLY_FILTER_TRIGGER);
    if (!trigger) {
      throw new Error('Unable to get context, could not locate trigger');
    }
    return {
      embeddable: getApi(),
      trigger
    };
  }
  return {
    addFilters: async (filters, actionId = _public2.ACTION_GLOBAL_APPLY_FILTER) => {
      const executeContext = {
        ...getActionContext(),
        filters
      };
      const action = (0, _kibana_services.getUiActions)().getAction(actionId);
      if (!action) {
        throw new Error('Unable to apply filter, could not locate action');
      }
      action.execute(executeContext);
    },
    getActionContext,
    getFilterActions: async () => {
      const filterActions = await (0, _kibana_services.getUiActions)().getTriggerCompatibleActions(_public.APPLY_FILTER_TRIGGER, {
        embeddable: getApi(),
        filters: []
      });
      const valueClickActions = await (0, _kibana_services.getUiActions)().getTriggerCompatibleActions(_public3.VALUE_CLICK_TRIGGER, {
        embeddable: getApi(),
        data: {
          // uiActions.getTriggerCompatibleActions validates action with provided context
          // so if event.key and event.value are used in the URL template but can not be parsed from context
          // then the action is filtered out.
          // To prevent filtering out actions, provide dummy context when initially fetching actions.
          data: (0, _trigger_utils.toValueClickDataFormat)('anyfield', 'anyvalue')
        }
      });
      return [...filterActions, ...valueClickActions.filter(_trigger_utils.isUrlDrilldown)];
    },
    onSingleValueTrigger: (actionId, key, value) => {
      const action = (0, _kibana_services.getUiActions)().getAction(actionId);
      if (!action) {
        throw new Error('Unable to apply action, could not locate action');
      }
      const executeContext = {
        ...getActionContext(),
        data: {
          data: (0, _trigger_utils.toValueClickDataFormat)(key, value)
        }
      };
      action.execute(executeContext);
    }
  };
}