"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetViewForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _decimal_degrees_form = require("./decimal_degrees_form");
var _mgrs_form = require("./mgrs_form");
var _utm_form = require("./utm_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEGREES_DECIMAL = 'dd';
const MGRS = 'mgrs';
const UTM = 'utm';
const COORDINATE_SYSTEM_OPTIONS = [{
  id: DEGREES_DECIMAL,
  label: _i18n.i18n.translate('xpack.maps.setViewControl.decimalDegreesLabel', {
    defaultMessage: 'Decimal degrees'
  })
}, {
  id: UTM,
  label: 'UTM'
}, {
  id: MGRS,
  label: 'MGRS'
}];
class SetViewForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      coordinateSystem: DEGREES_DECIMAL,
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onCoordinateSystemChange", optionId => {
      this._closePopover();
      this.setState({
        coordinateSystem: optionId
      });
    });
  }
  _renderForm() {
    if (this.state.coordinateSystem === MGRS) {
      return /*#__PURE__*/_react.default.createElement(_mgrs_form.MgrsForm, {
        settings: this.props.settings,
        zoom: this.props.zoom,
        center: this.props.center,
        onSubmit: this.props.onSubmit
      });
    }
    if (this.state.coordinateSystem === UTM) {
      return /*#__PURE__*/_react.default.createElement(_utm_form.UtmForm, {
        settings: this.props.settings,
        zoom: this.props.zoom,
        center: this.props.center,
        onSubmit: this.props.onSubmit
      });
    }
    return /*#__PURE__*/_react.default.createElement(_decimal_degrees_form.DecimalDegreesForm, {
      settings: this.props.settings,
      zoom: this.props.zoom,
      center: this.props.center,
      onSubmit: this.props.onSubmit
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mapSetViewForm",
      style: {
        width: 240
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "s",
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "controlsHorizontal",
        size: "xs",
        onClick: this._togglePopover
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.setViewControl.changeCoordinateSystemButtonLabel",
        defaultMessage: "Coordinate system"
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      options: COORDINATE_SYSTEM_OPTIONS,
      idSelected: this.state.coordinateSystem,
      onChange: this._onCoordinateSystemChange
    })), this._renderForm());
  }
}
exports.SetViewForm = SetViewForm;