"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherCategoryColorPicker = OtherCategoryColorPicker;
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mb_validated_color_picker = require("./mb_validated_color_picker");
var _style_util = require("../../style_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OTHER_CATEGORY_SWATCHES = [_uiTheme.euiThemeVars.euiColorLightestShade, _uiTheme.euiThemeVars.euiColorLightShade, _uiTheme.euiThemeVars.euiColorMediumShade, _uiTheme.euiThemeVars.euiColorDarkShade, _uiTheme.euiThemeVars.euiColorDarkestShade];
function OtherCategoryColorPicker(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.maps.colorStops.otherCategoryColorPickerTooltip', {
      defaultMessage: 'When the selected field has more terms than colors in the palette, the rest of the terms are grouped under "Other" category. Select a palette with more colors to increase the number of terms colored in your map'
    })
  }, /*#__PURE__*/_react.default.createElement(_mb_validated_color_picker.MbValidatedColorPicker, {
    swatches: OTHER_CATEGORY_SWATCHES,
    prepend: _style_util.OTHER_CATEGORY_LABEL,
    onChange: props.onChange,
    color: props.color ? props.color : _style_util.OTHER_CATEGORY_DEFAULT_COLOR
  })));
}