"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.KibanaTilemapSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _source = require("../source");
var _util = require("../../../util");
var _i18n = require("@kbn/i18n");
var _i18n_getters = require("../../../../common/i18n_getters");
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../../../../common/constants");
var _extract_attributions = require("./extract_attributions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourceTitle = exports.sourceTitle = _i18n.i18n.translate('xpack.maps.source.kbnTMSTitle', {
  defaultMessage: 'Configured Tile Map Service'
});
class KibanaTilemapSource extends _source.AbstractSource {
  static createDescriptor() {
    return {
      type: KibanaTilemapSource.type
    };
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: sourceTitle
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.kbnTMS.urlLabel', {
        defaultMessage: 'Tilemap url'
      }),
      value: await this.getUrlTemplate()
    }];
  }
  async hasLegendDetails() {
    return false;
  }
  renderLegendDetails() {
    return null;
  }
  isSourceStale(mbSource, sourceData) {
    var _mbSource$tiles;
    if (!sourceData.url) {
      return false;
    }
    return ((_mbSource$tiles = mbSource.tiles) === null || _mbSource$tiles === void 0 ? void 0 : _mbSource$tiles[0]) !== sourceData.url;
  }
  async canSkipSourceUpdate() {
    return false;
  }
  async getUrlTemplate() {
    const tilemap = (0, _util.getKibanaTileMap)();
    if (!tilemap.url) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.kbnTMS.noConfigErrorMessage', {
        defaultMessage: `Unable to find map.tilemap.url configuration in the kibana.yml`
      }));
    }
    return tilemap.url;
  }
  getAttributionProvider() {
    return async () => {
      const tilemap = (0, _util.getKibanaTileMap)();
      const markdown = _lodash.default.get(tilemap, 'options.attribution', '');
      return (0, _extract_attributions.extractAttributions)(markdown);
    };
  }
  async getDisplayName() {
    try {
      return await this.getUrlTemplate();
    } catch (e) {
      return '';
    }
  }
}
exports.KibanaTilemapSource = KibanaTilemapSource;
(0, _defineProperty2.default)(KibanaTilemapSource, "type", _constants.SOURCE_TYPES.KIBANA_TILEMAP);